<?php

if (!empty($this->arrBCPackages)) {

    ?>
<div class="container-region-featured-packages">
    <div class="container">
        <h2 class="title h1 text-center">
            <small><?php echo $this->arrDetails['region_name']; ?></small>
            Recommended Packages
        </h2>

        <div class="featured-packages featured-packages-bc">
            <div>
                <?php
                foreach($this->arrBCPackages as $package) {
                    include(ROOT_DIR.'/application/views/_featured_package.php');
                }
                ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>

<div class="container-content">
    <div class="container">
        <main class="col-lg-8 col-lg-offset-2">

            <header class="detail-header">
                <h1 class="title">
                    <small><?php echo $this->arrDetails['region_subtext']; ?></small>
                    <?php echo $this->arrDetails['region_name']; ?> Courses And Hotels
                </h1>
            </header>

            <div class="content">
                <?php echo ReadMore::readMoreShortcode($this->arrDetails['text1']); ?>
            </div>

            <?php if (!empty($this->arrDetails['text2'])) { ?>
            <h2><?php echo $this->arrDetails['region_subtext2']; ?></h2>
            <div class="content">
                <?php echo $this->arrDetails['text2']; ?>
            </div>
            <?php } ?>

            <?php if (!empty($this->arrDetails['text3']) && strlen($this->arrDetails['text3']) > 10) { ?>
            <h2>Advertisement</h2>
            <div class="content">
                <?php echo $this->arrDetails['text3']; ?>
            </div>
            <?php } ?>

        </main>
    </div>
</div>

<div class="container-map">
    <ul class="gmap-legend">
        <li><span><img src="/application/images/ico-course-deluxe.png" alt="Golf course with packages map icon"> Golf Packages Available</span></li>
        <li><span><img src="/application/images/ico-hotel.png" alt="Hotel map icon"> Hotel</span></li>
    </ul>
    <div id="gmap" class="gmap"></div>
</div>

<?php if (!empty($this->arrCourses)) { ?>
<div class="container-region-courses container-content">
    <div class="container">
        <h2 class="title h3"><?php echo $this->arrDetails['region_name'] . ' Courses'; ?></h2>
        <div class="flex">
            <?php
            foreach($this->arrCourses As $c){
                echo '<a class="btn btn-ghost-primary btn-wrap btn-icon-after" href="/golf-courses/' . $c['slug'] . '" >' . $c['course_name'] . '</a>';
            }
            ?>
        </div>
        <p class="text-center">
            <a href="/bc-golf-course-map/" class="btn btn-primary btn-lg">View BC course map</a>
        </p>
    </div>
</div>
<?php } ?>
<?php
    //include ROOT_DIR . '/application/includes/package_form.php';
?>

<?php include ROOT_DIR . '/application/views/_phone_callout.php'; ?>

<?php
echo Location::getMapData2(array(
    'courses' => $this->arrData->arrCourses,
    'hotels' => $this->arrData->arrHotels,
    'latitude' => $this->arrDetails['rlat'],
    'longitude' => $this->arrDetails['rlong'],
    'zoom' => $this->arrDetails['rzlevel'],
));
?>

<script>
    $(document).ready(function() {
        $('a.link-readmore').click(function(event) {
            $('.content-readmore').show();
            $(this).hide();
            event.preventDefault();
        });
    });
</script>
