<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Admin Login</title>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="/application/css/login.css">
</head>
<body>

	<div class="container">

		<form class="form-login" role="form" method="post">

			<div class="logo">
				<a href="<?php echo ROOT_URL ?>"><img src="/application/images/nav-logo.png" alt="Navigator Multimedia Inc." class="img-responsive"></a>
				<hr>
			</div>

			<?php
			if(isset($strErrorMessage) && $strErrorMessage !='') {
				echo '<div class="alert alert-danger">'.$strErrorMessage.'</div>';
			} else if (!empty($strSuccessMessage)) {
				echo '<div class="alert alert-success">'.$strSuccessMessage.'</div>';
			}
			?>

			<?php if (!empty($_GET['action']) && $_GET['action'] == 'lp') { ?>

				<h2 class="form-login-heading">Password Reset</h2>
				<input type="text" class="form-control" placeholder="Username or Email" name="user_name" required autofocus value="<?php echo $strUserName;?>">
				<p><small class="text-muted"><a href="/admin/">&laquo; Back to Login Form</a></small></p>
				<input type="submit" name="resetPassword" class="btn btn-lg btn-primary btn-block" value="Reset Password">

			<?php } else if (!empty($_GET['action']) && $_GET['action'] == 'rp') { ?>

				<h2 class="form-login-heading">Password Reset</h2>
				<input type="password" class="form-control" placeholder="New Password" name="new_password" required autofocus value="">
				<input type="password" class="form-control" placeholder="Confirm Password" name="new_password2" required value="">
				<p><small class="text-muted"><a href="/admin/">&laquo; Back to Login Form</a></small></p>
				<input type="submit" name="resetPassword" class="btn btn-lg btn-primary btn-block" value="Reset Password">

			<?php } else { ?>

				<h2 class="form-login-heading">Please sign in</h2>
				<input type="text" class="form-control user-name" placeholder="Username" name="user_name" required autofocus value="<?php echo $strUserName;?>">
				<input type="password" class="form-control user-password" placeholder="Password" name="user_password" required value="<?php echo $strUserPassword;?>">
				<p><small class="text-muted"><a href="?action=lp">Forgot password?</a></small></p>
				<input type="submit" name="loginButton" class="btn btn-lg btn-primary btn-block" value="Sign in">

			<?php } ?>

		</form>

	</div> <!-- /container -->
</body>
</html>