<div class="container-content">
    <div class="container">
        <div class="row">
            <main class="col-lg-12">

                <header class="detail-header">
                    <h1 class="title">Recommended Golf Packages</h1>
                </header>

                <?php if (empty($this->strRegionName)) { ?>
                <form method="POST" class="listing-search-form well form-horizontal" role="form">

                    <h4><span class="fa fa-search"></span> Search Packages</h4>

                    <?php /*
                    <div class="form-group">
                        <label for="searchWord" class="col-sm-2 control-label">Search Word:</label>
                        <div class="col-sm-10">
                            <input type="text" name="searchWord" id="searchWord" class="form-control" placeholder="Search Word" value="<?php echo $this->strSearchWord;?>" />
                        </div>
                    </div>
                    */ ?>

                    <div class="form-group">
                        <label for="arrival_date" class="col-sm-2 control-label">Arrival Date:</label>
                        <div class="col-sm-10">
                            <input type="text" name="arrival_date" id="arrival_date" class="datepicker form-control" placeholder="YYYY-MM-DD" value="<?php echo $this->strArrivalDate; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="departure_date" class="col-sm-2 control-label">Departure Date:</label>
                        <div class="col-sm-10">
                            <input type="text" name="departure_date" id="departure_date" class="datepicker form-control" placeholder="YYYY-MM-DD" value="<?php echo $this->strDepartureDate; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="country_id_search" class="col-sm-2 control-label">Country:</label>
                        <div class="col-sm-10">
                            <select name="country_id_search" id="country_id_search" class="form-control">
                                <option value="">Please Choose</option>
                                <option value="261" <?php echo Util::isSelected("261", $this->intCountryId); ?>>CANADA</option>
                                <option value="148" <?php echo Util::isSelected("148", $this->intCountryId); ?>>USA</option>
                                <option value="0" <?php echo Util::isSelected("0", $this->intCountryId); ?>>OTHER</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="region" class="col-sm-2 control-label">Region:</label>
                        <div class="col-sm-10">
                            <select name="region" id="region" class="form-control">
                                <option value="0">Please Choose</option>
                                <?php foreach($this->arrRegions As $r) {
                                    echo '<option value="'.$r['id'].'" '.Util::isSelected($r['id'], $this->intRegionId).'>'.$r['region_name'].'</option>';
                                } ?>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-10 col-sm-offset-2">
                            <button type="submit" class="btn btn-primary" value="Search">Search Packages</button>
                        </div>
                    </div>

                </form>
                <?php } ?>

                <?php if (!empty($this->arrPackages)) { ?>
                <div class="listing-container">

                    <?php Util::getPagination($this->strPg, $this->objFeatured->intPageCount, '/featured-golf-packages/', '', $this->strPgSize); ?>

                    <?php foreach ($this->arrPackages as $arrPackage) {
                        $strTitle = $arrPackage['title'];
                        $strLink = '/featured-golf-packages/'.$arrPackage['slug'].'/';
                        $strDescription = Util::shortenString($arrPackage['excerpt'], 75);
                        $strPrice = Util::formatPrice($arrPackage['price']);
                        $strDates = Util::formatDates(array($arrPackage['end_date']));

                        $strImage = !empty($arrPackage['file_name']) ? $arrPackage['file_name'] : '/application/images/open-graph-image.png';
                        $strImage = Util::createImageSrc($strImage, 445, 300);
                        ?>
                    <article class="listing-item clearfix">
                        <div class="row">
                            <figure class="col-xs-12 col-sm-5">
                                <a href="<?php echo $strLink; ?>">
                                    <img src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>" class="img-responsive">
                                </a>
                            </figure>
                            <div class="col-xs-12 col-sm-7">
                                <h2 class="title">
                                    <small><?php echo $arrPackage['region_name']; ?></small>
                                    <a href="<?php echo $strLink; ?>"><?php echo $arrPackage['title']; ?></a>
                                </h2>
                                <div class="well well-sm small">
                                    This is a recommended package - you are welcome to book this "as is" or customize to your liking.
                                    <br>Prices vary based on season, day of week, event weekends, and occupancy.
                                </div>
                                <div class="description">
                                    <?php echo $strDescription; ?>
                                </div>
                                <a href="<?php echo $strLink; ?>" class="btn btn-primary">See Package Details</a>
                            </div>
                        </div>
                    </article>
                    <?php } ?>

                    <?php Util::getPagination($this->strPg, $this->objFeatured->intPageCount, '/featured-golf-packages/', '', $this->strPgSize); ?>

                </div>
                <?php } ?>

                <?php if (empty($this->arrPackages) && !empty($_POST)) { ?>
                <p>No packages available</p>
                <?php } ?>

            </main>
        </div>
    </div>
</div>

<?php if (!empty($this->arrPackages) && !empty($this->arrDetails)) { ?>

    <div class="container-map">
        <ul class="gmap-legend">
            <li><span><img src="/application/images/ico-course-deluxe.png" alt="Golf course with packages map icon"> Golf Packages Available</span></li>
            <li><span><img src="/application/images/ico-hotel.png" alt="Hotel map icon"> Hotel</span></li>
        </ul>
        <div id="gmap" class="gmap"></div>
    </div>

    <?php
    echo Location::getMapData2(array(
        'courses' => $this->arrCourses,
        'hotels' => $this->arrHotels,
        'latitude' => $this->arrDetails['rlat'],
        'longitude' => $this->arrDetails['rlong'],
        'zoom' => $this->arrDetails['rzlevel'],
    ));
    ?>

<?php } ?>
