<div class="row">
    <div class="col-xs-12" role="main">
        <h1 style="text-transform: capitalize;">Golf Courses</h1>

        <form method="POST" class="listing-search-form">

            <label for"searchWord">Search Courses</label>

                <select name="country" id="country">
                    <?php foreach($this->arrCountries As $c){

                        echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->intCountryId).'>'.$c['country_name'].'</option>';
                    }
                    ?>
                </select>
                <select name="state" id="state">
                    <?php foreach($this->arrStates As $s){

                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->intStateId).'>'.$s['state_name'].'</option>';
                    }
                    ?>
                </select>
                <select name="city" id="city">
                    <?php foreach($this->arrCities As $s){

                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->intCityId).'>'.$s['title'].'</option>';
                    }
                    ?>
                </select>

                <input type="text" name="searchWord" value="<?php echo $this->strSearchWord;?>" />
                <button type="submit" value="Search" >Search</button>
            </label>
        </form>



        <div>

            <div id="gmap" style="width:100%;height:400px;"></div>

            <?php $location = new Location;


            echo $location->getMapData($this,true); ?>





        </div>

<?php //var_dump($this->arrCourses); ?>
                <hr>

        <h3>Get Directions to one of these courses</h3>

        <form method="POST" role="form" class="map-direction-form clearfix">


        <?php if($this->strErrorMessage != '') { ?>

            <div class="alert alert-danger">
                Please type a starting address.
            </div>

        <?php } ?>



            <div class="row">
                <div class="col-xs-12 col-sm-5">
                    <div class="form-group">
                        <label for="start_address">Start Address:</label>
                        <input type="text" name="start_address" id="start_address" class="form-control" value="">
                    </div>
                </div>

                <div class="col-xs-12 col-sm-2">
                    <div class="form-group">
                        <label for="method">Method:</label>
                        <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                            <option value="DRIVING">Driving</option>
                            <option value="WALKING">Walking</option>
                            <option value="BICYCLING">Bicycling</option>
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-5">
                    <div class="form-group">
                        <label for="end_address">Destination:</label><br />

                        <?php //echo $this->arrDetails['item_name']; ?>

                        <input type="hidden" name="eaddr2" id="eaddr2" value="<?php //echo $this->arrDetails['latitude'].' '.$this->arrDetails['longitude']; ?>">


                        <select name="eaddr" id="eaddr" class="form-control">
                            <option value="">Select a Golf Course or Hotel</option>
                            <?php foreach($this->arrCourses As $course) { ?>
                                <option value="<?php echo $course['latitude'].' '.$course['longitude']; ?>"><?php echo $course['course_name'];?></option>
                            <?php } ?>
                        </select>



                    </div>
                </div>
            </div>

            <button type="button" class="btn btn-primary btn-icon-after pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

        </form>

        <hr>

        <div id="directions-panel"></div>


        <hr>

        <?php Util::getPagination($this->strPg, $this->objCourse->intPageCount, '/courses/', '', $this->strPgSize); ?>

        <?php foreach($this->arrCourses As $course) { ?>
        <div class="panel panel-default">
            <div class="panel-heading"><a href="/golf-courses/<?php echo $course['slug'];?>"><?php echo $course['course_name'];?></a></div>
            <div class="panel-body">
                <?php
                if(Util::isFile($course['display_image'])) {
                    echo '<img src="'.$course['display_image'].'" style="max-width:100px;float:left;margin-right:15px;" class="img-responsive" />';
                }
                echo $course['comments'];
                ?>
            </div>
        </div>
        <?php } ?>

        <?php Util::getPagination($this->strPg, $this->objCourse->intPageCount, '/courses/', '', $this->strPgSize); ?>

    </div>

</div>
<!-- /.row -->
