<div class="row">
    <main class="col-lg-8 col-lg-offset-2">

        <header class="detail-header">
            <div class="row">
                <?php if (Util::isFile($this->arrDetails['file_name'])) { ?>
                <div class="col-sm-3">
                    <figure class="detail-image">
                        <img class="img-responsive" src="<?php echo Util::createImageSrc($this->arrDetails['file_name'], 200, 150, 2); ?>" alt="<?php echo $this->arrDetails['hotel_name']; ?>">
                    </figure>
                </div>
                <?php } ?>
                <div class="col-sm-9">
                    <h1 class="title">
                        <small><?php echo implode(', ', array_filter(array($this->arrDetails['address'], $this->arrDetails['city'], $this->arrDetails['state_name']))); ?></small>
                        <?php echo $this->arrDetails['hotel_name']; ?>
                    </h1>
                    <h2><?php echo Hotel::getRating($this->arrDetails['level']); ?></h2>
                </div>
            </div>
        </header>

        <div class="content">
            <?php echo $this->arrDetails['description']; ?>
        </div>

        <div class="tab-container">
            <ul class="nav nav-tabs" role="tablist">
                <li class="active"><a role="tab" data-toggle="tab" href="#photos">Photos</a></li>
                <?php
                if (!empty($this->arrVideos)) {
                    echo '<li><a role="tab" data-toggle="tab" href="#videos">Videos</a></li>';
                }
                if (!empty($this->arrDetails['amenities'])) {
                    echo '<li><a role="tab" data-toggle="tab" href="#amenities">Amenities</a></li>';
                }
                if (!empty($this->arrDetails['latitude']) && !empty($this->arrDetails['longitude'])) {
                    echo '<li><a role="tab" data-toggle="tab" href="#map" id="map_tab">Map</a></li>';
                }
                ?>
            </ul>

            <div class="tab-content">

                <div class="tab-pane active" id="photos">
                    <?php if(!empty($this->arrPhotos)) { ?>
                    <div id="carousel-slider" class="carousel slide" data-ride="carousel">
                        <ol class="carousel-indicators">
                            <?php
                            foreach($this->arrPhotos as $key => $photo) {
                                $class = ($key == 0) ? 'class="active"' : '';
                                echo '<li data-target="#carousel-slider" data-slide-to="'.$key.'" '.$class.'></li>';
                            }
                            ?>
                        </ol>
                        <div class="carousel-inner">
                            <?php foreach ($this->arrPhotos as $key => $photo) { ?>
                            <div class="item <?php if ($key == 0) echo 'active'; ?>">
                                <img src="<?php echo Util::createImageSrc($photo['file_name'], 1600, 900); ?>" alt="<?php echo $photo['alt']; ?>">
                                <div class="carousel-caption">
                                    <?php echo $photo['title']; ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <a class="left carousel-control" href="#carousel-slider" role="button" data-slide="prev">
                            <span class="glyphicon glyphicon-chevron-left"></span>
                        </a>
                        <a class="right carousel-control" href="#carousel-slider" role="button" data-slide="next">
                            <span class="glyphicon glyphicon-chevron-right"></span>
                        </a>
                    </div>
                    <?php } else { ?>

                    <p>No photos for this hotel.</p>

                    <?php } ?>
                </div>

                <?php if (!empty($this->arrDetails['amenities'])) { ?>
                <div class="tab-pane" id="amenities">
                    <?php echo $this->arrDetails['amenities']; ?>
                </div>
                <?php } ?>

                <?php if(!empty($this->arrVideos)) { ?>
                <div class="tab-pane" id="videos">
                    <div class="video-gallery clearfix">
                        <div class="large-video">
                            <h3></h3>
                            <div class="video-container">
                                <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo $this->arrVideos[0]['ykey']; ?>" frameborder="0" allowfullscreen></iframe>
                            </div>
                            <hr>
                        </div>
                        <div class="row">
                            <?php foreach($this->arrVideos As $video) { ?>
                            <div class="col-xs-6 col-sm-4 col-md-3">
                                <div class="thumbnail" data-video="<?php echo $video['ykey']; ?>" data-caption="<?php echo $video['title']; ?>">
                                    <img src="<?php echo $video['image0']; ?>" alt="<?php echo $video['title']; ?>" class="img-responsive">
                                    <div class="caption text-center hidden-xs"><?php echo $video['title']; ?></div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php } ?>

                <?php if (!empty($this->arrDetails['longitude']) && !empty($this->arrDetails['latitude'])) { ?>
                <div class="tab-pane" id="map">
                    <div id="gmap" class="gmap"></div>

                    <hr>

                    <h3>Get Directions</h3>

                    <form method="POST" role="form" class="map-direction-form clearfix">
                        <div class="row">
                            <div class="col-xs-12 col-sm-9">
                                <div class="form-group">
                                    <label for="start_address">Start Address:</label>
                                    <input type="text" name="start_address" id="start_address" class="form-control" value="">
                                    <input type="hidden" name="eaddr" id="eaddr" value="<?php echo $this->arrDetails['latitude'] . ' ' . $this->arrDetails['longitude']; ?>">
                                </div>
                            </div>

                            <div class="col-xs-12 col-sm-3">
                                <div class="form-group">
                                    <label for="method">Method:</label>
                                    <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                                        <option value="DRIVING">Driving</option>
                                        <option value="WALKING">Walking</option>
                                        <option value="BICYCLING">Bicycling</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <button type="button" class="btn btn-primary pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

                    </form>

                    <hr>

                    <div id="directions_panel"></div>

                </div>
                <?php } ?>

            </div><!-- tab content -->

        </div>

    </main>
</div>

<?php
echo Location::getMapData2(array(
    'hotels' => array($this->arrDetails),
    'show_directions' => true,
    'show_directions_id' => 'directions_panel',
    'tab_id' => 'map_tab',
    'map_id' => 'gmap',
    'latitude' => $this->arrDetails['latitude'],
    'longitude' => $this->arrDetails['longitude'],
));
?>
