<?php

global $objSettings;

// Get BC region data
$arrRegions = $objSettings->getRegionsForNav(array(
    'state' => 2,
));

// Add region images and colors
$objRegion  = new Region;
$arrRegionColors = array(
    '#758c20', '#87794e', '#5f7024', '#345625', '#4e6042',
    '#6a9a68', '#707d2d', '#9c9752', '#656101', '#7c8d1b'
);
if (!empty($arrRegions)) {
    foreach ($arrRegions as $i => $arrRegion) {
        $arrRegions[$i]['color']  = $arrRegionColors[array_rand($arrRegionColors)];
        $arrRegions[$i]['images'] = $objRegion->getRegionImageList($arrRegion['id']);
    }
}

// Get testimonials
$arrTestimonials = $objSettings->getRandomTestimonials();

?>
<div class="container-content">
    <div class="container">
        <div class="row">
            <main class="col-lg-8 col-lg-offset-2">

                <header class="detail-header">
                    <h1 class="title"><?php echo $this->strTitle; ?></h1>
                </header>

                <div class="content">
                    <?php echo $this->strContent; ?>
                </div>

            </main>
        </div>
    </div>
</div>

<?php if (!empty($arrRegions)) { ?>
<div class="container-regions">
    <?php foreach ($arrRegions as $i => $arrRegion) { ?>
    <article class="region <?php if ($i % 2 == 0) echo 'region-alt'; ?>" style="background-color: <?php echo $arrRegion['color']; ?>">
        <?php if (!empty($arrRegion['images'][0])) { ?>
        <div class="region-image">
            <div class="img" style="background-image: url(<?php echo Util::createImageSrc($arrRegion['images'][0]['file_name'], 1200, 800); ?>);"></div>
        </div>
        <?php } ?>
        <div class="region-content">
            <h2 class="region-title title"><?php echo $arrRegion['region_name']; ?></h2>
            <p class="region-description"><?php echo Util::shortenString($arrRegion['text1'], 100); ?></p>
            <a href="/region/featured-golf-packages/<?php echo $arrRegion['slug']; ?>/" class="btn btn-ghost-light">View Packages</a>
            <a href="/regions/<?php echo $arrRegion['slug']; ?>/" class="btn btn-link">View Region</a>
        </div>
    </article>
    <?php } ?>
</div>
<?php } ?>

<?php include ROOT_DIR . '/application/views/_phone_callout.php'; ?>

<?php if (!empty($arrTestimonials)) { ?>
<div class="container-testimonials">
    <div class="container">

        <div id="carousel-testimonials" class="carousel slide" data-ride="carousel" data-interval="false">
            <ol class="carousel-indicators">
                <?php foreach ($arrTestimonials as $i => $arrTestimonial) { ?>
                <li data-target="#carousel-testimonials" data-slide-to="<?php echo $i; ?>" class="<?php if($i == 0) echo 'active'; ?>"></li>
                <?php } ?>
            </ol>
            <div class="carousel-inner" role="listbox">
                <?php foreach ($arrTestimonials as $i => $arrTestimonial) { ?>
                <div class="item <?php if ($i == 0) echo 'active'; ?>">
                    <blockquote class="testimonial">
                        <div class="testimonial-content">
                            <?php echo nl2br(strip_tags($arrTestimonial['detail'])); ?>
                        </div>
                        <footer>
                            <?php echo $arrTestimonial['first_name'] . ' ' . $arrTestimonial['last_name']; ?>
                        </footer>
                    </blockquote>
                </div>
                <?php } ?>
            </div>
        </div>

    </div>
</div>
<?php } ?>

<div class="container-callout-map">
    <div class="container">

        <h2 class="h1 title">
            <small>British Columbia</small>
            Golf Courses
        </h2>
        <a href="/bc-golf-course-map/" class="btn btn-primary">View Map</a>

    </div>
</div>

<?php if (!empty($this->arrBCPackages) || !empty($this->arrUsPackages)) { ?>
<div class="container-featured-packages">
    <div class="container">

        <h2 class="h1 title text-center">
            <small>Most Recent</small>
            Recommended Packages
        </h2>

        <?php if(!empty($this->arrBCPackages)) { ?>
        <p><strong>BC &amp; Canadian Golf Packages</strong></p>
        <div class="featured-packages featured-packages-bc">
            <?php
            $arrChunks = array_chunk($this->arrBCPackages, 3);
            foreach ($arrChunks as $i => $arrPackages) {
                echo '<div class="' . ($i > 0 ? 'hidden-xs' : '') . '">';
                foreach($arrPackages as $package) {
                    include(ROOT_DIR.'/application/views/_featured_package.php');
                }
                echo '</div>';
            }
            ?>
        </div>
        <p class="text-center">
            <a href="/featured-golf-packages/" class="btn btn-primary">See all packages</a>
        </p>
        <?php } ?>

        <?php if(!empty($this->arrUSPackages)) { ?>
        <p><strong>US &amp; International Golf Packages</strong></p>
        <div class="featured-packages featured-packages-bc">
            <div>
                <?php
                foreach ($this->arrUSPackages as $i => $package) {
                    include(ROOT_DIR.'/application/views/_featured_package.php');
                }
                ?>
            </div>
        </div>
        <p class="text-center">
            <a href="/featured-golf-packages/" class="btn btn-primary">See all packages</a>
        </p>
        <?php } ?>

    </div>
</div>
<?php } ?>

<div class="container-newsletter">
    <div class="newsletter-form">
        <div class="row">
            <div class="col-sm-6">
                <h2 class="h1">
                    <small>Stay up to date</small>
                    Golf Newsletter
                </h2>
            </div>
            <div class="col-sm-6">
                <a class="btn btn-primary btn-lg btn-block" href="https://visitor.r20.constantcontact.com/d.jsp?llr=y4g6hfdab&p=oi&m=1102908922872&sit=rjd9yqxeb&f=0c64ad07-a27e-4cec-8444-16dd48817d2d" target="_blank">Sign up today</a>
            </div>
        </div>
    </div>
</div>