
<div class="row">
    <main class="col-lg-10 col-lg-offset-1">

    <?php if($this->intStep == 3) { ?>

        <?php if($this->objFeatured->strSuccessMessage != '') { ?>

        <div class="alert alert-success">
            <?php echo ($this->objFeatured->strSuccessMessage ); ?>
        </div>

        <?php } else { ?>

            <?php if($this->objFeatured->strErrorMessage != '') { ?>
            <div class="alert alert-danger">
                <?php echo ($this->objFeatured->strErrorMessage );?>
            </div>
            <?php } ?>

            <form name="feature_package_form" id="feature_package_form" action="/featured-golf-packages/<?php echo $this->arrDetails['slug']; ?>/request/" method="post">
                <h2>Contact Details</h2>
                <div class="form-section">
                    <div class="row">

                        <div class="col-xs-12 col-sm-6">
                            <div class="form-group">
                                <label for="user_name">Your Name: <span class="required">*</span></label>
                                <input class="form-control" type="text" name="user_name" id="user_name" value="<?php echo $this->objFeatured->strUserName; ?>" >
                            </div>
                            <div class="form-group">
                                <label for="user_email">Your Email: <span class="required">*</span></label>
                                <input class="form-control" type="email" name="user_email" id="user_email" value="<?php echo $this->objFeatured->strUserEmail; ?>" >
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-6">
                            <div class="form-group">
                                <label for="phone">Preferred Number to call back on: <span class="required">*</span></label>
                                <input class="form-control" type="tel" name="phone" id="phone" value="<?php echo $this->objFeatured->strUserPhone; ?>" >
                            </div>
                            <div class="form-group">
                                <label for="cell">Cell Number:</label>
                                <input class="form-control" type="tel" name="cell" id="cell" value="<?php echo $this->objFeatured->strCell; ?>" >
                            </div>
                        </div>

                    </div>
                </div>

                <hr>

                <h2>Requested Travel Dates</h2>
                <div class="form-section">
                    <div class="row">

                        <div class="col-xs-12 col-sm-6">
                            <div class="form-group">
                                <label for="dates_arrival">Expected Arrival Date: <span class="required">*</span></label>
                                <input class="form-control datepicker" placeholder="YYYY-MM-DD" type="text" name="dates_arrival" id="dates_arrival" value="<?php echo $this->objFeatured->strDatesArrival; ?>" >
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6">
                            <div class="form-group">
                                <label for="dates_depart">Expected Departure Date: <span class="required">*</span></label>
                                <input class="form-control datepicker" placeholder="YYYY-MM-DD" type="text" name="dates_depart" id="dates_depart" value="<?php echo $this->objFeatured->strDatesDepart; ?>" >
                            </div>
                        </div>

                        <div class="col-xs-12">
                            <label for="tell_us">Tell us about your group? Guys trip - Ladies - Couples? What is your budget per person? <span class="required">*</span></label>
                            <textarea style="margin-bottom: 10px;" class="form-control" placeholder="" rows=5 name="tell_us" id="tell_us"><?php echo $this->objFeatured->strTellUs; ?></textarea>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-xs-12 col-sm-6">
                            <div class="form-group">
                                <label>Are your dates flexible?</label><br>
                                <label class="radio-inline">
                                    <input type="radio" name="date_flex" value="yes"<?php echo Util::isChecked($this->objFeatured->blnDateFlex, 'yes'); ?>> Yes
                                </label>
                                <label class="radio-inline">
                                    <input type="radio" name="date_flex" value="no"<?php echo Util::isChecked($this->objFeatured->blnDateFlex, 'no'); ?>> No
                                </label>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-6">
                            <div class="form-group">
                                <label for="number_golfers">Number of Golfers: <span class="required">*</span></label>
                                <input class="form-control number" type="number" name="number_golfers" id="number_golfers" value="<?php echo $this->objFeatured->intNumberGolfers; ?>" >
                            </div>
                        </div>

                    </div>

                </div>

                <hr>

                <div class="form-section">
                    <div style="width: 300px" class="center-block">
                        <div class="g-recaptcha" data-sitekey="<?php echo GOOGLE_RECAPTCHA_V2_SITE_KEY; ?>"></div>
                        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <div class="col-xs-12 col-sm-6">
                        <div class="package-next-step">
                            <h3>For Personal Service:</h3>
                            <a href="tel:<?php echo Util::formatPhoneLink('1.877.223.7226'); ?>" class="btn btn-secondary btn-lg">1.877.223.7226</a>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6">
                        <div class="package-next-step">
                            <h3>Proceed to the next step:</h3>
                            <button type="submit" name="Submit" value="Request Pricing" class="btn btn-primary btn-icon-after btn-lg">Request Pricing</button>
                        </div>
                    </div>
                </div>

            </form>

        <?php } ?>

    <?php } else { ?>

        <header class="detail-header">
            <h1 class="title">
                <small><?php echo $this->arrDetails['region_name']; ?></small>
                <?php echo $this->arrDetails['title']; ?>
            </h1>
            <?php if (!empty($this->strBack)) { ?>
            <a href="<?php echo $this->strBack; ?>">
                <span class="fa fa-long-arrow-left"></span> Back to Recommended Golf Packages
            </a>
            <?php } ?>
        </header>

        <?php
        if (Util::isFile($this->arrDetails['file_name'])) {
            $strSrc = Util::createImageSrc($this->arrDetails['file_name'], 945, 400);
            echo '<img src="'.$strSrc.'" class="package-img img-responsive" style="margin-bottom: 15px;">';
        }
        ?>

        <div class="well">
            <div class="row">
                <div class="col-sm-9">
                    <p class="small">
                        This is a recommended package - you are welcome to book this "as is" or customize to your liking.
                        <br>Prices vary based on season, day of week, event weekends, and occupancy.
                    </p>
                </div>
                <div class="col-sm-3">
                    <p><a href="/featured-golf-packages/<?php echo $this->arrDetails['slug']; ?>/request/" class="btn btn-primary btn-lg btn-block">Request Pricing</a></p>
                </div>
            </div>
        </div>

        <ul class="nav nav-tabs" id="myTab">
            <li class="package active"><a href="#package" data-toggle="tab" id="package_tab">Package details</a></li>
            <li class="course"><a href="#course" data-toggle="tab" id="course_tab">Course Details</a></li>
            <li class="hotel"><a href="#hotel" data-toggle="tab" id="hotel_tab">Hotel details</a></li>
            <li class="map"><a href="#map" data-toggle="tab" id="map_tab">Map</a></li>
        </ul>
        <div class="tab-content">

            <div class="tab-pane active" id="package">
                <div class="row">
                    <div class="col-sm-4">
                        <?php
                        if (!empty($this->arrHotels)) {
                            foreach ($this->arrHotels as $arrHotel) {
                                $strTitle = $arrHotel['item_name'];
                                $strImage = Util::createImageSrc($arrHotel['display_image'], 360, 230);
                                ?>
                                <figure class="location-preview">
                                    <?php if (Util::isFile($arrHotel['display_image'])) { ?>
                                    <img src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>" class="img-responsive">
                                    <?php } ?>
                                    <figcaption class="caption"><?php echo $strTitle; ?></figcaption>
                                </figure>
                                <?php
                            }
                        }
                        if (!empty($this->arrCourses)) {
                            foreach ($this->arrCourses as $arrCourse) {
                                $strTitle = $arrCourse['item_name'];
                                $strImage = Util::createImageSrc($arrCourse['display_image'], 360, 230);
                                ?>
                                <figure class="location-preview">
                                    <?php if (Util::isFile($arrCourse['display_image'])) { ?>
                                    <img src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>" class="img-responsive">
                                    <?php } ?>
                                    <figcaption class="caption"><?php echo $strTitle; ?></figcaption>
                                </figure>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <div class="col-sm-8">
                        <div class="content">
                            <?php echo Util::nl2br($this->arrDetails['description']); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="hotel">
                <?php
                if (!empty($this->arrHotels)) {
                    foreach($this->arrHotels as $arrHotel) {
                        $strTitle = $arrHotel['item_name'];
                        $strImage = Util::createImageSrc($arrHotel['logo'], 200, 150, 2);
                        $strDescription = $arrHotel['description'];
                        ?>
                        <div class="media">
                            <?php if (Util::isFile($arrHotel['logo'])) { ?>
                            <img src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>" class="media-object pull-left img-responsive">
                            <?php } ?>
                            <div class="media-body">
                                <h3 class="media-heading"><?php echo $strTitle; ?></h3>
                                <div class="content">
                                    <?php echo $strDescription; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>

            <div class="tab-pane" id="course">
                <?php
                if (!empty($this->arrCourses)) {
                    foreach($this->arrCourses as $arrCourse) {
                        $strTitle = $arrCourse['item_name'];
                        $strImage = Util::createImageSrc($arrCourse['logo'], 200, 150, 2);
                        $strDescription = $arrCourse['description'];
                        ?>
                        <div class="media">
                            <?php if (Util::isFile($arrCourse['logo'])) { ?>
                            <img src="<?php echo $strImage; ?>" alt="<?php echo $arrCourse['item_name']; ?>" class="media-object pull-left img-responsive">
                            <?php } ?>
                            <div class="media-body">
                                <h3 class="media-heading"><?php echo $arrCourse['item_name']; ?></h3>
                                <div class="content">
                                    <?php echo $strDescription; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>

            <div class="tab-pane" id="map">
                <div id="gmap" class="gmap"></div>

                <hr>

                <h3>Get Directions</h3>

                <form method="POST" role="form" class="map-direction-form clearfix">

                    <div class="row">
                        <div class="col-xs-12 col-sm-5">
                            <div class="form-group">
                                <label for="start_address">Start Address:</label>
                                <input type="text" name="start_address" id="start_address" class="form-control" value="">
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-2">
                            <div class="form-group">
                                <label for="method">Method:</label>
                                <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                                    <option value="DRIVING">Driving</option>
                                    <option value="WALKING">Walking</option>
                                    <option value="BICYCLING">Bicycling</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-5">
                            <div class="form-group">
                                <label for="end_address">Destination:</label>
                                <select name="eaddr" id="eaddr" class="form-control">
                                    <?php
                                    if (!empty($this->arrCourses)) {
                                        foreach ($this->arrCourses as $arrCourse) {
                                            echo '<option value="' . $arrCourse['latitude'] . ' ' . $arrCourse['longitude'] . '">' . $arrCourse['item_name'] . '</option>';
                                        }
                                    }
                                    if (!empty($this->arrHotels)) {
                                        foreach ($this->arrHotels as $arrHotel) {
                                            echo '<option value="' . $arrHotel['latitude'] . ' ' . $arrHotel['longitude'] . '">' . $arrHotel['item_name'] . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <button type="button" class="btn btn-primary pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

                </form>

                <hr>

                <div id="directions_panel"></div>

            </div>

        </div>

        <div class="package-next-step">
            <h2>Finalize Your Package Details</h2>
            <a href="/featured-golf-packages/<?php echo $this->arrDetails['slug']; ?>/request/" class="btn btn-primary btn-icon-after btn-lg">Request Pricing</a>
        </div>

    <?php } ?>

</div>
<!-- /.row -->

<?php
echo Location::getMapData2(array(
    'courses' => $this->arrCourses,
    'hotels' => $this->arrHotels,
    'show_directions' => true,
    'show_directions_id' => 'directions_panel',
    'tab_id' => 'map_tab',
    'map_id' => 'gmap',
    'latitude' => $this->arrDetails['rlat'],
    'longitude' => $this->arrDetails['rlong'],
    'zoom' => $this->arrDetails['rzlevel']
));
?>
