<div class="row">
    <main class="col-lg-8 col-lg-offset-2">

        <header class="detail-header">
            <div class="row">
                <?php if (Util::isFile($this->arrDetails['display_image'])) { ?>
                <div class="col-sm-3">
                    <figure class="detail-image">
                        <img class="img-responsive center-block" src="<?php echo Util::createImageSrc($this->arrDetails['display_image'], 200, 150, 2); ?>" alt="<?php echo $this->arrDetails['course_name']; ?>">
                    </figure>
                </div>
                <?php } ?>
                <div class="col-sm-9">
                    <h1 class="title">
                        <small><?php echo implode(', ', array_filter(array($this->arrDetails['address'], $this->arrDetails['city'], $this->arrDetails['state_name']))); ?></small>
                        <?php echo $this->arrDetails['course_name']; ?>
                    </h1>
                    <!-- <h2><?php echo Course::getRating($this->arrDetails['level']); ?></h2> -->
                </div>
            </div>
        </header>

        <div class="content">
            <?php echo $this->arrDetails['comments']; ?>
        </div>

        <div class="tab-container">
            <ul class="nav nav-tabs" role="tablist">
                <li class="active"><a role="tab" data-toggle="tab" href="#photos">Photos</a></li>
                <?php
                if (!empty($this->arrVideos)) {
                    echo '<li><a role="tab" data-toggle="tab" href="#videos">Videos</a></li>';
                }
                // 3 = resort course preferred
                // 4 = basic courses
                // 5 = deluxe courses
                if ($this->arrDetails['type_id'] == 3 || $this->arrDetails['type_id'] == 4 || $this->arrDetails['type_id'] == 5) {
                    echo '<li><a role="tab" data-toggle="tab" href="#contact">Contact Info</a></li>';
                }
                if (!empty($this->arrDetails['latitude']) && !empty($this->arrDetails['longitude'])) {
                    echo '<li><a role="tab" data-toggle="tab" href="#map" id="map_tab">Map</a></li>';
                }
                if (!empty($this->arrHoleInOnes)) {
                    echo '<li><a role="tab" data-toggle="tab" href="#holes-in-one">Holes in One</a></li>';
                }
                if (!empty($this->arrTestimonials)) {
                    echo '<li><a role="tab" data-toggle="tab" href="#testimonials">Testimonials</a></li>';
                }
                ?>
                <li><a target="_blank" href="https://www.google.com/maps/place/BCgolfguide.com/@49.8784132,-119.4363363,17z/data=!4m7!3m6!1s0x537d8bcfeb1aaaaf:0x1330fa26499cd2c!8m2!3d49.8784132!4d-119.4341476!9m1!1b1">Google Golf Trip Review</a></li>
            </ul>

            <div class="tab-content">

                <div class="tab-pane active" id="photos">
                    <?php if (!empty($this->arrPhotos)) { ?>
                    <div id="carousel-slider" class="carousel slide" data-ride="carousel">
                        <ol class="carousel-indicators">
                            <?php
                            foreach($this->arrPhotos as $key => $photo) {
                                $class = ($key == 0) ? 'class="active"' : '';
                                echo '<li data-target="#carousel-slider" data-slide-to="'.$key.'" '.$class.'></li>';
                            }
                            ?>
                        </ol>
                        <div class="carousel-inner">
                            <?php
                            foreach($this->arrPhotos as $key => $photo) {
                                $class = ($key == 0) ? 'active' : '';
                                $strImage = Util::createImageSrc($photo['file_name'], 850, 475);
                                ?>
                                <div class="item <?php echo $class; ?>">
                                    <img src="<?php echo $strImage; ?>" alt="<?php echo $photo['alt']; ?>">
                                    <div class="carousel-caption">
                                        <?php echo $photo['title']; ?>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                        <a class="left carousel-control" href="#carousel-slider" role="button" data-slide="prev">
                            <span class="glyphicon glyphicon-chevron-left"></span>
                        </a>
                        <a class="right carousel-control" href="#carousel-slider" role="button" data-slide="next">
                            <span class="glyphicon glyphicon-chevron-right"></span>
                        </a>
                    </div>
                    <?php } else { ?>

                    <p>No photos for this course.</p>

                    <?php } ?>
                </div>

                <?php if (!empty($this->arrVideos)) { ?>
                <div class="tab-pane" id="videos">
                    <div class="video-gallery">
                        <div class="large-video">
                            <div class="video-container">
                                <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo $this->arrVideos[0]['ykey']; ?>" frameborder="0" allowfullscreen></iframe>
                            </div>
                            <h3><?php echo $this->arrVideos[0]['title']; ?></h3>
                            <hr>
                        </div>
                        <div class="row">
                            <?php foreach($this->arrVideos As $video) { ?>
                            <div class="col-xs-6 col-sm-4 col-md-3">
                                <div class="thumbnail" data-video="<?php echo $video['ykey']; ?>" data-caption="<?php echo $video['title']; ?>">
                                    <img src="<?php echo $video['image0']; ?>" alt="<?php echo $video['title']; ?>" class="img-responsive">
                                    <div class="caption text-center hidden-xs"><?php echo $video['title']; ?></div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php } ?>

                <div class="tab-pane" id="contact">
                    <ul class="list-unstyled">
                        <?php
                        // 3 = resort course preferred
                        // 4 = basic courses
                        // 5 = deluxe courses
                        if (!empty($this->arrDetails['teetimes_phone']) ) {
                            echo '<li><strong><span class="fa fa-phone"></span> Tee Times:</strong> <a href="tel:'.Util::formatPhoneLink($this->arrDetails['teetimes_phone']).'">'.$this->arrDetails['teetimes_phone'].'</a></li>';
                        }
                        if ($this->arrDetails['type_id'] == 3 || $this->arrDetails['type_id'] == 4 || $this->arrDetails['type_id'] == 5) {
                            if(!empty($this->arrDetails['web_url']) && ($this->arrDetails['type_id'] == 5 || $this->arrDetails['type_id'] == 3)) {
                                echo '<li><strong><span class="fa fa-globe"></span> Website:</strong> <a href="'.$this->arrDetails['web_url'].'">'.$this->arrDetails['web_url'].'</a></li>';
                            }
                            if(!empty($this->arrDetails['facebook_url']) && ($this->arrDetails['type_id'] == 5 || $this->arrDetails['type_id'] == 3)) {
                                echo '<li><strong><span class="fa fa-facebook-square"></span> Facebook:</strong> <a href="'.$this->arrDetails['facebook_url'].'">'.$this->arrDetails['facebook_url'].'</a></li>';
                            }
                            if(!empty($this->arrDetails['twitter_url']) && ($this->arrDetails['type_id'] == 5 || $this->arrDetails['type_id'] == 3)) {
                                echo '<li><strong><span class="fa fa-twitter-square"></span> Twitter:</strong> <a href="'.$this->arrDetails['twitter_url'].'">'.$this->arrDetails['twitter_url'].'</a></li>';
                            }
                        }
                        ?>
                    </ul>
                </div>

                <?php if (!empty($this->arrHoleInOnes)) { ?>
                <div class="tab-pane" id="holes-in-one">
                    <?php foreach($this->arrHoleInOnes As $hio) { ?>
                    <div class="hio">
                        <h3><?php echo $hio['first_name'] . ' ' . $hio['last_name'] . ' - ' . $hio['post_date']; ?></h3>
                        <ul class="list-unstyled">
                            <li><strong>Hole:</strong> <?php echo $hio['hole']; ?></li>
                            <li><strong>Length:</strong> <?php echo $hio['length']; ?></li>
                            <li><strong>Club:</strong> <?php echo $hio['club_used']; ?></li>
                        </ul>
                    </div>
                    <hr>
                    <?php } ?>
                </div>
                <?php } ?>

                <?php if (!empty($this->arrTestimonials)) { ?>
                <div class="tab-pane" id="testimonials">
                    <?php foreach($this->arrTestimonials As $testimonial) { ?>
                    <blockquote>
                        <p><?php echo nl2br($testimonial['detail']); ?></p>
                        <footer><?php echo $testimonial['first_name'] . ' ' . $testimonial['last_name'];  ?></footer>
                    </blockquote>
                    <hr>
                    <?php } ?>
                </div>
                <?php } ?>

                <?php if (!empty($this->arrDetails['longitude']) && !empty($this->arrDetails['latitude'])) { ?>
                <div class="tab-pane" id="map">
                    <div id="gmap" class="gmap"></div>

                    <hr>

                    <h3>Get Directions</h3>

                    <form method="POST" role="form" class="map-direction-form clearfix">
                        <div class="row">
                            <div class="col-xs-12 col-sm-9">
                                <div class="form-group">
                                    <label for="start_address">Start Address:</label>
                                    <input type="text" name="start_address" id="start_address" class="form-control" value="">
                                    <input type="hidden" name="eaddr" id="eaddr" value="<?php echo $this->arrDetails['latitude'] . ' ' . $this->arrDetails['longitude']; ?>">
                                </div>
                            </div>

                            <div class="col-xs-12 col-sm-3">
                                <div class="form-group">
                                    <label for="method">Method:</label>
                                    <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                                        <option value="DRIVING">Driving</option>
                                        <option value="WALKING">Walking</option>
                                        <option value="BICYCLING">Bicycling</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <button type="button" class="btn btn-primary pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

                    </form>

                    <hr>

                    <div id="directions_panel"></div>

                </div>
                <?php } ?>

                <div class="tab-pane" id="reviews">
                    <!--
                    <?php //if (!empty($this->arrReviews)) { ?>
                    <div class="course-reviews">
                        <?php //foreach($this->arrReviews As $review) { ?>
                        <blockquote>
                            <p><?php //echo nl2br($review['detail']); ?></p>
                            <footer><?php //echo $review['first_name'] . ' ' . $review['last_name']; ?></footer>
                        </blockquote>
                        <hr>
                        <?php //} ?>
                    </div>
                    <?php //} else { ?>

                    <p>There are no reviews for this course.</p>

                    <?php //} ?>
                    -->



                    <p><a class="btn btn-primary" href="/golf-courses/<?php echo $this->arrDetails['slug'] ?>/reviews/">Submit a Review</a></li></p>
                </div>

            </div>
        </div>

    </main>
</div>

<?php
echo Location::getMapData2(array(
    'courses' => array($this->arrDetails),
    'show_directions' => true,
    'show_directions_id' => 'directions_panel',
    'tab_id' => 'map_tab',
    'map_id' => 'gmap',
    'latitude' => $this->arrDetails['latitude'],
    'longitude' => $this->arrDetails['longitude'],
));
?>
