<?php

global $objSettings;

$objPartner = $this->objModel;
$arrDetails =  $objPartner->arrDetails;
$objController = $this;

// Nav variables
$arrNavSteps = array(
    1 => '1. Choose Your Courses',
    2 => '2. Choose Your Hotels',
    3 => '3. Additional Details',
    4 => '4. Overview',
);
$blnNavPrev  = $objPartner->intStep > 1 ? true : false;
$blnNavNext  = $objPartner->intStep < 5 ? true : false;
$blnReadonly = $objPartner->intStep > 3 ? true : false;

$strNavPrev = 'Prev Step';
$strNavNext = $objPartner->intStep == 4 ? 'Submit Package Request' : 'Next Step';

// Form submission URLs
$strForm = '/' . $objPartner->strBaseUrl . '/' . $objPartner->strIdentUrl . '/';
$strFormNext = $strForm . ($objPartner->intStep + 1) . '/';
$strFormPrev = $strForm . ($objPartner->intStep - 1) . '/';

?>
<div class="container-content">
    <div class="container">
        <main>

            <?php if ($objPartner->intStep < 5) { ?>

            <header>
                <h1 class="title pull-left">
                    <small><?php echo $this->objPage->strTitle; ?></small>
                    <?php echo !empty($arrNavSteps[$objPartner->intStep]) ? $arrNavSteps[$objPartner->intStep] : ''; ?>
                </h1>
            </header>

            <form method="post" action="<?php echo $strFormNext; ?>" onsubmit="return check_form();">
                <input type="hidden" id="step" value="<?php echo $objPartner->intStep; ?>">

                <ul class="package-nav list-inline pull-right">
                    <?php if ($blnNavPrev) { ?>
                    <li><a class="btn btn-primary" href="<?php echo $strFormPrev; ?>"><?php echo $strNavPrev; ?></a></li>
                    <?php } ?>
                    <?php if ($blnNavNext) { ?>
                    <li><button type="submit" class="btn btn-primary"><?php echo $strNavNext; ?></button></li>
                    <?php } ?>
                </ul>

                <div class="clearfix"></div>

                <div class="package-builder">
                    <div class="col-sm-3 padding-none">

                        <div class="package-controls">
                            <h2 class="package-controls-title">Package Overview</h2>
                            <div class="form-group">
                                <label>Region</label>
                                <input type="text" class="form-control" readonly value="<?php echo $objPartner->arrRegion['region_name']; ?>">
                            </div>
                            <div class="form-group">
                                <label for="arrival_date">Arrival Date</label>
                                <input type="text" name="arrival_date" id="arrival_date" class="form-control <?php if (!$blnReadonly) echo 'datepicker-future'; ?>" data-min-date="0" autocomplete="off" <?php if ($blnReadonly) echo 'readonly'; ?> value="<?php echo $_SESSION['package']['arrival_date']; ?>">
                            </div>
                            <div class="form-group">
                                <label for="departure_date">Departure Date</label>
                                <input type="text" name="departure_date" id="departure_date" class="form-control <?php if (!$blnReadonly) echo 'datepicker-future'; ?>" data-min-date="0" autocomplete="off" <?php if ($blnReadonly) echo 'readonly'; ?> value="<?php echo $_SESSION['package']['depart_date']; ?>">
                            </div>
                            <div class="form-group">
                                <strong>Selected Courses</strong>
                                <ul id="selected-courses" class="list-unstyled">
                                    <?php
                                    if (!empty($_SESSION['package']['selected_courses'])) {
                                        $objPartner->getCoursesForBuilder($_SESSION['package']['selected_courses']);
                                    }
                                    ?>
                                </ul>
                            </div>
                            <div class="form-group">
                                <strong>Selected Hotels</strong>
                                <ul id="selected-hotels" class="list-unstyled">
                                    <?php
                                    if (!empty($_SESSION['package']['selected_hotels'])) {
                                        $objPartner->getHotelsForBuilder($_SESSION['package']['selected_hotels']);
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>

                    </div>
                    <div class="col-sm-9 padding-none">

                        <nav class="package-steps">
                            <?php
                            foreach ($arrNavSteps as $i => $strStep) {
                                // Set the step text
                                $strText = 'Step ' . $i;

                                // Set the step class
                                if ($i == $objPartner->intStep) {
                                    $strClass = 'active';
                                } else if ($i < $objPartner->intStep) {
                                    $strClass = 'prev';
                                } else {
                                    $strClass = '';
                                }

                                if ($objPartner->intStep >= $i) {
                                    $strLink = $strForm . $i . '/';
                                    echo '<a href="' . $strLink . '" class="' . $strClass . '">' . $strText . '</a>';
                                } else {
                                    echo '<button type="submit" class="' . $strClass . '">' . $strText . '</button>';
                                }
                            }
                            ?>
                        </nav>

                        <?php include(ROOT_DIR.'/application/views/_partner_step_'.$this->intStep.'.php'); ?>

                    </div>
                </div>
            </form>

            <?php } else { ?>

            <div class="well">
                <?php echo Util::nl2br(str_replace("[client_name]", $objPartner->strUserName, $objPartner->strInquiryText)); ?>
            </div>

            <div class="row">
                <div class="col-sm-6 text-center">
                    <div class="package-next-step">
                        <h2>
                            <small>Stay up to date</small>
                            Golf Newsletter
                        </h2>
                        <a class="btn btn-primary" href="https://visitor.r20.constantcontact.com/d.jsp?llr=y4g6hfdab&p=oi&m=1102908922872&sit=rjd9yqxeb&f=0c64ad07-a27e-4cec-8444-16dd48817d2d" target="_blank">Sign up today</a>
                    </div>
                </div>
                <div class="col-sm-6 text-center">
                    <div class="package-next-step">
                        <h2>
                            <small>Connect with us</small>
                            Social Media
                        </h2>
                        <?php echo $objSettings->getSocialMediaBar(); ?>
                    </div>
                </div>
            </div>

            <?php } ?>

        </main>
    </div>
</div>

<?php include ROOT_DIR . '/application/views/_phone_callout.php'; ?>

<div class="package-background"></div>
