<?php
// Set the control toggle values (opposite)
$intPackagesToggle = $this->intPackages == 1 ? 0 : 1;
$intOtherToggle = $this->intOther == 1 ? 0 : 1;

// Build the toggle strings
$strPackage = '?packages=' . $intPackagesToggle . '&other=' . $this->intOther;
$strOther   = '?packages=' . $this->intPackages . '&other=' . $intOtherToggle;

?>

<div class="container-content">
    <div class="container">

        <main class="col-lg-8 col-lg-offset-2">
            <header class="detail-header">
                <h1 class="title">
                    <small>BC Golf Courses</small>
                    <?php echo $this->arrDetails['title'];?>
                </h1>
            </header>

            <div class="content">
                <p>Our BC golf map allows you to search for all British Columbia golf courses (over 330), by default only about 80+ BC golf courses are displayed, the ones we partner with for our BC golf packages. You can toggle to view all of the courses in British Columbia. There is also a search tool at the bottom of the page to find BC golf courses by name / region / and key word.</p>
            </div>
        </main>

    </div>
</div>

<div class="container-map">
    <ul class="gmap-legend">
        <li class="<?php if ($this->intPackages) echo 'active'; ?>"><a href="<?php echo $strPackage; ?>"><img src="/application/images/ico-course-deluxe.png" alt="Golf course with packages map icon"> Golf Packages Available</a></li>
        <li class="<?php if ($this->intOther) echo 'active'; ?>"><a href="<?php echo $strOther; ?>"><img src="/application/images/ico-course-basic.png" alt="Golf course map icon"> All Other Courses</a></li>
    </ul>
    <div id="gmap" class="gmap"></div>
</div>

<div class="container-content">
    <div class="container">
        <div class="col-lg-8 col-lg-offset-2">

            <div class="bc-regions">
                <!-- <h3 class="title">BC Golf Map Regions</h3> -->
                <div class="content">
                    <?php echo $this->arrDetails['content']; ?>
                </div>
            </div>

            <h3>All BC Golf Courses</h3>
            <div class="bc-courses">
                <form class="course-filters">
                    <div id="course-region" class="filter-group">
                        <div class="form-group">
                            <span class="fa fa-map-marker"></span>
                            <select name="course_region" class="form-control">
                                <option value="">All Regions</option>
                                <?php foreach ($this->arrBCRegions as $arrRegion) { ?>
                                <option value="<?php echo $arrRegion['id'] ?>"><?php echo $arrRegion['region_name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div id="course-sort" class="filter-group">
                        <div class="form-group">
                            <span class="fa fa-sort-alpha-asc"></span>
                            <select name="course_sort" class="form-control">
                                <option value="asc">Ascending</option>
                                <option value="desc">Descending</option>
                            </select>
                        </div>
                    </div>
                    <div id="course-search" class="filter-group">
                        <div class="form-group">
                            <span class="fa fa-search"></span>
                            <input type="text" name="course_search" class="form-control" value="">
                        </div>
                    </div>
                    <div id="course-pagination" class="filter-group">
                        <span>Page</span>
                        <input type="text" name="course_page" id="course-page" class="form-control" value="1">
                        <span>of <span id="course-pages">1</span></span>
                        <a class="course-prev fa fa-angle-left" href="#" data-page="0"></a>
                        <a class="course-next fa fa-angle-right" href="#" data-page="2"></a>
                    </div>
                </form>
                <div class="course-results">
                    <!-- Filled with AJAX -->
                </div>
            </div>

        </div>
    </div>
</div>

<?php include ROOT_DIR . '/application/views/_phone_callout.php'; ?>

<?php if (!empty($this->arrBCPackages)) { ?>
<div class="container-region-featured-packages">
    <div class="container">
        <h2 class="title h1 text-center">
            <small>British Columbia</small>
            Recommended Packages
        </h2>

        <div class="featured-packages featured-packages-bc">
            <div>
                <?php
                foreach($this->arrBCPackages as $package) {
                    include(ROOT_DIR.'/application/views/_featured_package.php');
                }
                ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>

<?php
echo Location::getMapData2(array(
    'courses' => $this->arrData->arrCourses,
    'latitude' => 50,
    'longitude' => -122,
    'zoom' => 6,
));
?>

    <?php
        //include ROOT_DIR . '/application/includes/package_form.php';
    ?>
