<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="grid-view">

	<h1 class="page-header">
		<?php echo $this->strTitle; ?>
	</h1>

	<form class="grid-filters" role="form" method='get'>

		<?php if($this->blnShowFilters) { ?>
            <div class="row">

                <div class="col-xs-12 filter-bar form-inline">

                    <strong>Filters:</strong>

                    <?php if (!empty($this->arrCategories)) { ?>
                    <div class="form-group">
                        <select name="grid_categories" id="" class="form-control input-sm" >
                            <option value="">All Categories</option>
                            <?php foreach($this->arrCategories AS $cat) {
                                echo '<option value="'.$cat['id'].'" '.Util::isSelected($cat['id'], $this->intGridCategories) .'>'.$cat['title'].'</option>';
                            } ?>
                        </select>
                    </div>
                    <?php } ?>

                    <?php if(count($this->arrFilter) > 0) { ?>
                    <div class="form-group">
                        <select name="filter_type" class="form-control input-sm">
                            <?php foreach($this->arrFilter As $key=>$f) {
                                echo '<option value="'.$f.'" '.Util::isSelected($f, $this->strFilterType).'>'.$key.'</option>';
                            } ?>
                        </select>
                    </div>
                    <?php } ?>
<!--
                    <div class="form-group">
                        <select name="year" id="year" class="form-control input-sm">
                            <?php
                            $y = Date('Y') + 5;
                            for($i = $y;$i > ($y-11);$i--){
                                echo '<option value="'.$i.'" '.util::isSelected($i,$this->intYear).'>'.$i.'</option>';
                            }

                            ?>
                        </select>
                    </div>
-->
                    <?php if ($this->blnShowAgencyFilter) { ?>
                        <?php if (!empty($this->arrAgency)) { ?>
                        <div class="form-group">
                            <label for="grid_agency" class="sr-only">Agency:</label>
                            <select name="grid_agency" class="form-control input-sm">
                                <option value="">- Agency -</option>
                                <?php
                                foreach ($this->arrAgency as $value) {
                                    echo '<option value="' . $value['id'] . '" ' . Util::isSelected($value['id'], $this->strGridAgency) . '>' . $value['business_name'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <?php } ?>
                        <?php if (!empty($this->arrAgent)) { ?>
                        <div class="form-group">
                            <label for="grid_agent" class="sr-only">Agent:</label>
                            <select name="grid_agent" class="form-control input-sm">
                                <option value="">- Agent -</option>
                                <?php
                                foreach ($this->arrAgent as $value) {
                                    echo '<option value="' . $value['id'] . '" ' . Util::isSelected($value['id'], $this->strGridAgent) . '>' . $value['booking_name'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <?php } ?>
                    <?php } ?>

                    <?php if ($this->blnShowRangeFilter) { ?>

                    <div class="form-group">
                        <label for="grid_date" class="sr-only">Order By:</label>
                        <select name="grid_date" class="form-control input-sm">
                            <option value="">Please Choose</option>
                            <option value="order_date" <?php echo Util::isSelected('order_date', $this->strGridDateType); ?>>Order Date</option>
                            <option value="dates_arrival" <?php echo Util::isSelected('dates_arrival', $this->strGridDateType); ?>>Arrival Date</option>
                            <option value="dates_depart" <?php echo Util::isSelected('dates_depart', $this->strGridDateType); ?>>Departure Date</option>
                            <option value="edit_date" <?php echo Util::isSelected('edit_date', $this->strGridDateType); ?>>Edit Date</option>
                            <option value="dates_booking" <?php echo Util::isSelected('dates_booking', $this->strGridDateType); ?>>Booking Date</option>
                        </select>
                    </div>

                    <input type="text" placeholder="Start Date" class="form-control datepicker input-sm" value="<?php echo $this->strStartDate; ?>" name="start_date" />
                    <input type="text" placeholder="End Date" class="form-control datepicker input-sm" value="<?php echo $this->strEndDate; ?>" name="end_date" />


                    <?php  } else if($this->blnShowMonthFilter) { ?>
                    <div class="form-group">
                        <select name="month" id="month" class="form-control input-sm">
                            <option value="">Please Choose</option>
                            <option value="1" <?php echo util::isSelected("1",$this->intMonth);?>>January</option>
                            <option value="2" <?php echo util::isSelected("2",$this->intMonth);?>>Febuary</option>
                            <option value="3" <?php echo util::isSelected("3",$this->intMonth);?>>March</option>
                            <option value="4" <?php echo util::isSelected("4",$this->intMonth);?>>April</option>
                            <option value="5" <?php echo util::isSelected("5",$this->intMonth);?>>May</option>
                            <option value="6" <?php echo util::isSelected("6",$this->intMonth);?>>June</option>
                            <option value="7" <?php echo util::isSelected("7",$this->intMonth);?>>July</option>
                            <option value="8" <?php echo util::isSelected("8",$this->intMonth);?>>August</option>
                            <option value="9" <?php echo util::isSelected("9",$this->intMonth);?>>September</option>
                            <option value="10" <?php echo util::isSelected("10",$this->intMonth);?>>October</option>
                            <option value="11" <?php echo util::isSelected("11",$this->intMonth);?>>November</option>
                            <option value="12" <?php echo util::isSelected("12",$this->intMonth);?>>December</option>
                        </select>
                    </div>
                    <?php } ?>
                    <!-- <input type="text" placeholder="Start Date" class="form-control datepicker input-sm" value="<?php echo $this->strStartDate; ?>" name="start_date" /> -->
                    <!-- <input type="text" placeholder="End Date" class="form-control datepicker input-sm" value="<?php echo $this->strEndDate; ?>" name="end_date" /> -->

                    <input type="submit" name="bulk" id="bulk2" class="btn btn-secondary btn-sm" value="Apply">
                    <?php if($this->blnShowExport) { ?>
                    <input type="submit" name="export" class="btn btn-default btn-sm" value="Export As CSV">
                    <?php } ?>
                    <div class="pull-right" style="width: 150px">
                        <div class="input-group">
                            <input type="text" value="<?php echo $this->strPgSize;?>" name="pgSize" class="form-control input-sm" />
                            <div class="input-group-btn">
                                <input type="submit" class="btn btn-default btn-sm" value="Apply">

                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>

                    <?php if($this->blnShowMonthFilter) { ?>
                    <div class="filter-date">
                        <div class="filter-title">
                            <a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear)-1; ?>/?s=true<?php echo $this->strOptions; ?>">&laquo;</a> <b><?php echo $this->intYear; ?></b> <a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear)+1; ?>/?s=true<?php echo $this->strOptions; ?>">&raquo;</a>
                        </div>
                        <ul>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/1/?s=true<?php echo $this->strOptions; ?>">Jan</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/2/?s=true<?php echo $this->strOptions; ?>">Feb</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/3/?s=true<?php echo $this->strOptions; ?>">Mar</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/4/?s=true<?php echo $this->strOptions; ?>">Apr</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/5/?s=true<?php echo $this->strOptions; ?>">May</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/6/?s=true<?php echo $this->strOptions; ?>">Jun</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/7/?s=true<?php echo $this->strOptions; ?>">Jul</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/8/?s=true<?php echo $this->strOptions; ?>">Aug</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/9/?s=true<?php echo $this->strOptions; ?>">Sep</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/10/?s=true<?php echo $this->strOptions; ?>">Oct</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/11/?s=true<?php echo $this->strOptions; ?>">Nov</a></li>
                            <li><a href="<?php echo $this->strAdminSlug; ?>/<?php echo ($this->intYear); ?>/12/?s=true<?php echo $this->strOptions; ?>">Dec</a></li>
                        </ul>
                    </div>
                    <?php } ?>

                </div>
            <!-- Filters -->
            <?php } ?>
		<div class="grid-table-header">
			<div class="row">

				<div class="col-xs-12">
					<?php
			        if($this->strErrorMessage != '') {
			            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
			        } else if($this->strSuccessMessage != '') {
			            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
			        }
			        ?>
				</div>

			</div>

		</div>



		<div class="table-responsive">
			<table class="table text-small">
				<thead>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, '?year='.($this->intYear).'&amp;month='.($this->intMonth).$this->strOptions ); ?>
				</thead>

				<tfoot>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, '?year='.($this->intYear).'&amp;month='.($this->intMonth).$this->strOptions ); ?>
				</tfoot>

				<tbody>
					<?php 
					foreach($this->arrDetails As $page) {
						?>


						<tr>
							<td>
								<div style="font-weight: bold;">
									<h2><?php echo ucwords($page['course_name']);?></h2>
								</div>

								<div class="table-responsive" style="margin-left: 10px;">
									<table class="table table-hover text-small">
										<thead>
											<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrDetailTableSQLArray, $this->arrDetailTableDisplayArray, $this->arrDetailTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, '?year='.($this->intYear).'&amp;month='.($this->intMonth).$this->strOptions ); ?>
										</thead>

										<tbody>

											<?php 

											foreach($page['detail_records'] as $arrDetailRecord){
												?>
												<tr>
													<td>
														<a href="/admin/package/edit/<?php echo $arrDetailRecord['package_id'];?>/"><?php echo $arrDetailRecord['group_name'];?></a>
													</td>
													<td><?php echo $arrDetailRecord['tee_date'];?></td>
													<td><?php echo $arrDetailRecord['tee_time'];?> <?php echo $arrDetailRecord['tee_ap'];?></td>
													<td><?php echo $arrDetailRecord['golfer_num'];?></td>
													<td><?php echo $arrDetailRecord['carts'];?></td>
													<td><?php echo $arrDetailRecord['range_ball'];?></td>
													<td><?php echo $arrDetailRecord['shuttle'];?></td>
													<td><?php echo $arrDetailRecord['rental_club'];?></td>
													<td><?php echo $arrDetailRecord['track_code'];?></td>
													<td><?php echo $arrDetailRecord['net_rate'];?></td>
													<td><?php echo $arrDetailRecord['confirm_num'];?></td>
													<td><?php echo '<select onchange="save_paid(this.options[this.selectedIndex].value,\'course\','.$arrDetailRecord["id"].');">
										                      <option value="1" ';

										                if($arrDetailRecord["paidout"] == 1) {
										                	echo 'selected="selected"';
										                }

										                echo '>yes</option><option value="0" ';

										                if($arrDetailRecord["paidout"] == 0) {
										                	echo 'selected="selected"';
										                }

										                echo '>no</option></select>';?>
										            </td>
												</tr>
												<?php 
											}

											?>

										</tbody>
									</table>
								</div>
							</td>
						</tr>

						<!-- <tr>
							<td>
								<div class="table-responsive">
									<table class="table table-hover text-small">
										<thead>
											<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrDetailTableSQLArray, $this->arrDetailTableDisplayArray, $this->arrDetailTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, '?year='.($this->intYear).'&amp;month='.($this->intMonth).$this->strOptions ); ?>
										</thead>

										<tbody>

											<?php 

											foreach($page['detail_records'] as $arrDetailRecord){
												?>
												<tr>
													<td>
														<a href="/admin/package/edit/<?php echo $arrDetailRecord['package_id'];?>/"><?php echo $arrDetailRecord['group_name'];?></a>
													</td>
													<td><?php echo $arrDetailRecord['tee_date'];?></td>
													<td><?php echo $arrDetailRecord['tee_time'];?> <?php echo $arrDetailRecord['tee_ap'];?></td>
													<td><?php echo $arrDetailRecord['golfer_num'];?></td>
													<td><?php echo $arrDetailRecord['carts'];?></td>
													<td><?php echo $arrDetailRecord['range_ball'];?></td>
													<td><?php echo $arrDetailRecord['shuttle'];?></td>
													<td><?php echo $arrDetailRecord['rental_club'];?></td>
													<td><?php echo $arrDetailRecord['track_code'];?></td>
													<td><?php echo $arrDetailRecord['net_rate'];?></td>
													<td><?php echo $arrDetailRecord['confirm_num'];?></td>
													<td>
														<?php

														if($arrDetailRecord["paidout"] == 1){
															echo 'Yes';
														}else{
															echo 'No';
														}

														?>
													</td>
												</tr>
												<?php 
											}

											?>

										</tbody>
									</table>
								</div>
							</td>
						</tr> -->

						<?php 
					}

					?>
				</tbody>
			</table>
		</div>

		<hr>

		<div class="grid-table-footer">
			<div class="row">

				<div class="col-xs-12 col-sm-6">
					<?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, '?year='.($this->intYear).'&amp;month='.($this->intMonth).$this->strOptions, $this->strPgSize); ?>
				</div>

			</div>

			<hr>

		</div>

	</form>

</div>
