<?php 

include('application/includes/admin/header.php');

$strYear = date('Y');

?>

<h1><?php echo $arrHotel['hotel_name']; ?> Rates

<?php 

$strNewChildRateUrl = ROOT_URL . '/admin/rates/hotel/' . $intHotelId . '/new/';

    if(checkpageaccess("rate_hotel",'add') == 'ture'){
echo ' <a href="' . $strNewChildRateUrl . '" class="btn btn-sm btn-secondary">Add Child Rate</a>';
    }
?>
</h1>

<?php

// display messages, if needed
$blnShowMessages = false;
if(isset($objMessage) && !empty($objMessage) && !empty($objMessage['arrMessages'])){
	$blnShowMessages = true;
}

echo '<div class="alert js-message-alert';

if($blnShowMessages){
	if($objMessage['blnError']){
		echo ' alert-danger ';
	}else{
		echo ' alert-success ';
	}
}

echo '" role="alert" ';

if(!$blnShowMessages){
	echo ' style="display: none;" ';
}

echo '>';

if($blnShowMessages){
	foreach($objMessage['arrMessages'] as $strMessage){
		echo $strMessage . '<br />';
	}
}

echo '</div>';

?>

<div class="filters well">
	<form method="get" class="js-filter-form">
        <div class="row">
            <div class="col-xs-12">
                <h4>Search Rates</h4>
            </div>
        </div>
		<div class="row">
			<div class="col-md-6">
				<div class="form-group form-inline">
			    	<label for="tbxName">Name</label>
				    <input type="text" name="name" class="form-control" id="tbxName" placeholder="Rate Name" value="<?php if(isset($arrQueryOptions['name']) && !empty($arrQueryOptions['name'])){echo $arrQueryOptions['name'];} ?>">
				</div>
			</div>

			<div class="col-md-6">
		 		<div class="form-group form-inline">
			    	<label for="tbxStartDate">Start Date between </label>
				    <input type="text" name="min_start_date" class="form-control datepicker" id="tbxStartDate" placeholder="YYYY-MM-DD" value="<?php if(isset($arrQueryOptions['min_start_date']) && !empty($arrQueryOptions['min_start_date'])){echo $arrQueryOptions['min_start_date'];} ?>">
				    <strong>and</strong>
				    <input type="text" name="max_start_date" class="form-control datepicker" id="tbxStartDate2" placeholder="YYYY-MM-DD" value="<?php if(isset($arrQueryOptions['max_start_date']) && !empty($arrQueryOptions['max_start_date'])){echo $arrQueryOptions['max_start_date'];} ?>">
				</div>

				<br />

				<div class="form-group form-inline">
			    	<label for="tbxEndDate">End Date between </label>
				    <input type="text" name="min_end_date" class="form-control datepicker" id="tbxEndDate" placeholder="YYYY-MM-DD" value="<?php if(isset($arrQueryOptions['min_end_date']) && !empty($arrQueryOptions['min_end_date'])){echo $arrQueryOptions['min_end_date'];} ?>">
				    <strong>and</strong>
				    <input type="text" name="max_end_date" class="form-control datepicker" id="tbxEndDate2" placeholder="YYYY-MM-DD" value="<?php if(isset($arrQueryOptions['max_end_date']) && !empty($arrQueryOptions['max_end_date'])){echo $arrQueryOptions['max_end_date'];} ?>">
				</div>
			</div>
		</div>

		<div class="hide">
			<input type="hidden" class="js-filter-order" name="order_by" value="<?php echo $arrQueryOptions['order_by']; ?>" />
			<input type="hidden" class="js-filter-sort" name="sort_order" value="<?php echo $arrQueryOptions['sort_order']; ?>" />
		</div>

		<button type="reset" class="btn btn-default">Clear Filters</button>
		<button type="submit" class="btn btn-primary">Search</button>
	</form>
</div>

<div class="rates grid-view">
	<table class="table table-stripped js-data-grid">
		<tr>
			<?php

			foreach($arrColumns as $arrColumn){
				$strSortIcon = '';
				$strSortOrder = 'ASC';
				$strClasses = '';

				if(strtolower($arrQueryOptions['order_by']) == strtolower($arrColumn['name'])){
					if(strtolower($arrQueryOptions['sort_order']) == 'asc'){
						$strSortOrder = 'DESC';
						$strSortIcon = ' <i class="fa fa-caret-up"></i>';
					}else{
						$strSortIcon = ' <i class="fa fa-caret-down"></i>';
					}
				}

				if($arrColumn['sortable']){
					$strClasses .= ' js-sortable ';
				}

				echo '<th class="' . $strClasses . '">';

				echo '<a href="#" data-column-name="' . $arrColumn['name'] . '" data-column-sort="' . $strSortOrder . '">' . $arrColumn['label'] . $strSortIcon . '</a>';

				echo '</th>';

			}

			?>
		</tr>

		<tr>
			<?php 

			if(empty($arrRates)){
				echo '<tr><td colspan="9">No Rates Found.</td></tr>';
			}else{
				foreach($arrRates as $arrRate){

					if ($arrRate['deleted'] != 1) {

						echo '<tr>'
								   . '<td><a href="' . ROOT_URL . '/admin/rates/hotel/' . $arrRate['hotel_id'] . '/' . $arrRate['id'] . '">' . $arrRate['name'] . '</a>';

								echo '<ul class="grid-actions list-inline invisible">';
                                if(checkpageaccess("rate_hotel",'edit') == 'ture'){
								    echo '<li><a href="' . ROOT_URL . '/admin/rates/hotel/' . $arrRate['hotel_id'] . '/' . $arrRate['id'] . '">Edit</a></li>';
                                }
                                
                                if(checkpageaccess("rate_hotel",'add') == 'ture'){
								echo '<li><a href="#" class="js-open-duplicate-modal" data-hotel-id="' . $arrRate['hotel_id'] . '" data-hotel-name="' . $arrRate['hotel_name'] . '" data-parent-id="" data-rate-id="' . $arrRate['id'] . '">Duplicate</a></li>';
							    }
                                if(checkpageaccess("rate_hotel",'delete') == 'ture'){
								echo '<li><a href="javascript:confirmDelete(\'' . ROOT_URL . '/admin/rates/hotel/' . $arrRate['hotel_id'] . '/delete/' . $arrRate['id'] . '\');" class="text-danger">Delete</a></li>';
                                }
								echo '</ul>';

						echo '<td>' . date('Y-m-d', strtotime($arrRate['start_date'])) . '</td>'
						   . '<td>' . date('Y-m-d', strtotime($arrRate['end_date'])) . '</td>'
						   . '<td>$' . money_format('%i', $arrRate['price']) . '</td>'
						   // . '<td>$' . money_format('%i', $arrRate['rack_rate']) . '</td>'
						   // . '<td>' . $arrRate['detail_type_name'] . '</td>'
						   // . '<td>' . $arrRate['occupency'] . '</td>'
						   // . '<td>' . $arrRate['minimum_stay'] . '</td>'
						   . '</tr>';
					}
				}
			}

			?>
		</tr>
	</table>
</div>


<script type="text/javascript">

	$(document).ready(function(){
		$('.js-data-grid').on('click', 'th.js-sortable a', function(event){
			event.preventDefault();

			var strColumnName = $(this).data('column-name');
			var strColumnSort = $(this).data('column-sort');

			if(typeof(strColumnName) == 'undefined' || strColumnName == null){
				// no column name
				return false;
			}

			if(typeof(strColumnSort) == 'undefined' || strColumnSort == null){
				// no column name
				strColumnSort = 'ASC';
			}

			$('.js-filter-form .js-filter-order').val(strColumnName);
			$('.js-filter-form .js-filter-sort').val(strColumnSort);

			// submit filter form with changes
			$('.js-filter-form').submit();

			return false;
		})
	});

</script>

<?php

include_once('application/views/admin/rates/_hotel_duplicate.php');

include('application/includes/admin/footer.php');