<?php

include('application/includes/admin/header.php');

$strYear = date('Y');
$strSort = 'hotel_name';
$strDir = 'ASC';
$strReverseDir = 'DESC';
$strNameFilter = '';

if (isset($_GET['sort']) && ($_GET['sort'] != 'hotel_name')) {
    if ($_GET['sort'] == 'last_rate_change') {
        $strSort = 'last_rate_change';
    }
}

if (isset($_GET['dir']) && ($_GET['dir'] != 'ASC')) {
    if ($_GET['dir'] == 'DESC') {
        $strDir = 'DESC';
        $strReverseDir = 'ASC';
    }
}

if (isset($_GET['name'])) {
    $strNameFilter = $_GET['name'];
}

?>

<h1>Hotel Rates</h1>

<div class="filters well">
	<form method="get" class="form-inline">
		<div class="form-group">
	    	<label for="tbxName">Name</label>
		    <input type="text" class="form-control" id="tbxName" name="name" value="<?php echo $strFilter['name']; ?>" placeholder="Hotel Name">
		 </div>
		 <button type="submit" class="btn btn-default">Search</button>
	</form>
</div>

<?php

if(!empty($arrHotelsNoRates)){

?>
<div class="panel panel-danger">
	<div class="panel-heading" data-toggle="collapse" data-parent=".panel" href="#hotel-panel">
		<strong>Hotels with no rates for <?php echo $strYear; ?> (<?php echo count($arrHotelsNoRates); ?>)</strong>
	</div>
	<div id="hotel-panel" class="panel-collapse collapse" role="tabpanel">
		<div class="panel-body">
			<table class="table table-striped">
				<tr>
					<th>
                    <?php echo "<a href='?name=".$strNameFilter."&sort=hotel_name&dir=".$strReverseDir."'>Hotel Name</a>"; ?>
                    <?php if (($strSort == 'hotel_name') && ($strDir == 'ASC')) { ?>
                        <span class="caret"></span>
                    <?php } ?>
                    <?php if (($strSort == 'hotel_name') && ($strDir == 'DESC')) { ?>
                        <span class="dropup"><span class="caret"></span></span>
                    <?php } ?>
                    </th>
					<th>Region</th>
                    <th>
                    <?php echo "<a href='?name=".$strNameFilter."&sort=last_rate_change&dir=".$strReverseDir."'>Last Rate Change</a>"; ?>
                    <?php if (($strSort == 'last_rate_change') && ($strDir == 'ASC')) { ?>
                        <span class="caret"></span>
                    <?php } ?>
                    <?php if (($strSort == 'last_rate_change') && ($strDir == 'DESC')) { ?>
                        <span class="dropup"><span class="caret"></span></span>
                    <?php } ?>
                    </th>
				</tr>

				<?php

				foreach($arrHotelsNoRates as $arrHotelNoRate){
					echo '<tr><td>';
					echo '<a href="' . ROOT_URL . '/admin/rates/hotel/' . $arrHotelNoRate['id'] . '">' . $arrHotelNoRate['hotel_name'] . '</a>';
					echo '</td>';
					echo '<td>' . $arrHotelNoRate['region_name'] . '</td>';
                    echo '<td>' . $arrHotelNoRate['last_rate_change'] . '</td></tr>';
				}

				?>
			</table>
		</div>
	</div>
</div>

<?php

} // no rates panel

?>

<div class="hotels">
	<table class="table table-striped">
		<tr>
			<th>
            <?php echo "<a href='?name=".$strNameFilter."&sort=hotel_name&dir=".$strReverseDir."'>Hotel Name</a>"; ?>
            <?php if (($strSort == 'hotel_name') && ($strDir == 'ASC')) { ?>
                <span class="caret"></span>
            <?php } ?>
            <?php if (($strSort == 'hotel_name') && ($strDir == 'DESC')) { ?>
                <span class="dropup"><span class="caret"></span></span>
            <?php } ?>
            </th>
			<th>Region</th>
            <th>
                <?php echo "<a href='?name=".$strNameFilter."&sort=last_rate_change&dir=".$strReverseDir."'>Last Rate Change</a>"; ?>
                <?php if (($strSort == 'last_rate_change') && ($strDir == 'ASC')) { ?>
                    <span class="caret"></span>
                <?php } ?>
                <?php if (($strSort == 'last_rate_change') && ($strDir == 'DESC')) { ?>
                    <span class="dropup"><span class="caret"></span></span>
                <?php } ?>
            </th>
		</tr>

		<?php

		if(empty($arrHotels)){
			echo '<tr><td>No hotels found.</td></tr>';
		}else{
			foreach($arrHotels as $arrHotel){
				echo '<tr><td>';
				echo '<a href="' . ROOT_URL . '/admin/rates/hotel/' . $arrHotel['id'] . '">' . $arrHotel['hotel_name'] . '</a>';
				echo '</td>';
				echo '<td>' . $arrHotel['region_name'] . '</td>';
                echo '<td>' . $arrHotel['last_rate_change'] . '</td></tr>';
			}
		}

		?>
	</table>
</div>

<?php

include('application/includes/admin/footer.php');