<?php 

include('application/includes/admin/header.php');

?>

<h1>Rate Detail Types</h1>

<?php 

// display messages, if needed
$blnShowMessages = false;
if(isset($objMessage) && !empty($objMessage) && !empty($objMessage['arrMessages'])){
	$blnShowMessages = true;
}

echo '<div class="alert js-message-alert';

if($blnShowMessages){
	if($objMessage['blnError']){
		echo ' alert-danger ';
	}else{
		echo ' alert-success ';
	}
}

echo '" role="alert" ';

if(!$blnShowMessages){
	echo ' style="display: none;" ';
}

echo '>';

if($blnShowMessages){
	foreach($objMessage['arrMessages'] as $strMessage){
		echo $strMessage . '<br />';
	}
}

echo '</div>';

?>

<div class="filters well">
	<form method="get" class="form-inline">
		<div class="form-group">
	    	<label for="tbxName">Name</label>
		    <input type="text" class="form-control" id="tbxName" name="name" placeholder="Detail Type Name" value="<?php echo $strFilter['name']; ?>">
		 </div>
		 <button type="submit" class="btn btn-default">Search</button>
	</form>
</div>

<div>
	<!-- Nav tabs -->
	<ul class="nav nav-tabs" role="tablist">
		<li role="presentation" class="active"><a href="#tbHotel" aria-controls="tbHotel" role="tab" data-toggle="tab">Hotels <span class="badge"><?php echo count($arrDetailHotels); ?></span></a></li>
		<li role="presentation"><a href="#tbCourse" aria-controls="tbCourse" role="tab" data-toggle="tab">Courses <span class="badge"><?php echo count($arrDetailCourses); ?></span></a></li>
	</ul>

	<!-- Tab panes -->
	<div class="tab-content">
		<div role="tabpanel" class="tab-pane active" id="tbHotel">

			<div class="buttons" style="margin: 10px 0;">
				<a href="<?php ROOT_URL; ?>/admin/rates/detail_types/new/?type=hotel" class="btn btn-primary">Add New Hotel Detail Type</a>
			</div>

			<div class="hotels grid-view">
				<table class="table table-striped">
					<tr>
						<th>Id</th>
						<th>Name</th>
						<th>Description</th>
						<th>Rating</th>
					</tr>

					<?php 

					if(empty($arrDetailHotels)){
						echo '<tr><td>No hotels found.</td></tr>';
					}else{
						foreach($arrDetailHotels as $arrDetailHotel){
							echo '<tr><td>';
							echo '<a href="' . ROOT_URL . '/admin/rates/detail_types/' . $arrDetailHotel['id'] . '">' . $arrDetailHotel['id'] . '</a>';
							echo '</td>';
							echo '<td>';
							echo '<a href="' . ROOT_URL . '/admin/rates/detail_types/' . $arrDetailHotel['id'] . '">' . $arrDetailHotel['name'] . '</a>';
							echo '<ul class="grid-actions list-inline invisible">';
							echo '<li><a href="' . ROOT_URL . '/admin/rates/detail_types/' . $arrDetailHotel['id'] . '">Edit</a></li>';
							echo '<li><a href="javascript:confirmDelete(\'' . ROOT_URL . '/admin/rates/detail_types/delete/' . $arrDetailHotel['id'] . '\');" class="text-danger">Delete</a></li>';
							echo '</ul>';
							echo '</td>';
							echo '<td>' . $arrDetailHotel['description'] . '</td>';
							echo '<td>' . $arrDetailHotel['rating'] . '</td>';
							echo '</tr>';
						}
					}

					?>
				</table>
			</div>

		</div>
		<div role="tabpanel" class="tab-pane" id="tbCourse">

			<div class="buttons" style="margin: 10px 0;">
				<a href="<?php ROOT_URL; ?>/admin/rates/detail_types/new/?type=course" class="btn btn-primary">Add New Course Detail Type</a>
			</div>

			<div class="courses grid-view">
				<table class="table table-striped">
					<tr>
						<th>Id</th>
						<th>Name</th>
						<th>Description</th>
						<th>Rating</th>
					</tr>

					<?php 

					if(empty($arrDetailCourses)){
						echo '<tr><td>No courses found.</td></tr>';
					}else{
						foreach($arrDetailCourses as $arrDetailCourse){
							echo '<tr><td>';
							echo '<a href="' . ROOT_URL . '/admin/rates/detail_types/' . $arrDetailCourse['id'] . '">' . $arrDetailCourse['id'] . '</a>';
							echo '</td>';
							echo '<td>';
							echo '<a href="' . ROOT_URL . '/admin/rates/detail_types/' . $arrDetailCourse['id'] . '">' . $arrDetailCourse['name'] . '</a>';
							echo '<ul class="grid-actions list-inline invisible">';
							echo '<li><a href="' . ROOT_URL . '/admin/rates/detail_types/' . $arrDetailCourse['id'] . '">Edit</a></li>';
							echo '<li><a href="javascript:confirmDelete(\'' . ROOT_URL . '/admin/rates/detail_types/delete/' . $arrDetailCourse['id'] . '\');" class="text-danger">Delete</a></li>';
							echo '</ul>';
							echo '</td>';
							echo '<td>' . $arrDetailCourse['description'] . '</td>';
							echo '<td>' . $arrDetailCourse['rating'] . '</td>';
							echo '</tr>';
						}
					}

					?>
				</table>
			</div>

		</div>
	</div>
</div>



<?php

include('application/includes/admin/footer.php');