<?php 

include('application/includes/admin/header.php');

?>

<h1><?php echo $arrDetailType['name']; ?></h1>

<?php 

// display messages, if needed
$blnShowMessages = false;
if(isset($objMessage) && !empty($objMessage) && !empty($objMessage['arrMessages'])){
	$blnShowMessages = true;
}

echo '<div class="alert js-message-alert';

if($blnShowMessages){
	if($objMessage['blnError']){
		echo ' alert-danger ';
	}else{
		echo ' alert-success ';
	}
}

echo '" role="alert" ';

if(!$blnShowMessages){
	echo ' style="display: none;" ';
}

echo '>';

if($blnShowMessages){
	foreach($objMessage['arrMessages'] as $strMessage){
		echo $strMessage . '<br />';
	}
}

echo '</div>';

?>

<div class="row">
	<div class="col-md-9">

		<div class="detail-type">
			<form method="post" class="js-detail-type-form">
				<div class="hide">
					<input type="hidden" name="detail_type[id]" value="<?php echo $arrDetailType['id']; ?>" />
				</div>

				<div class="row">
					<div class="col-md-6">
						<div class="form-group js-required">
							<label for="tbxName" class="control-label">Name: </label>
							<input type="text" id="tbxName" name="detail_type[name]" class="form-control" placeholder="Detail Type Name"  value="<?php echo $arrDetailType['name']; ?>" />
						</div>

						<div class="form-group">
							<label for="taDescrpition" class="control-label">Description: </label>
							<textarea id="taDescrpition" name="detail_type[description]" class="form-control" rows="5" placeholder="Ammenities, included options, etc."><?php echo $arrDetailType['description']; ?></textarea>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group js-required">
							<label for="slType" class="control-label">Type: </label>
							<select id="slType" name="detail_type[type]" class="form-control">
								<?php  

								$arrTypes = array(
									array(
										'label' => 'Hotel',
										'value' => 'hotel'
									),
									array(
										'label' => 'Course',
										'value' => 'course'
									)
								);

								foreach($arrTypes as $arrType){
									$strSelected = '';
									if($arrDetailType['type'] == $arrType['value']){
										$strSelected = 'selected="selected"';
									}

									echo '<option value="' . $arrType['value'] . '" ' . $strSelected . '>' . $arrType['label'] . '</option>';
								}

								?>
							</select>
						</div>

						<div class="form-group">
							<label for="tbxRating" class="control-label">Rating: </label>
							<input type="number" id="tbxRating" name="detail_type[rating]" class="form-control" placeholder="Rating of service (used as a quick filter on calculator)"  value="<?php echo $arrDetailType['rating']; ?>" />
						</div>
					</div>
				</div>
			</form>
		</div>
	</div>

	<div class="col-md-3">
		<div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Save Options</h3>
            </div>
            <div class="panel-body">
                <div class="btn-group btn-group-justified">
                	<div class="btn-group"><a href="<?php echo ROOT_URL; ?>/admin/rates/detail_types/" class="btn btn-secondary">Cancel</a></div>
                	<?php 

                	if(!$blnNew){
	                	echo '<div class="btn-group"><a href="javascript:confirmDelete(\'' . ROOT_URL . '/admin/rates/detail_types/delete/' . $arrDetailType['id'] . '\');" class="btn btn-secondary">Delete</a></div>';
	                }

                	?>
                    <div class="btn-group"><button class="btn btn-primary js-save-detail-type"><?php echo ($blnNew) ? 'Create' : 'Save'; ?></button></div>
                </div>
            </div>
        </div>
	</div>
</div>

<script type="text/javascript">

jQuery(document).ready(function($){
	$('.js-save-detail-type').click(function(event){
			event.preventDefault();

			// trigger detail type form to submit
			$('.js-detail-type-form').submit();
		});

	$('.js-detail-type-form').submit(function(event){
		return fnValidateDetailTypeForm(this);
	});

	function fnValidateDetailTypeForm(frmForm){
		// clean up old validation
		$(frmForm).find('.has-error').removeClass('has-error');

		var jobjRequiredFields = $(frmForm).find('.js-required');
		var blnValid = true;
		var arrMessage = [];

		for(var intField = 0; intField < jobjRequiredFields.length; intField++){
			var jobjInput = $(jobjRequiredFields[intField]).find('input');
			var jobjSelect = $(jobjRequiredFields[intField]).find('select');

			for(var intInput = 0; intInput < jobjInput.length; intInput++){
				var jobjSpacificInput = $(jobjInput[intInput])
				if(jobjSpacificInput.val() != null && jobjSpacificInput.val().length > 0){
					// valid field
					continue;
				}

				// invalid field
				blnValid = false;
				arrMessage.push($(jobjRequiredFields[intField]).find('label').text() + ' is required.');
				$(jobjRequiredFields[intField]).addClass('has-error');
			}
		}

		var jobjMessage = $('.js-message-alert');

		jobjMessage.hide().removeClass('alert-success').removeClass('alert-danger').html('');

		if(blnValid){
			// form is valid
			return true;
		}

		var strMessage = '<strong>Invalid Data.</strong> Please correct the errors below and try again.<br />';

		for(var intMessage = 0; intMessage < arrMessage.length; intMessage++){
			strMessage += arrMessage[intMessage] + '<br />';
		}

		// form is invalid
		jobjMessage.html(strMessage).addClass('alert-danger').show();
		return false;
	}

});

</script>

<?php

include('application/includes/admin/footer.php');