<?php 

include('application/includes/admin/header.php');

$strYear = date('Y');

?>

<h1>Manage Rates</h1>

<div class="row">
	<div class="col-md-6">
		<h2>Golf Courses</h2>

		<div class="filters well">
			<a href="<?php echo ROOT_URL; ?>/admin/rates/course/" class="btn btn-default">View All Course Rates</a>
		</div>

		<?php 
		if(!empty($arrCoursesNoRates)){
			?>
			<div class="panel panel-danger">
				<div class="panel-heading" data-toggle="collapse" data-parent=".panel" href="#course-panel">
					<strong>Courses with no rates for <?php echo $strYear; ?> (<?php echo count($arrCoursesNoRates); ?>)</strong>
				</div>
				<div id="course-panel" class="panel-collapse collapse in" role="tabpanel">
					<div class="panel-body">
						<table class="table table-striped">
							<tr>
								<th>Hotel Name</th>
								<th>Region</th>
							</tr>

							<?php 

							foreach($arrCoursesNoRates as $arrCourseNoRate){
								echo '<tr>';
								echo '<td>';
								echo '<a href="' . ROOT_URL . '/admin/rates/course/' . $arrCourseNoRate['id'] . '">' . $arrCourseNoRate['course_name'] . '</a>';
								echo '</td>';
								echo '<td>' . $arrCourseNoRate['region_name'] . '</td>';
								echo '</tr>';
							}

							?>
						</table>
					</div>
				</div>
			</div>
			<?php 
		} // no rates panel
		?>


	</div>

	<div class="col-md-6">
		<h2>Hotels</h2>

		<div class="filters well">
			<a href="<?php echo ROOT_URL; ?>/admin/rates/hotel/" class="btn btn-default">View All Hotel Rates</a>
		</div>

		<?php 
		if(!empty($arrHotelsNoRates)){
			?>
			<div class="panel panel-danger">
				<div class="panel-heading" data-toggle="collapse" data-parent=".panel" href="#hotel-panel">
					<strong>Hotels with no rates for <?php echo $strYear; ?> (<?php echo count($arrHotelsNoRates); ?>)</strong>
				</div>
				<div id="hotel-panel" class="panel-collapse collapse in" role="tabpanel">
					<div class="panel-body">
						<table class="table table-striped">
							<tr>
								<th>Hotel Name</th>
								<th>Region</th>
							</tr>

							<?php 

							foreach($arrHotelsNoRates as $arrHotelNoRate){
								echo '<tr>';
								echo '<td>';
								echo '<a href="' . ROOT_URL . '/admin/rates/hotel/' . $arrHotelNoRate['id'] . '">' . $arrHotelNoRate['hotel_name'] . '</a>';
								echo '</td>';
								echo '<td>' . $arrHotelNoRate['region_name'] . '</td>';
								echo '</tr>';
							}

							?>
						</table>
					</div>
				</div>
			</div>
			<?php 
		} // no rates panel
		?>
	</div>
</div>

<?php

include('application/includes/admin/footer.php');