<?php 

$arrCourse = Rate::getCourseById($arrRate['course_id']);

include('application/includes/admin/header.php');

$strYear = date('Y');

$strNewChildRateUrl = ROOT_URL . '/admin/rates/course/' . $arrRate['course_id'] . '/new/' . $arrRate['id'];

$strTitleText = '#' . $arrRate['id'] . ' Rate';
if($blnNew){
	$strTitleText = 'Create New Rate';
}elseif(!empty($arrRate['name'])){
	$strTitleText = $arrRate['name'] . ' Rate';
}

echo '<h1>' . $strTitleText;

if(!$blnNew){
	echo ' <a href="' . $strNewChildRateUrl . '" class="btn btn-sm btn-secondary">Add Child Rate</a>';
}

echo '</h1>';

// display messages, if needed
$blnShowMessages = false;
if(isset($objMessage) && !empty($objMessage) && !empty($objMessage['arrMessages'])){
	$blnShowMessages = true;
}

echo '<div class="alert js-message-alert';

if($blnShowMessages){
	if($objMessage['blnError']){
		echo ' alert-danger ';
	}else{
		echo ' alert-success ';
	}
}

echo '" role="alert" ';

if(!$blnShowMessages){
	echo ' style="display: none;" ';
}

echo '>';

if($blnShowMessages){
	foreach($objMessage['arrMessages'] as $strMessage){
		echo $strMessage . '<br />';
	}
}

echo '</div>';

?>

<form method="post" class="js-rate-form">

	<div class="row">
		<div class="col-md-9">

			<div class="rate">
					<div class="hide">
						<input type="hidden" name="rate[id]" value="<?php echo $arrRate['id']; ?>" />
						<input type="hidden" name="rate[course_id]" value="<?php echo $arrRate['course_id']; ?>" />
						<!-- <input type="hidden" name="rate[parent_id]" value="<?php echo $arrRate['parent_id']; ?>" /> -->
					</div>

					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label for="tbxName" class="control-label">Name: </label>
								<input type="text" id="tbxName" name="rate[name]" class="form-control" placeholder="Rate Name"  value="<?php echo $arrRate['name']; ?>" />
							</div>

							<div class="form-group js-required">
								<label for="tbxRateStartDate" class="control-label">Start Date: </label>
								<input type="text" id="tbxRateStartDate" name="rate[start_date]" class="form-control datepicker" placeholder="YYYY-mm-dd"  value="<?php echo date('Y-m-d', strtotime($arrRate['start_date'])); ?>" />
							</div>

							<div class="form-group js-required">
								<label for="tbxRateEndDate" class="control-label">End Date: </label>
								<input type="text" id="tbxRateEndDate" name="rate[end_date]" class="form-control datepicker" placeholder="YYYY-mm-dd"  value="<?php echo date('Y-m-d', strtotime($arrRate['end_date'])); ?>" />
							</div>
							
							<div class="form-group js-required">
								<label for="tbxPrice" class="control-label">Price: </label>
								<input type="number" id="tbxPrice" name="rate[price]" class="form-control" placeholder="$0.00"  value="<?php echo $arrRate['price']; ?>" />
							</div>

	                        <div class="form-group js-required">
	                            <label for="sltStatus" class="control-label">Status: </label>
	                            <select id="sltStatus" name="rate[status]" class="form-control">
	                                <?php  

	                                $arrStatuses = array(
	                                    array(
	                                        'label' => 'Active',
	                                        'value' => 'active'
	                                    ),
	                                    array(
	                                        'label' => 'Archived',
	                                        'value' => 'archived'
	                                    )
	                                );

	                                foreach($arrStatuses as $arrStatus){
	                                    $strSelected = '';
	                                    if($arrRate['status'] == $arrStatus['value']){
	                                        $strSelected = 'selected="selected"';
	                                    }

	                                    echo '<option value="' . $arrStatus['value'] . '" ' . $strSelected . '>' . $arrStatus['label'] . '</option>';
	                                }

	                                ?>
	                            </select>
	                        </div>

	                        <?php /*
							<div class="form-group">
								<label for="tbxRackRate" class="control-label">Rack Rate: </label>
								<input type="number" id="tbxRackRate" name="rate[rack_rate]" class="form-control" placeholder="100.00"  value="<?php echo str_replace(' ', '', money_format('%^.2i', $arrRate['rack_rate'])); ?>" />
							</div>
	                        */ ?>
						</div>

						<div class="col-md-6">
	                        <div class="form-group">
	                            <label for="taNotes" class="control-label">Notes: </label>
	                            <textarea id="taNotes" name="rate[notes]" class="form-control" placeholder="Enter additional information to keep track of." style="height: 108px;"><?php echo $arrRate['notes']; ?></textarea>
	                        </div>

	                        <div class="form-group">
	                            <label class="control-label">Course: </label><br />

	                            <?php echo '<a href="' . ROOT_URL . '/admin/course/edit/' . $arrCourse['id'] . '/">' . $arrCourse['course_name'] . '</a>'; ?>
	                        </div>
						</div>
					</div>
				</form>
			</div>

			<hr />

			<?php if (isset($intRateId)) { ?>

			<div id="rate_<?php echo $intRateId; ?>" class="">
				<div class="child-fees">
					<h2>Season Fees
					<button style="float:right;" type="button" class="btn btn-success jsAddFee" data-id="<?php echo $intRateId; ?>">New Fee</button>
					</h2>

				<?php foreach ($arrSeasonFees as $fee) { ?>

					<div class="panel-group panel-group-fee">
		                <div class="panel panel-default">
		                    <div class="panel-heading">
		                        <h3 style="cursor:pointer" data-toggle="collapse" data-target="#rate_fee_<?php echo $fee['id']; ?>">
		                        	<?php echo $fee['name'] . ' : ' . $fee['amount']; ?>
		                        	<?php 
		                        	    if($checkaccess){ 
		                        	?>
		                        	<i style="float:right; color:red; margin-left:10px;" class="fa fa-trash-o jsDeleteFee" data-fee-id="<?php echo $fee['id']; ?>"></i>
		                        	<?php } ?>
		                        	<i style="float:right;" class="fa fa-chevron-down"></i>
		                        </h3>
		                    </div>
		                   	<div id="rate_fee_<?php echo $fee['id']; ?>" class="panel-collapse collapse">
	            				<div class="panel-body">
				                    <div class="form-group">
								    	<label for="fee_name_<?php echo $fee['id'];?>">Fee Name</label>
									    <input type="text" name="feeName[<?php echo $fee['id']; ?>]" class="form-control" id="fee_name_<?php echo $fee['id'];?>" value="<?php echo $fee['name']; ?>">
									</div>

									<div class="form-group">
								    	<label for="fee_calc_type_<?php echo $fee['id'];?>">Fee Calculation Type</label>
								    	<select name="feeCalcType[<?php echo $fee['id'];?>]" id="fee_calc_type_<?php echo $fee['id'];?>" class="form-control">
								    		<option value="flat" <?php echo ($fee['calculation_type'] == 'flat' ? 'selected' : '');?>>Flat Value</option>
								    		<option value="percentage" <?php echo ($fee['calculation_type'] == 'percentage' ? 'selected' : '');?>>Percentage</option>
								    	</select>
									</div>

									<div class="form-group">
								    	<label for="fee_amount_<?php echo $fee['id'];?>">Amount / Percentage</label>
									    <input type="number" name="feeAmount[<?php echo $fee['id']; ?>]" class="form-control" id="fee_amount_<?php echo $fee['id']; ?>" value="<?php echo $fee['amount']; ?>">
									</div>

									<div class="form-group">
								    	<label for="fee_per_person<?php echo $fee['id']; ?>">Per Person</label>
										<input type="checkbox" name="feePerPerson[<?php echo $fee['id']; ?>]" class="" id="feePerPerson_<?php echo $fee['id']; ?>" value="1" <?php echo (($fee['per_person'] == 1) ? 'checked':''); ?>>
									</div>

									<div class="form-group">
								    	<label for="fee_public_<?php echo $fee['id']; ?>">Public</label>
									    <input type="checkbox" name="feePublic[<?php echo $fee['id']; ?>]" class="" id="feePublic_<?php echo $fee['id']; ?>" value="1" <?php echo (($fee['public'] == 1) ? 'checked':''); ?>>
									    <label for="fee_private_<?php echo $fee['id']; ?>">Private</label>
									    <input type="checkbox" name="feePrivate[<?php echo $fee['id']; ?>]" class="" id="feePrivate_<?php echo $fee['id']; ?>" value="1" <?php echo (($fee['private'] == 1) ? 'checked':''); ?>>
									</div>	
	                    		</div>
	                    	</div>
	                	</div>
	                </div>

		        <?php } ?>
        		
        		<span class="jsNewFeeContainer"></span>
        	</div>
		</div>

	<?php } else { ?>

		<h2>Please Save to add rates</h2>

	<?php } ?> 

	<?php 
	if(isset($arrChildColumns) && !empty($arrChildColumns)){
	?>
			<hr>

			<div class="child-rates">
				<h2>Rates
				<button style="float:right;" type="button" class="btn btn-success jsAddRate" data-id="">New Rate</button>
				</h2>
	
			<?php
			foreach ($arrChildRates as $arrChildRate) {

				if ($arrChildRate['deleted'] != 1) {
			?>
					<div class="panel-group">
		                <div class="panel panel-default">
		                    <div class="panel-heading">
		                        <h3 style="cursor:pointer" data-toggle="collapse" data-target="#rate_<?php echo $arrChildRate['id']; ?>">
		                        	<?php echo $arrChildRate['start_date'] . ' - ' . $arrChildRate['end_date'] . ' : ' . $arrChildRate['name']; ?>
		                        	<?php if($checkaccess){ ?>
		                        	<i style="float:right; color:red; margin-left:10px;" class="fa fa-trash-o jsDeleteRate" data-rate-id="<?php echo $arrChildRate['id']; ?>" data-rate-name="<?php echo $arrChildRate['name']; ?>"></i>
		                        	<?php } if($checkaccessadd){ ?>
		                        	<i style="float:right; color:blue; margin-left:10px;" class="fa fa-copy jsCopyRate" data-rate-id="<?php echo $arrChildRate['id']; ?>" data-rate-name="<?php echo $arrChildRate['name']; ?>"></i>
		                        	<?php } ?>
		                        	<i style="float:right;" class="fa fa-chevron-down"></i>
		                        	<span style='float:right;'>$<?php echo number_format($arrChildRate['private_price'],2); ?>&nbsp;&nbsp;</span>
		                        </h3>
		                    </div>

		                    <div id="rate_<?php echo $arrChildRate['id']; ?>" class="panel-collapse collapse">
		                        <div class="panel-body">

		                        	<div class="form-group">
								    	<label for="rateName_<?php echo $arrChildRate['id'];?>">Rate Name</label>
									    <input type="text" name="rateName[<?php echo $arrChildRate['id']; ?>]" class="form-control" id="rateName_<?php echo $arrChildRate['id'];?>" value="<?php echo $arrChildRate['name']; ?>">
									</div>

									<div class="form-group">
								    	<label for="rateDateFrom_<?php echo $arrChildRate['id'];?>">Start Date</label>
									    <input type="text" name="rateDateFrom[<?php echo $arrChildRate['id']; ?>]" class="form-control datepicker" id="rateDateFrom_<?php echo $arrChildRate['id'];?>" value="<?php echo $arrChildRate['start_date']; ?>">
									</div>

									<div class="form-group">
								    	<label for="rateDateTo_<?php echo $arrChildRate['id'];?>">End Date</label>
									    <input type="text" name="rateDateTo[<?php echo $arrChildRate['id']; ?>]" class="form-control datepicker" id="rateDateTo_<?php echo $arrChildRate['id'];?>" value="<?php echo $arrChildRate['end_date']; ?>">
									</div>

									<div class="form-group">
								    	<label for="ratePublic_<?php echo $arrChildRate['id'];?>">Public Rate</label>
									    <input type="number" name="ratePublic[<?php echo $arrChildRate['id']; ?>]" class="form-control" id="ratePublic_<?php echo $arrChildRate['id'];?>" value="<?php echo $arrChildRate['price']; ?>">
									</div>

									<div class="form-group">
								    	<label for="ratePrivate_<?php echo $arrChildRate['id'];?>">Private Rate</label>
									    <input type="number" name="ratePrivate[<?php echo $arrChildRate['id']; ?>]" class="form-control" id="ratePrivate_<?php echo $arrChildRate['id'];?>" value="<?php echo $arrChildRate['private_price']; ?>">
									</div>

									<div class="form-group">	
									    <input type="checkbox" name="feature_package[<?php echo $arrChildRate['id']; ?>]" class="" id="feature_package_<?php echo $arrChildRate['id'];?>" <?php echo ($arrChildRate['feature_price']==1?'checked':''); ?>>
									    <label for="feature_package_<?php echo $arrChildRate['id'];?>">Use This Rate in Feature Packages</label>
									</div>

									<div>
										<h2>
											Rate Fees
											<button style="float:right;" type="button" class="btn btn-success jsAddFee" data-id="<?php echo $arrChildRate['id']; ?>">New Fee</button>
										</h2>
		                        				
										<?php foreach ($arrChildRate['fees'] as $fee) { ?>

										<div class="panel-group panel-group-fee" jsFeeId = "<?php echo $fee['id']; ?>">
							                <div class="panel panel-default">
							                    <div class="panel-heading">
							                        <h3 style="cursor:pointer" data-toggle="collapse" data-target="#rate_fee_<?php echo $fee['id']; ?>">
							                        	<?php echo $fee['name'] . ' : ' . $fee['amount']; ?>
							                        	<i style="float:right; color:red; margin-left:10px;" class="fa fa-trash-o jsDeleteFee" data-fee-id="<?php echo $fee['id']; ?>"></i>
							                        	<i style="float:right;" class="fa fa-chevron-down"></i>
							                        </h3>
							                    </div>
							                   	<div id="rate_fee_<?php echo $fee['id']; ?>" class="panel-collapse collapse">
				                    				<div class="panel-body">
									                    <div class="form-group">
													    	<label for="fee_name_<?php echo $fee['id'];?>">Fee Name</label>
														    <input type="text" name="feeName[<?php echo $fee['id']; ?>]" class="form-control" id="fee_name_<?php echo $fee['id'];?>" value="<?php echo $fee['name']; ?>">
														</div>

														<div class="form-group">
													    	<label for="fee_calc_type_<?php echo $fee['id'];?>">Fee Calculation Type</label>
													    	<select name="feeCalcType[<?php echo $fee['id'];?>]" id="fee_calc_type_<?php echo $fee['id'];?>" class="form-control">
													    		<option value="flat" <?php echo ($fee['calculation_type'] == 'flat' ? 'selected' : '');?>>Flat Value</option>
													    		<option value="percentage" <?php echo ($fee['calculation_type'] == 'percentage' ? 'selected' : '');?>>Percentage</option>
													    	</select>
														</div>

														<div class="form-group">
													    	<label for="fee_amount_<?php echo $fee['id'];?>">Amount / Percentage</label>
														    <input type="number" name="feeAmount[<?php echo $fee['id']; ?>]" class="form-control" id="fee_amount_<?php echo $fee['id']; ?>" value="<?php echo $fee['amount']; ?>">
														</div>

														<div class="form-group">
													    	<label for="fee_per_person<?php echo $fee['id']; ?>">Per Person</label>
															<input type="checkbox" name="feePerPerson[<?php echo $fee['id']; ?>]" class="" id="feePerPerson_<?php echo $fee['id']; ?>" value="1" <?php echo (($fee['per_person'] == 1) ? 'checked':''); ?>>
														</div>

														<div class="form-group">
													    	<label for="fee_public_<?php echo $fee['id']; ?>">Public</label>
														    <input type="checkbox" name="feePublic[<?php echo $fee['id']; ?>]" class="" id="feePublic_<?php echo $fee['id']; ?>" value="1" <?php echo (($fee['public'] == 1) ? 'checked':''); ?>>
														    <label for="fee_private_<?php echo $fee['id']; ?>">Private</label>
														    <input type="checkbox" name="feePrivate[<?php echo $fee['id']; ?>]" class="" id="feePrivate_<?php echo $fee['id']; ?>" value="1" <?php echo (($fee['private'] == 1) ? 'checked':''); ?>>
														</div>	
					                        		</div>
					                        	</div>
				                        	</div>
				                        </div>

		                        		<?php } ?>
										                       		
		                        		<span class="jsNewFeeContainer">
		                        		</span>
		                        	</div>
		                       	</div>
		                    </div>
		                </div>
		            </div>
				
		<?php	
				}
			}
		?>
				
		</div>
		
	<?php 
	} //if isset($arrChildColumns) && !empty($arrChildColumns)
	?>

	</div>

	<input type="hidden" class="jsNewRateCount" value="1" />
	<input type="hidden" class="jsNewFeeCount" value="1" />
	<input name="ratesToDelete" type="hidden" class="jsDeleteRates" value="" />
	<input name="feesToDelete" type="hidden" class="jsDeleteFees" value="" />

</form>

	<div class="col-md-3">
		<div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Save Options</h3>
            </div>
            <div class="panel-body">
                <div class="btn-group btn-group-justified">
                    <?php 

                    $strCancelButtonUrl = ROOT_URL . '/admin/rates/course/' . $arrRate['course_id'];
                    if(!empty($arrRate['parent_id'])){
                    	$strCancelButtonUrl = ROOT_URL . '/admin/rates/course/' . $arrRate['course_id'] . '/' . $arrRate['parent_id'];
                    }	

                    echo '<div class="btn-group"><a href="' . $strCancelButtonUrl . '" class="btn btn-secondary">Cancel</a></div>';

                    if(!$blnNew){
                        if($checkaccess){
                    	    echo '<div class="btn-group"><a href="javascript:confirmDelete(\'' . ROOT_URL . '/admin/rates/course/' . $arrRate['course_id'] . '/delete/' . $arrRate['id'] . '\');" class="btn btn-secondary">Delete</a></div>';
                        }
                        if($checkaccessadd){
                    	    echo '<div class="btn-group"><button class="btn btn-secondary  js-open-duplicate-modal" data-rate-id="' . $arrRate['id'] . '" data-parent-id="' . $arrRate['id'] . '" data-course-id="' . $arrRate['course_id'] . '" data-course-name="' . $arrCourse['course_name'] . '" data-ignore-id="' . $arrRate['id'] . '">Duplicate</button></div>';
                        }
                    }
                    
                    ?>
                    <div class="btn-group"><button class="btn btn-primary js-save-rate"><?php echo ($blnNew) ? 'Create' : 'Save'; ?></button></div>
                </div>
            </div>
        </div>
	</div>
</div>

<script type="text/javascript">

	$(document).ready(function(){
		$('.js-child-data-grid').on('click', 'th.js-sortable a', function(event){
			event.preventDefault();

			var strColumnName = $(this).data('column-name');
			var strColumnSort = $(this).data('column-sort');

			if(typeof(strColumnName) == 'undefined' || strColumnName == null){
				// no column name
				return false;
			}

			if(typeof(strColumnSort) == 'undefined' || strColumnSort == null){
				// no column name
				strColumnSort = 'ASC';
			}

			$('.js-child-filter-form .js-filter-order').val(strColumnName);
			$('.js-child-filter-form .js-filter-sort').val(strColumnSort);

			// submit filter form with changes
			$('.js-child-filter-form').submit();

			return false;
		});

		$('.js-save-rate').click(function(event){
			event.preventDefault();

			// trigger rate form to submit
			$('.js-rate-form').submit();
		});

		$('.js-rate-form').submit(function(event){
			return fnValidateRateForm(this);
		});

		function fnValidateRateForm(frmForm){
			// clean up old validation
			$(frmForm).find('.has-error').removeClass('has-error');

			var jobjRequiredFields = $(frmForm).find('.js-required');
			var blnValid = true;
			var arrMessage = [];

			for(var intField = 0; intField < jobjRequiredFields.length; intField++){
				var jobjInput = $(jobjRequiredFields[intField]).find('input');
				var jobjSelect = $(jobjRequiredFields[intField]).find('select');

				for(var intInput = 0; intInput < jobjInput.length; intInput++){
					var jobjSpacificInput = $(jobjInput[intInput])
					if(jobjSpacificInput.val() != null && jobjSpacificInput.val().length > 0){
						// valid field
						continue;
					}

					// invalid field
					blnValid = false;
					arrMessage.push($(jobjRequiredFields[intField]).find('label').text() + ' is required.');
					$(jobjRequiredFields[intField]).addClass('has-error');
				}
			}

			var jobjMessage = $('.js-message-alert');

			jobjMessage.hide().removeClass('alert-success').removeClass('alert-danger').html('');

			if(blnValid){
				// form is valid
				return true;
			}

			var strMessage = '<strong>Invalid Data.</strong> Please correct the errors below and try again.<br />';

			for(var intMessage = 0; intMessage < arrMessage.length; intMessage++){
				strMessage += arrMessage[intMessage] + '<br />';
			}

			// form is invalid
			jobjMessage.html(strMessage).addClass('alert-danger').show();
			return false;
		}
	});

	$('.jsAddFee').click(function() {
		intId = $(this).attr('data-id');
		ratesAddFee(intId, 'course', false);
	});

	$('.jsDeleteRate').click(function() {
		intId = $(this).attr('data-rate-id');
		deleteRate(intId);
	});

	$('.jsCopyRate').click(function() {
		intId = $(this).attr('data-rate-id');
		copyRate(intId, 'course');
		//alert("copy Rate" + intId);
	});

	$('.jsDeleteFee').click(function() {
		intId = $(this).attr('data-fee-id');
		deleteFee(intId);
	});

	$('.jsAddRate').click(function() {
		ratesAddRate('course');
	});



	$(document).on('click', '.jsAddFeeNewRate', function() {
		intId = $(this).attr('data-id');
		ratesAddFee(intId, 'course', true);
	});

	$(document).on('click', '.jsDeleteNewRate', function() {
		intId = $(this).attr('data-rate-id');
		deleteNewRate(intId);
	});

	$(document).on('click', '.jsCopyNewRate', function() {
		intId = $(this).attr('data-rate-id');
		//copyNewRate(intId);
		alert("Copy New Rate" + intId);
	});

	$(document).on('click', '.jsDeleteNewFee', function() {
		intId = $(this).attr('data-fee-id');
		deleteNewFee(intId);
	})

	//date picker fix for dynamically created elements
	$(document).on('focus',".jsNewDatepicker", function() {
    	$(this).datepicker();
	});


</script>

<?php

include_once('application/views/admin/rates/_course_duplicate.php');

include('application/includes/admin/footer.php');