<?php

include('application/includes/admin/header.php');

$strYear = date('Y');
$strSort = 'course_name';
$strDir = 'ASC';
$strReverseDir = 'DESC';
$strNameFilter = '';

if (isset($_GET['sort']) && ($_GET['sort'] != 'course_name')) {
    if ($_GET['sort'] == 'last_rate_change') {
        $strSort = 'last_rate_change';
    }
}

if (isset($_GET['dir']) && ($_GET['dir'] != 'ASC')) {
    if ($_GET['dir'] == 'DESC') {
        $strDir = 'DESC';
        $strReverseDir = 'ASC';
    }
}

if (isset($_GET['name'])) {
    $strNameFilter = $_GET['name'];
}

?>

<h1>Course Rates</h1>

<div class="filters well">
	<form method="get" class="form-inline">
		<div class="form-group">
	    	<label for="tbxName">Name</label>
		    <input type="text" class="form-control" id="tbxName" name="name" value="<?php echo $strFilter['name']; ?>" placeholder="Course Name">
		 </div>
		 <button type="submit" class="btn btn-default">Search</button>
	</form>
</div>

<?php

if(!empty($arrCoursesNoRates)){

?>
<div class="panel panel-danger">
	<div class="panel-heading" data-toggle="collapse" data-parent=".panel" href="#course-panel">
		<strong>Courses with no rates for <?php echo $strYear; ?> (<?php echo count($arrCoursesNoRates); ?>)</strong>
	</div>
	<div id="course-panel" class="panel-collapse collapse" role="tabpanel">
		<div class="panel-body">
			<table class="table table-striped">
				<tr>
					<th>
                    <?php echo "<a href='?name=".$strNameFilter."&sort=course_name&dir=".$strReverseDir."'>Course Name</a>"; ?>
                    <?php if (($strSort == 'course_name') && ($strDir == 'ASC')) { ?>
                        <span class="caret"></span>
                    <?php } ?>
                    <?php if (($strSort == 'course_name') && ($strDir == 'DESC')) { ?>
                        <span class="dropup"><span class="caret"></span></span>
                    <?php } ?>
                    </th>
					<th>Region</th>
                    <th>
                    <?php echo "<a href='?name=".$strNameFilter."&sort=last_rate_change&dir=".$strReverseDir."'>Last Rate Change</a>"; ?>
                    <?php if (($strSort == 'last_rate_change') && ($strDir == 'ASC')) { ?>
                        <span class="caret"></span>
                    <?php } ?>
                    <?php if (($strSort == 'last_rate_change') && ($strDir == 'DESC')) { ?>
                        <span class="dropup"><span class="caret"></span></span>
                    <?php } ?>
                    </th>
				</tr>

				<?php

				foreach($arrCoursesNoRates as $arrCourseNoRate){
					echo '<tr><td>';
					echo '<a href="' . ROOT_URL . '/admin/rates/course/' . $arrCourseNoRate['id'] . '">' . $arrCourseNoRate['course_name'] . '</a>';
					echo '</td>';
					echo '<td>' . $arrCourseNoRate['region_name'] . '</td>';
                    echo '<td>' . $arrCourseNoRate['last_rate_change'] . '</td></tr>';
				}

				?>
			</table>
		</div>
	</div>
</div>

<?php

} // no rates panel

?>

<div class="courses">
	<table class="table table-striped">
		<tr>
			<th>
            <?php echo "<a href='?name=".$strNameFilter."&sort=course_name&dir=".$strReverseDir."'>Course Name</a>"; ?>
            <?php if (($strSort == 'course_name') && ($strDir == 'ASC')) { ?>
                <span class="caret"></span>
            <?php } ?>
            <?php if (($strSort == 'course_name') && ($strDir == 'DESC')) { ?>
                <span class="dropup"><span class="caret"></span></span>
            <?php } ?>
            </th>
			<th>Region</th>
            <th>
            <?php echo "<a href='?name=".$strNameFilter."&sort=last_rate_change&dir=".$strReverseDir."'>Last Rate Change</a>"; ?>
            <?php if (($strSort == 'last_rate_change') && ($strDir == 'ASC')) { ?>
                <span class="caret"></span>
            <?php } ?>
            <?php if (($strSort == 'last_rate_change') && ($strDir == 'DESC')) { ?>
                <span class="dropup"><span class="caret"></span></span>
            <?php } ?>
            </th>
		</tr>

		<?php

		if(empty($arrCourses)){
			echo '<tr><td>No courses found.</td></tr>';
		}else{
			foreach($arrCourses as $arrCourse){
				echo '<tr><td>';
				echo '<a href="' . ROOT_URL . '/admin/rates/course/' . $arrCourse['id'] . '">' . $arrCourse['course_name'] . '</a>';
				echo '</td>';
				echo '<td>' . $arrCourse['region_name'] . '</td>';
                echo '<td>' . $arrCourse['last_rate_change'] . '</td></tr>';
			}
		}

		?>
	</table>
</div>

<?php

include('application/includes/admin/footer.php');