<?php
// Get the header
include('application/includes/admin/header.php');
?>

<h1 class="page-header">Rates Calculator</h1>

<form method="POST" class="calculator-form js-calculator-form">

    <div class="hidden">
        <input type="hidden" class="js-rates-selected-hotels" name="rates_selected_hotels" value="<?php echo htmlentities(json_encode($arrRatesHotels)); ?>">
        <input type="hidden" class="js-rates-selected-courses" name="rates_selected_courses" value="<?php echo htmlentities(json_encode($arrRatesCourses)); ?>">
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-9">

            <?php $objCalculator->displayMessages(); ?>

            <div class="row">
                <div class="col-xs-3">

                    <div class="form-group">
                        <label for="number_of_golfers">Number of Golfers</label>
                        <input type="number" min="1" data-restrict-number="true" name="number_of_golfers" id="number_of_golfers" class="form-control" value="<?php echo $intNumberOfGolfers; ?>">
                    </div>

                </div>
                <div class="col-xs-3">

                    <div class="form-group">
                        <label for="occupancy">Occupancy</label>
                        <input type="number" min="1" data-restrict-number="true" name="occupancy" id="occupancy" class="form-control" value="<?php echo $intOccupancy; ?>">
                    </div>

                </div>
                <div class="col-xs-3">

                    <div class="form-group">
                        <label for="date_start">Start Date</label>
                        <input type="text" name="date_start" id="date_start" class="form-control datepicker js-date-start" placeholder="yyyy-mm-dd" value="<?php echo $strDateStart; ?>">
                    </div>

                </div>
                <div class="col-xs-3">

                    <div class="form-group">
                        <label for="date_end">End Date</label>
                        <input type="text" name="date_end" id="date_end" class="form-control datepicker js-date-end" placeholder="yyyy-mm-dd" value="<?php echo $strDateEnd; ?>">
                    </div>

                </div>
            </div>

            <div class="row">
                <div class="col-xs-12">

                    <div class="form-group">
                        <label for="region">Regions</label>
                        <?php if (!empty($arrRegions)) { ?>

                        <select name="regions[]" id="region" class="js-control-regions form-control" size="10" multiple="multiple">
                            <?php
                            foreach ($arrRegions as $arrRegion) {
                                $strSelected = in_array($arrRegion['id'], $arrRegionsSelected) ? 'selected' : '';
                                echo '<option value="' . $arrRegion['id'] . '" ' . $strSelected . '>' . $arrRegion['region_name'] . '</option>';
                            }
                            ?>
                        </select>

                        <?php } else { ?>

                        <div class="alert alert-danger">No Regions found.</div>

                        <?php } ?>
                    </div>

                </div>
            </div>

            <hr>

            <div class="row">
                <div class="col-xs-12 col-sm-6">

                    <p><strong>Hotels</strong></p>

                    <?php if (!empty($arrHotelsWithRates) || !empty($arrHotelsWithoutRates)) { ?>

                    <div class="well well-sm well-overflow">
                        <table class="calculator-control-list table table-condensed">
                            <thead>
                                <tr>
                                    <th colspan="2">Name</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if (!empty($arrHotelsWithRates)) {
                                    foreach ($arrHotelsWithRates as $arrHotel) {
                                        $intId = $arrHotel['id'];
                                        $strChecked = array_key_exists($intId, $arrHotels) ? 'checked' : '';
                                        ?>
                                        <tr data-row-hotel-id="<?php echo $intId; ?>">
                                            <td colspan="2">
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="hotels[<?php echo $intId; ?>]" class="js-control-hotel" value="<?php echo $intId; ?>" <?php echo $strChecked; ?>> <?php echo $arrHotel['hotel_name']; ?></label>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                                if (!empty($arrHotelsWithoutRates)) {
                                    foreach ($arrHotelsWithoutRates as $i => $arrHotel) {
                                        ?>
                                        <tr data-row-hotel-id="<?php echo $arrHotel['id']; ?>">
                                            <td><?php echo $arrHotel['hotel_name']; ?></td>
                                            <td class="text-right"><span class="text-danger">No Rates</span></td>
                                        </tr>
                                        <?php
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>

                    <?php } else { ?>

                    <div class="alert alert-danger">No hotels could be found.</div>

                    <?php } ?>

                    <p><strong>Hotel Rates</strong></p>
                    <div class="well well-sm calculator-control-list js-rates-hotels">
                        <!-- filled with ajax -->
                    </div>

                </div>
                <div class="col-xs-12 col-sm-6">

                    <p><strong>Golf Courses</strong></p>

                    <?php if (!empty($arrCoursesWithRates) || !empty($arrCoursesWithoutRates)) { ?>

                    <div class="well well-sm well-overflow">
                        <table class="calculator-control-list table table-condensed">
                            <thead>
                                <tr>
                                    <th colspan="2">Name</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if (!empty($arrCoursesWithRates)) {
                                    foreach ($arrCoursesWithRates as $i => $arrCourse) {
                                        $intId = $arrCourse['id'];
                                        $strChecked = array_key_exists($intId, $arrCourses) ? 'checked' : '';
                                        ?>
                                        <tr data-row-course-id="<?php echo $intId; ?>">
                                            <td colspan="2">
                                                <div class="checkbox">
                                                    <label><input type="checkbox" name="courses[<?php echo $intId; ?>]" class="js-control-course" value="<?php echo $intId; ?>" <?php echo $strChecked; ?>> <?php echo $arrCourse['course_name']; ?></label>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                                if (!empty($arrCoursesWithoutRates)) {
                                    foreach ($arrCoursesWithoutRates as $i => $arrCourse) {
                                        ?>
                                        <tr data-row-course-id="<?php echo $arrCourse['id']; ?>">
                                            <td><?php echo $arrCourse['course_name']; ?></td>
                                            <td class="text-right"><span class="text-danger">No Rates</span></td>
                                        </tr>
                                        <?php
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>

                    <?php } else { ?>

                    <div class="alert alert-danger">No golf courses could be found.</div>

                    <?php } ?>

                    <p><strong>Course Rates</strong></p>
                    <div class="well calculator-control-list well-sm js-rates-courses">
                        <!-- filled with ajax -->
                    </div>

                </div>
            </div>

            <hr>

            <div class="row">
                <div class="col-xs-12">

                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Modifier</th>
                                <th>Operation</th>
                                <th>Value</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($arrModifiers as $i => $arrModifier) { ?>
                            <tr>
                                <td>
                                    <input type="text" name="modifiers[<?php echo $i; ?>][label]" class="form-control" value="<?php echo $arrModifier['label']; ?>">
                                </td>
                                <td>
                                    <select name="modifiers[<?php echo $i; ?>][operation]" class="form-control">
                                        <option <?php if ($arrModifier['operation'] == 'multiplication') { echo 'selected'; } ?> value="multiplication">[ &times; ] Multiplication</option>
                                        <!-- <option <?php if ($arrModifier['operation'] == 'division') { echo 'selected'; } ?> value="division">[ &divide; ] Division</option> -->
                                        <!-- <option <?php if ($arrModifier['operation'] == 'addition') { echo 'selected'; } ?> value="addition">[ + ] Addition</option> -->
                                        <!-- <option <?php if ($arrModifier['operation'] == 'subtraction') { echo 'selected'; } ?> value="subtraction">[ - ] Subtraction</option> -->
                                    </select>
                                </td>
                                <td>
                                    <input type="text" name="modifiers[<?php echo $i; ?>][value]" class="form-control" value="<?php echo $arrModifier['value']; ?>">
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                </div>
            </div>

        </div>
        <div class="col-xs-12 col-sm-3">

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Calculator</h3>
                </div>
                <div class="panel-body">
                    <?php /* ?>
                    <div class="form-group">
                        <label for="export">Export:</label>
                        <input type="text" id="export" name="export" class="form-control" onclick="select()" value="<?php echo !empty($_POST) ? htmlentities(json_encode($_POST)) : ''; ?>">
                    </div>
                    <div class="form-group">
                        <label for="import">Import:</label>
                        <input type="text" id="import" name="import" class="form-control" value="">
                    </div>
                    <?php */ ?>
                    <div class="btn-group btn-group-justified">
                        <div class="btn-group"><input type="submit" class="btn btn-primary" value="Calculate"></div>
                    </div>
                </div>
                <?php
                $objTotals = $objCalculator->getTotals();

                echo '<table class="table table-bordered"><tbody>';

                if (!empty($objTotals['public'])) {

                    echo '<tr><th style="text-align:center" colspan=2>Public Rates</th></tr>';
                    foreach ($objTotals['public'] as $strTitle => $fltValue) {
                        echo '<tr>'
                            . '<th>' . $strTitle . '</th>'
                            . '<td>' . Util::formatPrice($fltValue) . '</td>'
                            . '</tr>';
                    }
                    //echo  '</tbody></table>';
                }

                if (!empty($objTotals['private'])) {
                    echo '<tr><th style="text-align:center" colspan=2>Private Rates</th></tr>';
                    foreach ($objTotals['private'] as $strTitle => $fltValue) {
                        echo '<tr>'
                            . '<th>' . $strTitle . '</th>'
                            . '<td>' . Util::formatPrice($fltValue) . '</td>'
                            . '</tr>';
                    }
                    //echo  '</tbody></table>';
                }

                echo  '</tbody></table>';
                ?>
            </div>


            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Calculator Output (Public Rates)</h3>
                </div>
                <div class="panel-body">
                    <?php $objCalculator->displayOutput(); ?>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Calculator Output (Private Rates)</h3>
                </div>
                <div class="panel-body">
                    <?php $objCalculator->displayOutputPrivate(); ?>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Preamble</h3>
                </div>
                <div class="panel-body">
                    <?php $objCalculator->displayPreamble(); ?>
                </div>
            </div>

        </div>
    </div>

</form>

<script>
$(document).ready(function($) {
    // Get rates on page load
    fnGetRates();

    // Set the default states on page load
    fnGetFilters();

    // Get new rates when the date changes
    $('.js-date-start').on('change', function() {
        fnGetRates();
    });
    $('.js-date-end').on('change', function() {
        fnGetRates();
    });

    // AJAX call to get the rates
    $('.js-control-hotel').on('click', function() {
        fnGetRates();
    });
    $('.js-control-course').on('click', function() {
        fnGetRates();
    });

    // Toggle the disabled state on the rate controls
    $('body').on('click', '.js-control-hotel-rate', function() {
        fnToggleControls();
    })
    $('body').on('click', '.js-control-course-rate', function() {
        fnToggleControls();
    })

    // Filter controls when a region is selected
    $('.js-control-regions').on('change', function() {
        // Reset the controls
        fnResetControls();
        fnResetRates();

        // Get the field value
        var objValue = $(this).val();

        if (objValue == null) {
            // Reset the form controls
            fnResetFilters();
        } else {
            // Get a list of hotels and courses filtered by region
            $.ajax({
                url: '<?php echo ROOT_URL . "/application/ajax.php"; ?>',
                type: 'POST',
                data: {
                    action: 'filterByRegions',
                    regions: objValue
                },
                success: function(strResponse) {
                    // Parse the response
                    objResponse = $.parseJSON(strResponse);

                    if (!objResponse.error) {
                        // Success
                        fnSetFilters(objResponse.data);
                    } else {
                        fnResetFilters();
                    }
                }
            });
        }
    });

    /**
     * Enables or disables the nights and room controls when a hotel is selected
     *
     */
    function fnToggleControls() {
        // The control types
        var objControls = [
            $('.js-control-hotel-rate'),
            $('.js-control-course-rate')
        ];

        for (var i=0; i<objControls.length; i++) {
            // Loop through each of the hotel controls
            objControls[i].each(function() {
                // Get the control objects
                var jobjItem = $(this);
                var jobjControls = jobjItem.closest('tr').find('.form-control');

                if (jobjItem.is(':checked') && typeof(jobjControls) !== 'undefined') {
                   // Enable the control
                   jobjControls.removeAttr('disabled');
                } else {
                    // Disable the control
                    jobjControls.attr('disabled', 'disabled');
                }
            });
        }
    }

    /**
     * Shows all of the hotel and course controls and unchecks them
     *
     */
    function fnResetFilters() {
        // Show all our options
        $('[data-row-hotel-id]').show();
        $('[data-row-course-id]').show();
    }

    /**
     * Unchecks checkbox controls
     *
     */
    function fnResetControls() {
        // Remove options that are checked
        $('.js-control-hotel:checked').removeAttr('checked');
        $('.js-control-course:checked').removeAttr('checked');
        fnToggleControls();
    }

    /**
     * Sets the selected state of the rates on postback
     *
     */
    function fnSetRates() {
        var objRatesHotels = $.parseJSON($('.js-rates-selected-hotels').val());
        var objRatesCourses = $.parseJSON($('.js-rates-selected-courses').val());

        // Selected the hotel rates
        if (typeof(objRatesHotels) !== 'undefined') {
            for (var intRateId in objRatesHotels) {
                $('.js-control-hotel-rate-' + intRateId).attr('checked', 'checked');
            }
        }

        // Select the course rates
        if (typeof(objRatesCourses) !== 'undefined') {
            for (var intRateId in objRatesCourses) {
                $('.js-control-course-rate-' + intRateId).attr('checked', 'checked');
            }
        }

        // Set the disable states
        fnToggleControls();
    }

    /**
     * Clears the rates controls
     *
     */
    function fnResetRates() {
        // Remove any output
        $('.js-rates-hotels').html('');
        $('.js-rates-courses').html('');
    }

    /**
     * Filters the list of hotels and courses by regions
     *
     */
    function fnGetFilters() {
        // Get the field value
        var objValue = $('.js-control-regions').val();

        if (objValue == null) {
            // Reset the form controls
            fnResetFilters();
        } else {
            // Get a list of hotels and courses filtered by region
            $.ajax({
                url: '<?php echo ROOT_URL . "/application/ajax.php"; ?>',
                type: 'POSt',
                data: {
                    action: 'filterByRegions',
                    regions: objValue
                },
                success: function(strResponse) {
                    // Parse the response
                    objResponse = $.parseJSON(strResponse);

                    if (!objResponse.error) {
                        // Success
                        fnSetFilters(objResponse.data);
                    } else {
                        fnResetFilters();
                    }
                }
            });
        }
    }

    /**
     * Sets the filter states
     *
     */
    function fnSetFilters(objData) {
        // Exit if there's no data
        if (typeof(objData) == 'undefined') {
            return;
        }

        // Get our control rows
        var jobjHotelRows = $('[data-row-hotel-id]');
        var jobjCourseRows = $('[data-row-course-id]');

        // Show our rows to start
        jobjHotelRows.hide();
        jobjCourseRows.hide();

        // Check the hotel data
        if (typeof(objData.hotels) !== 'undefined') {
            var objHotels = objData.hotels;
            for (var i=0; i<objHotels.length; i++) {
                // Reveal the hotel row
                $('[data-row-hotel-id=' + objHotels[i] + ']').show();
            }
        }

        // Check the course data
        if (typeof(objData.courses) !== 'undefined') {
            var objCourses = objData.courses;
            for (var i = 0; i < objCourses.length; i++) {
                // Reveal the course row
                $('[data-row-course-id=' + objCourses[i] + ']').show();
            }
        }
    }

    /**
     * Returns a list of applicable rates
     *
     */
    function fnGetRates() {
        // Get the form fields
        var strFormData = $('.js-calculator-form').serialize();

        $.ajax({
            url: '<?php echo ROOT_URL . "/application/ajax.php"; ?>',
            type: 'POST',
            data: {
                action: 'getRates',
                data: strFormData
            },
            success: function(strResponse) {
                // Parse the response
                objResponse = $.parseJSON(strResponse);

                if (!objResponse.error) {
                    // Success
                    objData = objResponse.data;

                    if (typeof(objData.html_hotels) !== 'undefined' || objData.html_hotels.length > 0) {
                        $('.js-rates-hotels').html(objData.html_hotels);
                    }

                    if (typeof(objData.html_courses) !== 'undefined' || objData.html_courses.length > 0) {
                        $('.js-rates-courses').html(objData.html_courses);
                    }

                    // Selected any checked rates
                    fnSetRates();

                    // Trigger the tooltips for the rate notes
                    $('[data-toggle=tooltip]').tooltip();

                } else {
                    // Error
                }
            }
        });
    }
});
</script>

<?php
// Get the footer
include('application/includes/admin/footer.php');