<?php
global $arrRatesHotels, $arrRatesSelectedHotels;

// override for set rates
if (!empty($arrPackageRatesHotels)) {
    $arrRatesHotels = $arrPackageRatesHotels;
    $arrRatesSelectedHotels = $arrPackageRatesHotels;
}

// Exit if there's no rates
if (empty($arrRatesHotels)) {
    return;
}

?>

<?php foreach ($arrRatesHotels as $intHotelId => $arrRates) {  ?>
<table class="table table-condensed">
    <thead>
        <tr>
            <th width="66%"><?php echo !empty($arrRates[0]['hotel_name']) ? $arrRates[0]['hotel_name'] : ''; ?></th>
            <th>Nights</th>
            <th>Rooms</th>
            <th class="text-right">Price</th>
        </tr>    
    </thead>
    <tbody>        
        <tr>
            <?php foreach ($arrRates as $arrRate) { ?>
            <tr>
                <td>
                    <div class="checkbox">
                        <label>
                            <?php
                            $intRateId = $arrRate['id'];
                            $strChecked = array_key_exists($intRateId, $arrRatesSelectedHotels) || count($arrRates) == 1 ? 'checked' : '';
                            $intNights = !empty($arrRatesSelectedHotels[$intRateId]['nights']) ? $arrRatesSelectedHotels[$intRateId]['nights'] : 1;
                            $intRooms = !empty($arrRatesSelectedHotels[$intRateId]['rooms']) ? $arrRatesSelectedHotels[$intRateId]['rooms'] : 1;

                            // Output the control
                            echo '<input type="checkbox" name="rates_hotels[' . $intRateId . '][id]" class="js-control-hotel-rate js-control-hotel-rate-' . $intRateId . '" value="' . $intRateId . '" ' . $strChecked . '> '
                               . $arrRate['name'];

                            // Output the notes if set
                            if (!empty($arrRate['notes'])) {
                                echo ' <span class="fa fa-info-circle" data-toggle="tooltip" data-placement="right" title="' . htmlentities($arrRate['notes']) . '"></span>';
                            }
                            ?>
                        </label>
                        <span class="rate-date">
                            <?php
                            // Set start and end dates
                            $strStart = !empty($arrRate['start_date']) ? date('Y-m-d', strtotime($arrRate['start_date'])) : '';
                            $strEnd = !empty($arrRate['end_date']) ? date('Y-m-d', strtotime($arrRate['end_date'])) : '';
                            
                            // Display the range
                            echo implode(' to ', array($strStart, $strEnd));
                            ?>
                        </span>
                    </div>
                </td>
                <td><input type="number" min="1" data-restrict-number="true" name="rates_hotels[<?php echo $intRateId; ?>][nights]" class="form-control input-sm" value="<?php echo $intNights; ?>" disabled></td>
                <td><input type="number" min="1" data-restrict-number="true" name="rates_hotels[<?php echo $intRateId; ?>][rooms]" class="form-control input-sm" value="<?php echo $intRooms; ?>" disabled></td>
                <td class="text-right"><?php echo $arrRate['private_price']; ?></td>
            </tr>
            <?php } ?>
        </tr> 
    </tbody>
</table>
<?php } ?>
