<?php
global $arrRatesCourses, $arrRatesSelectedCourses;

// Exit if there's no rates
if (empty($arrRatesCourses)) {
    return;
}
?>

<?php foreach ($arrRatesCourses as $intCourseId => $arrRates) {  ?>
<table class="table table-condensed">
    <thead>
        <tr>
            <th width="75%"><?php echo !empty($arrRates[0]['course_name']) ? $arrRates[0]['course_name'] : ''; ?></th>
            <th>Rounds</th>
            <th class="text-right">Price</th>
        </tr>    
    </thead>
    <tbody>        
        <tr>
            <?php foreach ($arrRates as $arrRate) { ?>
            <tr>
                <td>
                    <div class="checkbox">
                        <label>
                            <?php
                            $intRateId = $arrRate['id'];
                            $strChecked = array_key_exists($intRateId, $arrRatesSelectedCourses) || count($arrRates) == 1 ? 'checked' : '';
                            $intRounds = !empty($arrRatesSelectedCourses[$intRateId]['rounds']) ? $arrRatesSelectedCourses[$intRateId]['rounds'] : 1;

                            // Output the control
                            echo '<input type="checkbox" name="rates_courses[' . $intRateId . '][id]" class="js-control-course-rate js-control-course-rate-' . $intRateId . '" value="'. $intRateId . '" ' . $strChecked . '> '
                               . $arrRate['name'];

                            // Output the notes if set
                            if (!empty($arrRate['notes'])) {
                                echo ' <span class="fa fa-info-circle" data-toggle="tooltip" data-placement="right" title="' . htmlentities($arrRate['notes']) . '"></span>';
                            }
                            ?>
                        </label>
                        <span class="rate-date">
                            <?php
                            // Set start and end dates
                            $strStart = !empty($arrRate['start_date']) ? date('Y-m-d', strtotime($arrRate['start_date'])) : '';
                            $strEnd = !empty($arrRate['end_date']) ? date('Y-m-d', strtotime($arrRate['end_date'])) : '';
                            
                            // Display the range
                            echo implode(' to ', array($strStart, $strEnd));
                            ?>
                        </span>
                    </div>
                </td>
                <td><input type="number" min="1" data-restrict-number="true" name="rates_courses[<?php echo $intRateId; ?>][rounds]" class="form-control input-sm" value="<?php echo $intRounds; ?>" disabled></td>
                <td class="text-right"><?php echo $arrRate['private_price']; ?></td>
            </tr>
            <?php } ?>
        </tr> 
    </tbody>
</table>
<?php } ?>
