<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="grid-view">

	<h1 class="page-header">
		Manage <?php echo $this->objModel->strTitle; ?>
		<?php if(checkpageaccess($_REQUEST['controller'],'add') == 'ture' ){ ?>
		<a href="<?php echo $this->strAdminSlug;?>add/" class="btn btn-sm btn-secondary">Add New</a>
		<?php } ?>
	</h1>

	<form class="filter-bar" id="detail-form" method="post" role="form">
		<div class="row">
			<div class="col-md-12">
				<?php

	            if(isset($this->strGroupErrorMessage) && $this->strGroupErrorMessage != '') {
	                echo '<div class="alert alert-danger">' . $this->strGroupErrorMessage . '</div>';
	            } else if(isset($this->strGroupSuccessMessage) && $this->strGroupSuccessMessage != '') {
	                echo '<div class="alert alert-success">' . $this->strGroupSuccessMessage . '</div>';
	            }

	            ?>
			</div>
			<div class="col-md-5">
				<div class="form-group">
                    <label for="group_name">Group Name:</label>
                    <input type="text" name="group_name" id="group_name" class="form-control input-sm" placeholder="Enter Group Name Here" value="<?php echo $this->strGroupName; ?>">
                </div>
			</div>
			<div class="col-md-5">
				<div class="form-group">
                    <label for="completed">Status:</label>

                    <?php

                    if($this->strGroupStatus == 'converted'){
                    	echo '<div style="margin: 5px 0;">' . ucwords($this->strGroupStatus) . '</div>';
                    	echo '<input type="hidden" name="status" value="' . $this->strGroupStatus . '" />';
                    }else{
                    	?>

                    	<select name="status" id="status" class="form-control">
	                    	<option value="Active" <?php if($this->strGroupStatus == 'Active'){echo 'selected="selected"';} ?>>Active</option>
	                    	<option value="Trash" <?php if($this->strGroupStatus == 'Trash'){echo 'selected="selected"';} ?>>Trash</option>
	                    </select> 

                    	<?php
                    }

                    ?>

                                                           


                </div>
			</div>
			<div class="col-md-2">
				<div class="buttons" style="margin-top: 27px;">
					<input type="hidden" name="action" value="updateGroup" />
					<input type="submit" class="btn btn-primary btn-save" value="Save">
					<i class="fa fa-spinner fa-pulse btn-loading"></i>
				</div>
			</div>
			<div class="col-md-10">
				<label for="admin_note">Admin Notes:</label><br />
				<textarea name="admin_note" id="admin_note" class="form-control" style="height: 100px;"><?php echo $this->strAdminNote; ?></textarea>
			</div>
		</div>
	</form>

	<form class="grid-filters" role="form">

		<div class="grid-table-header">
			<div class="row">

				<?php
	            if($this->strErrorMessage != '') {
	                echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
	            } else if($this->strSuccessMessage != '') {
	                echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
	            }
	            ?>

				<div class="col-xs-12 col-sm-6">

					<ul class="grid-statuses list-inline clearfix">
						<li class="<?php echo Util::isValue($this->strStatus, array('Active', 'all'), 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/all/">All <span class="count">(<?php echo $this->objModel->getPageCount($this->intGroupId); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'active', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/active/">Active <span class="count">(<?php echo $this->objModel->getPageCount($this->intGroupId, 'Active'); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'converted', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/converted/">Converted <span class="count">(<?php echo $this->objModel->getPageCount($this->intGroupId, 'Converted'); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'trash', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/trash/">Trash <span class="count">(<?php echo $this->objModel->getPageCount($this->intGroupId, 'Trash'); ?>)</span></a></li>
					</ul>
					<!-- Statuses -->

					<div class="input-group bulk-actions">
						<select name="bulk_action" id="bulk_action1" class="form-control input-sm">
							<option value="">Bulk Action</option>
							<option value="trash">Move to Trash</option>
							<option value="restore">Restore</option>
						</select>
						<div class="input-group-btn">
							<input type="submit" name="bulk" id="bulk1" class="btn btn-secondary btn-sm" value="Apply">
						</div>
					</div>
					<!-- Bulk Actions -->

				</div>

				<div class="col-xs-12 col-sm-6">

					<div class="input-group grid-search">
						<input type="text" name="searchWord" id="searchWord" class="form-control input-sm" placeholder="Group name" value="<?php echo $this->strSearchWord;?>">
						<div class="input-group-btn">
							<input type="submit" name="search" id="search" class="btn btn-secondary btn-sm" value="Search ">
						</div>
					</div>

					<?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, $this->strOptions, $this->strPgSize); ?>

				</div>

			</div>


			<div class="row">

				<div class="col-xs-12 filter-bar form-inline">

					<?php if (!empty($this->arrStatus)) { ?>
					<strong>Filters:</strong>
					<div class="form-group">
						<select name="grid_completed" id="" class="form-control input-sm" style="width:200px" >
							<option value="">All Statuses</option>
							<?php foreach($this->arrStatus AS $stat) {
								echo '<option value="'.$stat['id'].'" '.Util::isSelected($stat['id'], $this->intGridCompleted) .'>'.$stat['status_name'].'</option>';
							} ?>
						</select>
					</div>
					<?php } ?>

					<div class="form-group">
						<label for="grid_date" class="sr-only">Order By:</label>
						<select name="grid_date" class="form-control input-sm">
							<option value="">Please Choose</option>
							<option value="order_date" <?php echo Util::isSelected('order_date', $this->strGridDateType); ?>>Order Date</option>
							<option value="dates_arrival" <?php echo Util::isSelected('dates_arrival', $this->strGridDateType); ?>>Arrival Date</option>
							<option value="dates_depart" <?php echo Util::isSelected('dates_depart', $this->strGridDateType); ?>>Departure Date</option>
							<option value="edit_date" <?php echo Util::isSelected('edit_date', $this->strGridDateType); ?>>Edit Date</option>
							<option value="dates_booking" <?php echo Util::isSelected('dates_booking', $this->strGridDateType); ?>>Booking Date</option>
						</select>
					</div>
					<div class="form-group">
						<select name="year" id="year" class="form-control input-sm">
							<?php 
							$y = Date('Y') + 5;
							for($i = $y;$i > ($y-11);$i--){
								echo '<option value="'.$i.'" '.util::isSelected($i,$this->intYear).'>'.$i.'</option>';
							}

							?>
						</select>
					</div>
					<div class="form-group">
						<select name="month" id="month" class="form-control input-sm">
							<option value="">Please Choose</option>
							<option value="1" <?php echo util::isSelected("1",$this->intMonth);?>>January</option>
							<option value="2" <?php echo util::isSelected("2",$this->intMonth);?>>Febuary</option>
							<option value="3" <?php echo util::isSelected("3",$this->intMonth);?>>March</option>
							<option value="4" <?php echo util::isSelected("4",$this->intMonth);?>>April</option>
							<option value="5" <?php echo util::isSelected("5",$this->intMonth);?>>May</option>
							<option value="6" <?php echo util::isSelected("6",$this->intMonth);?>>June</option>
							<option value="7" <?php echo util::isSelected("7",$this->intMonth);?>>July</option>
							<option value="8" <?php echo util::isSelected("8",$this->intMonth);?>>August</option>
							<option value="9" <?php echo util::isSelected("9",$this->intMonth);?>>September</option>
							<option value="10" <?php echo util::isSelected("10",$this->intMonth);?>>October</option>
							<option value="11" <?php echo util::isSelected("11",$this->intMonth);?>>November</option>
							<option value="12" <?php echo util::isSelected("12",$this->intMonth);?>>December</option>
						</select>
					</div>

					<input type="submit" class="btn btn-default btn-sm" value="Apply">

					<div class="pull-right" style="width: 150px;">
						<div class="input-group">
							<input type="text" value="<?php echo $this->strPgSize;?>" name="pgSize" class="form-control input-sm" />
							<div class="input-group-btn">
								<input type="submit" class="btn btn-default btn-sm" value="Apply">
							</div>
						</div>
					</div>

					<!-- <input type="text" placeholder="Start Date" class="form-control datepicker input-sm" value="<?php echo $this->strStartDate; ?>" name="start_date" /> -->
					<!-- <input type="text" placeholder="End Date" class="form-control datepicker input-sm" value="<?php echo $this->strEndDate; ?>" name="end_date" /> -->

					<div class="clearfix"></div>

					<div class="filter-date">

						<div class="filter-title">
							<a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear)-1; ?>&amp;month=<?php echo $this->intMonth; ?>&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">
								&laquo;</a>

								<b><?php echo $this->intYear; ?></b> <a href="<?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear)+1; ?>&amp;month=<?php echo $this->intMonth; ?>&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">&raquo;</a>
						</div>

						<ul>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=1&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Jan</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=2&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Feb</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=3&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Mar</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=4&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Apr</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=5&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">May</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=6&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Jun</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=7&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Jul</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=8&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Aug</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=9&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Sep</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=10&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Oct</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=11&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Nov</a></li>
							<li><a href="<?php echo $this->strAdminSlug; ?><?php echo $this->strOptions; ?>&amp;year=<?php echo ($this->intYear); ?>&amp;month=12&amp;grid_date=<?php echo ($this->strGridDateType); ?>&amp;grid_completed=<?php echo ($this->intGridCompleted); ?>&amp;pgSize=<?php echo ($this->strPgSize); ?>">Dec</a></li>
						</ul>

					</div>


				</div>
				<!-- Filters -->

			</div>


		</div>

		<hr>

		<div class="table-responsive">
			<table class="table table-hover text-small">
				<thead>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, $this->strOptions . '&amp;year='.($this->intYear).'&amp;month='.($this->intMonth).'&amp;grid_date='.($this->strGridDateType).'&amp;grid_completed='.($this->intGridCompleted)); ?>
				</thead>

				<tfoot>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, $this->strOptions . '&amp;year='.($this->intYear).'&amp;month='.($this->intMonth).'&amp;grid_date='.($this->strGridDateType).'&amp;grid_completed='.($this->intGridCompleted)); ?>
				</tfoot>

				<tbody>
				<?php

				// Get our customized grid view
				include(ROOT_DIR.'/application/views/admin/list/'.$this->strView.'.php');

				?>
				</tbody>
			</table>
		</div>

		<hr>

		<div class="grid-table-footer">
			<div class="row">

				<div class="col-xs-12 col-sm-6">
					<div class="input-group bulk-actions">
						<select name="bulk_action2" id="bulk_action2" class="form-control input-sm">
							<option value="">Bulk Action</option>
							<option value="trash">Move to Trash</option>
							<option value="restore">Restore</option>
						</select>
						<div class="input-group-btn">
							<input type="submit" name="bulk" id="bulk2" class="btn btn-secondary btn-sm" value="Apply">
						</div>
						<!-- Bulk Actions -->
					</div>
				</div>

				<div class="col-xs-12 col-sm-6">
					<?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, $this->strOptions . '&amp;year='.($this->intYear).'&amp;month='.($this->intMonth).'&amp;grid_date='.($this->strGridDateType).'&amp;grid_completed='.($this->intGridCompleted), $this->strPgSize); ?>
				</div>

			</div>

			<hr>

		</div>

	</form>

</div>

<div class="modal fade duplicate-modal js-duplicate-quote-modal" data-post-url="<?php echo $this->strAdminSlug; ?>duplicate/">
	<form method="post" action="">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	        <h4 class="modal-title">Duplicate Quote</h4>
	      </div>
	      <div class="modal-body">
	      	<div class="row row-border-bottom">
	      		<div class="col-md-4 col-padding-height" style="border-right: 1px solid #eeeeee;">
	      			<button class="btn btn-success" type="submit" name="group_type" value="current">Use Current Group</button>
	      		</div>

	      		<div class="col-md-8 col-padding-height">
      				<div class="input-group">
				      <input type="text" class="form-control" name="group_name" placeholder="Group Name">
				      <span class="input-group-btn">
				        <button class="btn btn-primary" type="submit" name="group_type" value="new">Create Group</button>
				      </span>
				    </div>
	      		</div>
	      	</div>

	      	<div class="row">
	      		<div class="col-md-12" style="margin-top: 12px;">
	      			<h4>Use Existing Group</h4>
	      		</div>
	      		<div class="col-md-12">
	      			<div class="input-group">
		      			<select name="existing_group" class="form-control">
		      				<?php 

		      				foreach($this->arrGroups as $arrGroup){
		      					$strGroupName = '';

		      					if(!empty($arrGroup['group_name'])){
		      						$strGroupName = ' - ' . $arrGroup['group_name'];
		      					}

		      					echo '<option value="' . $arrGroup['id'] . '">' . $arrGroup['id'] . $strGroupName . '</option>';
		      				}

		      				?>
						</select>
						<span class="input-group-btn">
							<button class="btn btn-primary" type="submit" name="group_type" value="existing">Use Selected Group</button>
						</span>
					</div>
	      		</div>
	      	</div>

      		<div class="hide">
      			<input type="hidden" class="js-quote-id" name="quote_id" value="" />
      		</div>
	      </div>
	      <div class="modal-footer" style="margin-top: 3px;">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	      </div>
	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
  </form>
</div><!-- /.modal -->