<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="grid-view">

	<h1 class="page-header">
		Manage <?php echo $this->objModel->strTitle; ?>
		<?php if(checkpageaccess($_REQUEST['controller'],'add') == 'ture' ){ ?>
		<a href="<?php echo $this->strAdminSlug;?>add/" class="btn btn-sm btn-secondary">Add New</a>
		<?php } ?>
	</h1>

	<form class="grid-filters" role="form">

		<div class="grid-table-header">
			<div class="row">

				<?php
	            if($this->strErrorMessage != '') {
	                echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
	            } else if($this->strSuccessMessage != '') {
	                echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
	            }
	            ?>

				<div class="col-xs-12 col-sm-6">

					<ul class="grid-statuses list-inline clearfix">
						<li class="<?php echo Util::isValue($this->strStatus, 'all', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/all/">All <span class="count">(<?php echo $this->objModel->getPageCount(); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, array('Active', 'active'), 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/active/">Active <span class="count">(<?php echo $this->objModel->getPageCount('Active'); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'converted', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/converted/">Converted <span class="count">(<?php echo $this->objModel->getPageCount('Converted'); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'trash', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/trash/">Trash <span class="count">(<?php echo $this->objModel->getPageCount('Trash'); ?>)</span></a></li>
					</ul>
					<!-- Statuses -->

					<div class="input-group bulk-actions">
						<select name="bulk_action" id="bulk_action1" class="form-control input-sm">
							<option value="">Bulk Action</option>
							<option value="trash">Move to Trash</option>
							<option value="restore">Restore</option>
						</select>
						<div class="input-group-btn">
							<input type="submit" name="bulk" id="bulk1" class="btn btn-secondary btn-sm" value="Apply">
						</div>
					</div>
					<!-- Bulk Actions -->

				</div>

				<div class="col-xs-12 col-sm-6">

					<div class="input-group grid-search">
						<input type="text" name="searchWord" id="searchWord" class="form-control input-sm" placeholder="Group name" value="<?php echo $this->strSearchWord;?>">
						<div class="input-group-btn">
							<input type="submit" name="search" id="search" class="btn btn-secondary btn-sm" value="Search ">
						</div>
					</div>

                    <?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, '?' . $this->strOptions, $this->strPgSize); ?>

				</div>

			</div>


			<div class="row">

				<div class="col-xs-12 filter-bar form-inline">

                    <?php if (!empty($this->arrAgency)) { ?>
                    <div class="form-group">
                        <label for="grid_agency" class="sr-only">Agency:</label>
                        <select name="grid_agency" class="form-control input-sm">
                            <option value="">- Agency -</option>
                            <?php
                            foreach ($this->arrAgency as $value) {
                                echo '<option value="' . $value . '" ' . Util::isSelected($value, $this->strGridAgency) . '>' . $value . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <?php } ?>

                    <?php if (!empty($this->arrAgent)) { ?>
                    <div class="form-group">
                        <label for="grid_agent" class="sr-only">Agent:</label>
                        <select name="grid_agent" class="form-control input-sm">
                            <option value="">- Agent -</option>
                            <?php
                            foreach ($this->arrAgent as $value) {
                                echo '<option value="' . $value . '" ' . Util::isSelected($value, $this->strGridAgent) . '>' . $value . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <?php } ?>

                    <div class="form-group">
                        <label for="grid_email_read" class="sr-only">Email Read:</label>
                        <select name="grid_email_read" class="form-control input-sm">
                            <option value="">- Email Read -</option>
                            <option value="1" <?php echo Util::isSelected('1', $this->strGridEmailRead); ?>>Yes</option>
                            <option value="0" <?php echo Util::isSelected('0', $this->strGridEmailRead); ?>>No</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="grid_date" class="sr-only">Order By:</label>
                        <select name="grid_date" class="form-control input-sm">
                            <option value="">- Date -</option>
                            <option value="order_date" <?php echo Util::isSelected('order_date', $this->strGridDateType); ?>>Order Date</option>
                            <option value="edit_date" <?php echo Util::isSelected('edit_date', $this->strGridDateType); ?>>Last Edit</option>
                            <option value="dates_arrival" <?php echo Util::isSelected('dates_arrival', $this->strGridDateType); ?>>Arrival Date</option>
                        </select>
                    </div>

					<div class="form-group">
                        <label for="year" class="sr-only">Year:</label>
						<select name="year" id="year" class="form-control input-sm">
							<?php
							$y = Date('Y') + 5;
							for($i = $y;$i > ($y-11);$i--){
								echo '<option value="'.$i.'" '.util::isSelected($i,$this->intYear).'>'.$i.'</option>';
							}
							?>
						</select>
					</div>

					<div class="form-group">
                        <label for="month" class="sr-only">Month:</label>
						<select name="month" id="month" class="form-control input-sm">
							<option value="">- Month -</option>
							<option value="1" <?php echo util::isSelected("1",$this->intMonth);?>>January</option>
							<option value="2" <?php echo util::isSelected("2",$this->intMonth);?>>Febuary</option>
							<option value="3" <?php echo util::isSelected("3",$this->intMonth);?>>March</option>
							<option value="4" <?php echo util::isSelected("4",$this->intMonth);?>>April</option>
							<option value="5" <?php echo util::isSelected("5",$this->intMonth);?>>May</option>
							<option value="6" <?php echo util::isSelected("6",$this->intMonth);?>>June</option>
							<option value="7" <?php echo util::isSelected("7",$this->intMonth);?>>July</option>
							<option value="8" <?php echo util::isSelected("8",$this->intMonth);?>>August</option>
							<option value="9" <?php echo util::isSelected("9",$this->intMonth);?>>September</option>
							<option value="10" <?php echo util::isSelected("10",$this->intMonth);?>>October</option>
							<option value="11" <?php echo util::isSelected("11",$this->intMonth);?>>November</option>
							<option value="12" <?php echo util::isSelected("12",$this->intMonth);?>>December</option>
						</select>
					</div>

                    <input type="submit" class="btn btn-default btn-sm" value="Apply">
                    <a href="<?php echo '?' . $this->strOptions . '&export=1'; ?>" target="_blank" class="btn btn-primary btn-sm" style="margin-left: 30px">Export Data</a>

					<div class="pull-right" style="width: 150px;">
                        <div class="input-group">
							<input type="text" value="<?php echo $this->strPgSize;?>" name="pgSize" class="form-control input-sm" />
							<div class="input-group-btn">
								<input type="submit" class="btn btn-default btn-sm" value="Apply">
							</div>
						</div>
					</div>

				</div>
				<!-- Filters -->

			</div>


		</div>

		<hr>

		<div class="table-responsive">
			<table class="table table-hover text-small">
				<thead>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, '&' . $this->strOptions); ?>
				</thead>

				<tfoot>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, '&' . $this->strOptions); ?>
				</tfoot>

				<tbody>
				<?php

				// Get our customized grid view
				include(ROOT_DIR.'/application/views/admin/list/'.$this->strView.'.php');

				?>
				</tbody>
			</table>
		</div>

		<hr>

		<div class="grid-table-footer">
			<div class="row">

				<div class="col-xs-12 col-sm-6">
					<div class="input-group bulk-actions">
						<select name="bulk_action2" id="bulk_action2" class="form-control input-sm">
							<option value="">Bulk Action</option>
							<option value="trash">Move to Trash</option>
							<option value="restore">Restore</option>
						</select>
						<div class="input-group-btn">
							<input type="submit" name="bulk" id="bulk2" class="btn btn-secondary btn-sm" value="Apply">
						</div>
						<!-- Bulk Actions -->
					</div>
				</div>

				<div class="col-xs-12 col-sm-6">
					<?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, '?' .$this->strOptions, $this->strPgSize); ?>
				</div>

			</div>

			<hr>

		</div>

	</form>

</div>