	<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

if(count($this->arrPages) == 0) {
	echo '<tr><td colspan="'.count($this->arrTableSQLArray).'" class="no-results">No results</td></tr>';
} else {
	//var_dump($this->arrPages);
	foreach($this->arrPages As $page) {
		$strStatusColor = '#000000';

		if(!empty($page['status_color'])){
			$strStatusColor = $page['status_color'];
		}

		?>
		<tr>
			<td><input type="checkbox" name="pageID[]" value="<?php echo $page['id'];?>"></td>
			<td>
				<a href="<?php echo $this->strGroupSlug; ?><?php echo $page['id'];?>/?sub=true"><?php echo $page['group_name'];?></a>
				<?php echo $this->getPageControls($page['id'], $this->strTableName, $page['status'], false); ?>
			</td>
            <td><?php echo $page['quote_name']; ?></td>
			<td><?php echo $page['user_name']; ?></td>
			<td><?php echo $page['agency']; ?></td>
			<td><?php echo $page['booking_person']; ?></td>
            <td><?php echo $page['players_num']; ?></td>
			<td><?php
				if ($page['email_read'] === '1') {
					echo 'Yes';
				} else if ($page['email_read'] === '0') {
					echo 'No';
				} else {
					echo 'Unknown';
				}?>
			</td>
            <td><?php echo $page['quote_order_date']; ?></td>
            <td><?php echo $page['quote_last_edit']; ?></td>
			<td><?php echo $page['quote_arrival_date']; ?></td>
			<td><?php
				if(!empty($page['quote_status'])){
					$strColor = $page['quote_status_color'];
					echo '<span style="color:' . $strColor . '">' . $page['quote_status'] . '</span>';
				}
			?></td>
		</tr>
		<?php
	}
}
