<?php
/**
* Subview for the page gridview, the wrapper view is default_list_view.php
*
* This view is specific to the page model
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/


if(count($this->arrPages) == 0) {
	echo '<tr><td colspan="'.count($this->arrTableSQLArray).'" class="no-results">No results</td></tr>';
} else {
	foreach($this->arrPages As $page) {
		?>
		<tr>
			<td><input type="checkbox" name="pageID[]" class="" value="<?php echo $page['id'];?>"></td>
			<td><?php echo $page['nav_order'];?></td>
			<td>
				<a href="<?php echo $this->strAdminSlug;?>edit/<?php echo $page['id'];?>/"><?php echo $page['title'];?></a>
				<?php echo $this->getPageControls($page['id'], $page['slug'], $page['status'],$page['blnLockSlug'], false); ?>
			</td>
			<td><?php echo $page['cat_name'];?></td>
			<td><?php echo $page['status'];?></td>
			<td><?php echo $page['date_created'];?></td>
			<td><?php echo $page['date_modified'];?></td>
			<td>
				<div class="progress">
                    <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $page['score_seo']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $page['score_seo']; ?>%;">
                        <?php echo $page['score_seo']; ?>%
                    </div>
                </div>
			</td>
		</tr>
		<?php
	}
}