	<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/


if(count($this->arrPages) == 0) {
	echo '<tr><td colspan="'.count($this->arrTableSQLArray).'" class="no-results">No results</td></tr>';
} else {
	foreach($this->arrPages As $page) {
		$strStatusColor = '#000000';

		if(!empty($page['status_color'])){
			$strStatusColor = $page['status_color'];
		}

		?>
		<tr>
			<td><input type="checkbox" name="pageID[]" value="<?php echo $page['id'];?>"></td>
			<td>
				<a href="<?php echo $this->strAdminSlug; ?>edit/<?php echo $page['id'];?>/?sub=true<?php echo $this->strOptions;?>"><?php echo $page['group_name'];?></a>
				<?php echo $this->getPageControls($page['id'], $this->strTableName, $page['status'], false); ?>
			</td>
			<td><?php echo $page['user_name'];?></td>
			<td><a href="mailto:<?php echo $page['user_email'];?>"><?php echo $page['user_email'];?></a></td>
			<td><?php echo $page['golfer_num'];?></td>
            <td><?php echo $page['golfer_unpaid'];?></td>
            <td><?php echo Util::formatPrice($page['package_total']);?></td>
			<td><?php echo Util::formatPrice($page['package_paid']);?></td>
			<td><?php echo $page['business_name'];?></td>
			<td><?php echo $page['booking_name'];?></td>
			<td><?php echo $page['dates_booking'];?></td>
			<td><?php echo $page['check_in_date'];?></td>
			<td style="color: <?php echo $strStatusColor; ?>"><?php echo $page['status_name']; ?></td>
		</tr>
		<?php
	}
}
