<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/


if(count($this->arrPages) == 0) {
	echo '<tr><td colspan="'.count($this->arrTableSQLArray).'" class="no-results">No results</td></tr>';
} else {
	foreach($this->arrPages As $page) {
		?>
		<tr>
			<td><input type="checkbox" name="pageID[]" class="" value="<?php echo $page['id'];?>"></td>
			<td><?php Util::displayThumb($page['file_name']); ?></td>
			<td>
				<a href="<?php echo $this->strAdminSlug; ?>edit/<?php echo $page['id'];?>/?sub=true<?php echo $this->strOptions;?>"><?php echo $page['title'];?></a>
				<?php echo $this->getPageControls($page['id'], $this->strTableName, $page['status'], false); ?>
			</td>
			<td><a href="<?php echo $this->strAdminSlug; ?>edit/<?php echo $page['id'];?>/?sub=true<?php echo $this->strOptions;?>"><?php echo $page['start_date'];?></a></td>
			<td><a href="<?php echo $this->strAdminSlug; ?>edit/<?php echo $page['id'];?>/?sub=true<?php echo $this->strOptions;?>"><?php echo $page['end_date'];?></a></td>

			<td><a href="<?php echo $this->strAdminSlug; ?>edit/<?php echo $page['id'];?>/?sub=true<?php echo $this->strOptions;?>"><?php echo '$' . number_format($page['price'], 2);?></a></td>
			<td><a href="<?php echo $this->strAdminSlug; ?>edit/<?php echo $page['id'];?>/?sub=true<?php echo $this->strOptions;?>"><?php switch($page['priority']) {case 0: echo 'Low'; break; case 1: echo 'Med'; break;case 2: echo 'High'; break;}?></a></td>

			<td><?php echo $page['hits'];?></td>
			<td>
				<div class="progress">
                    <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $page['score_seo']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $page['score_seo']; ?>%;">
                        <?php echo $page['score_seo']; ?>%
                    </div>
                </div>
			</td>
		</tr>
		<?php
	}
}



//var_dump($this->arrStatus);