<div class="form-group">
    <label>Snippet Preview:</label>
    <div class="well seo-snippet">
        <p><a class="title" href="<?php echo ROOT_URL . '/' . $this->objModel->strSlug; ?>"><?php echo $this->objModel->strMetaTitle; ?></a></p>
        <p><a class="url" href="<?php echo ROOT_URL . '/' . $this->objModel->strSlug; ?>"><?php echo ROOT_URL . '/' . $this->objModel->strSlug; ?></a></p>
        <p class="desc"><?php echo $this->objModel->strMetaDescription; ?></p>
    </div>
</div>

<div class="form-group">
    <label for="focus_keyword">Focus Keyword:</label>
    <p><small class="text-muted">Pick the main keyword or keyphrase that this post/page is about.</small></p>
    <input type="text" name="focus_keyword" id="focus_keyword" class="form-control" placeholder="Focus Keyword" value="<?php echo $this->objModel->strFocusKeyword; ?>">
</div>

<div class="form-group meta-title">
    <label for="meta_title">Meta Title:</label>
    <p><small class="text-muted">The title is limited to 70 chars, you have <strong class="char-count"><?php echo 70 - strlen($this->objModel->strMetaTitle); ?></strong> chars left. Most search engines will truncate titles to 70 characters.</small></p>
    <input type="text" name="meta_title" id="meta_title" class="form-control" placeholder="Page Title" value="<?php echo $this->objModel->strMetaTitle; ?>">
</div>

<div class="form-group meta-keywords">
    <label for="meta_keywords">Meta Keywords:</label>
    <p><small class="text-muted">A comma separated list of keywords limited to 12 keywords or phrases, and should be included in your content.</small></p>
    <input type="text" name="meta_keywords" id="meta_keywords" class="form-control" value="<?php echo $this->objModel->strMetaKeywords; ?>">
</div>

<div class="form-group meta-description">
    <label for="meta_description">Meta Description:</label>
    <p><small class="text-muted">Description display in search engines is limited to 153 chars, <strong class="char-count">153</strong> chars left.</small></p>
    <textarea name="meta_description" id="meta_description" class="form-control" placeholder="..." rows="5"><?php echo $this->objModel->strMetaDescription; ?></textarea>
</div>

<div class="form-group">
    <label for="meta_robots">Meta Robots:</label>
    <p><small class="text-muted">Determines if the Google bots should index the page and follow the links found on it.</small></p>
    <select name="meta_robots" id="meta_robots" class="form-control">
        <option value="index,follow" <?php echo Util::isSelected('index,follow',$this->objModel->strMetaRobots); ?>>Index, Follow</option>
        <option value="noindex,nofollow" <?php echo Util::isSelected('noindex,nofollow',$this->objModel->strMetaRobots); ?>>No Index, No Follow</option>
        <option value="noindex,follow" <?php echo Util::isSelected('noindex,follow',$this->objModel->strMetaRobots); ?>>No Index, Follow</option>
    </select>
</div>