<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>
<style>
    
    #permission_table table thead tr, #permission_table table thead th, #permission_table table tbody td, #permission_table table tbody tr {
        border: 1px solid;
        border-spacing: 23px;
    }

</style>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <!-- ID for the posted record, used to switch the method from add to edit -->

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        
        // print_r($_REQUEST);
        
        // print_r($this->objModel->getModules);
        
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <div class="form-group">
                    <label for="user_alias">Alias:</label>
                    <input type="text" name="user_alias" id="user_alias" class="form-control" placeholder="Enter alias Here" value="<?php echo $this->objModel->user_alias; ?>">
                </div>
                
                <?php if($this->objModel->strAction == 'edit'){
                   ?>
                    <div class="form-group">
                        <label for="user_name">Username:</label>
                        <input type="text" class="form-control" disabled value="<?php echo $this->objModel->user_name; ?>">
                    </div>
                    <input type="hidden" name="user_name" id="user_name" value="<?php echo $this->objModel->user_name; ?>" />
                   <?php 
                }else{
                    ?>
                    <div class="form-group">
                        <label for="user_name">Username:</label>
                        <input type="text" name="user_name" id="user_name" class="form-control" placeholder="Enter User name Here" value="<?php echo $this->objModel->user_name; ?>">
                    </div>
                    <?php
                }?>
                
                <div class="form-group">
                    <label for="user_email">User Email:</label>
                    <input type="text" name="user_email" id="user_email" class="form-control"  placeholder="Enter User Email Here" value="<?php echo $this->objModel->user_email; ?>">
                </div>
                
                <div class="form-group">
                    <label for="is_admin">Assign Role:</label>
                    <select name="is_admin" id="is_admin" class="form-control">
                        <option value="true" <?= ($this->objModel->is_admin == 'true')?'selected':''; ?> >Super Admin</option>
                        <option value="false" <?= ($this->objModel->is_admin == 'false')?'selected':''; ?> >Custom Role</option>
                    </select>
                </div>
                <input type="hidden" name="id" id="id" value="<?php echo $this->objModel->intID; ?>" />
                
                
                <hr>

                <div class="form-group">
                    <label for="user_password">New Password:</label>
                    <input type="password" name="user_password" id="user_password" class="form-control" placeholder="Enter password Here" value="<?php echo $this->objModel->user_password; ?>">
                </div>
                
                <div class="form-group">
                    <label for="repassword">Repeat Password:</label>
                    <input type="password" name="repassword" id="repassword" class="form-control" placeholder="Enter Repeat Password Here" value="">
                </div>
                
                
                
                <div id="permission_table">
                    
                    <hr>
                    
                   <table style="width:100%;">
                        <thead>
                            <tr>
                                <th>Module Name</th>
                                <th style=" text-align: center; " >View All</th>
                                <th style=" text-align: center; " >Add</th>
                                <th style=" text-align: center; " >Edit</th>
                                <th style=" text-align: center; ">Delete</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($this->objModel->getModules as $module): ?>
                                <tr>
                                    <td><?= htmlspecialchars($module['module_description']) ?></td>
                                    <td style=" text-align: center; " >
                                        <input 
                                            type="checkbox" 
                                            name="permissions[<?= $module['moduleID'] ?>][can_view]" 
                                            value="1" 
                                            <?= $module['can_view'] ? 'checked' : '' ?>
                                        >
                                    </td>
                                    <td style=" text-align: center; ">
                                        <?php if($module['only_view'] == 'false'){ ?>
                                        <input 
                                            type="checkbox" 
                                            name="permissions[<?= $module['moduleID'] ?>][can_add]" 
                                            value="1" 
                                            <?= $module['can_add'] ? 'checked' : '' ?>
                                        >
                                        <?php } ?>
                                    </td>
                                    <td style=" text-align: center; " >
                                        <?php if($module['only_view'] == 'false'){ ?>
                                        <input 
                                            type="checkbox" 
                                            name="permissions[<?= $module['moduleID'] ?>][can_edit]" 
                                            value="1" 
                                            <?= $module['can_edit'] ? 'checked' : '' ?>
                                        >
                                        <?php } ?>
                                    </td>
                                    <td style=" text-align: center; " >
                                        <?php if($module['only_view'] == 'false'){ ?>
                                        <input 
                                            type="checkbox" 
                                            name="permissions[<?= $module['moduleID'] ?>][can_delete]" 
                                            value="1" 
                                            <?= $module['can_delete'] ? 'checked' : '' ?>
                                        >
                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table> 
                </div>
                

            </div>

            <div class="col-xs-12 col-md-3">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="status">Status:</label>
                            <select name="status" id="status" class="form-control">
                                <option value="Active" <?php echo Util::isSelected("Active",$this->objModel->strStatus); ?>>Active</option>
                                <?php 
                                    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
                                if($this->objModel->blnLockSlug != 1) { ?>
                                <option value="Trash" <?php echo Util::isSelected("Trash",$this->objModel->strStatus); ?>>Trash</option>
                                <?php } } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <strong>Created On:</strong>
                            <div><span class="fa fa-calendar"></span> <?php echo date("F j, Y @ g:i a",strtotime($this->objModel->strDateCreated)); ?></div>
                        </div>
                        <div class="form-group">
                            <strong>Last Modified:</strong>
                            <div><span class="fa fa-calendar"></span> <?php echo date("F j, Y @ g:i a",strtotime($this->objModel->strDateModified)); ?></div>
                        </div>

                        <hr>

                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php if($this->objModel->blnLockSlug != 1) { ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

            </div>

        </div>


    </form>

</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const isAdminSelect = document.getElementById('is_admin');
        const permissionTable = document.getElementById('permission_table');

        // Function to toggle permission table visibility
        function togglePermissionTable() {
            if (isAdminSelect.value === 'false') {
                permissionTable.style.display = 'block'; // Show table
            } else {
                permissionTable.style.display = 'none'; // Hide table
            }
        }

        // Initial visibility based on current value
        togglePermissionTable();

        // Attach event listener for changes
        isAdminSelect.addEventListener('change', togglePermissionTable);
    });
</script>