<?php
/**
* The settings page template
*
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Settings</h1>

    <form role="form" id="settings-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs">
                    <li class="active"><a href="#general" data-toggle="tab">General</a></li>
                    <li><a href="#branding" data-toggle="tab">Branding</a></li>
                    <li><a href="#seo" data-toggle="tab">SEO</a></li>
                    <li><a href="#social-media" data-toggle="tab">Social Media</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="form-group">
                            <label for="site_name" class="control-label">Site Name:</label>
                            <p><small class="text-muted">Name of the website / application.</small></p>
                            <input type="text" name="site_name" id="site_name" class="form-control" value="<?php echo($this->objModel->strSiteName); ?>">
                        </div>

                        <div class="form-group">
                            <label for="site_description" class="control-label">Site Description:</label>
                            <p><small class="text-muted">Name of the website / application.</small></p>
                            <input type="text" name="site_description" id="site_description" class="form-control" value="<?php echo($this->objModel->strSiteDescription); ?>">
                        </div>

                        <div class="form-group">
                            <label for="admin_email" class="control-label">Admin Email:</label>
                            <p><small class="text-muted">Email notifications will be sent to this address.</small></p>
                            <input type="text" name="admin_email" id="admin_email" class="form-control" value="<?php echo($this->objModel->strAdminEmail); ?>">
                        </div>
                        <div class="form-group">
                            <label for="paypal_mode" class="control-label">Paypal Mode:</label>
                            <p><small class="text-muted">To test, set to sandbox.</small></p>
                            <select name="paypal_mode" id="paypal_mode" class="form-control">
                                <option value="0" <?php echo Util::isSelected(0, $this->objModel->intPayPalMode); ?>>Sandbox</option>
                                <option value="1" <?php echo Util::isSelected(1, $this->objModel->intPayPalMode); ?>>Live</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="voucher_force_break_amount" class="control-label">Voucher Break Amount:</label>
                            <p><small class="text-muted">Amount of vouchers to show before a page break is forced.</small></p>
                            <input type="number" name="voucher_force_break_amount" id="voucher_force_break_amount" class="form-control" value="<?php echo($this->objModel->intVoucherBreak); ?>">
                        </div>

                    </div>

                    <div class="tab-pane" id="branding">

                        <h3>Open Graph</h3>

                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="og_image">OG Image:</label>
                                    <p><small class="text-muted">The icon must be 500px by 500px and in .PNG format.</small></p>
                                    <input type="file" name="og_image" id="og_image" class="form-control" >
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <?php
                                if (is_file(ROOT_DIR.$this->objModel->strOGImage)) {
                                    echo '<label>Current Image:</label>';
                                    echo '<div class="well well-sm">';
                                    Util::displayThumb($this->objModel->strOGImage);
                                    echo '</div>';
                                }
                                ?>
                            </div>
                        </div>

                        <hr>

                        <h3>Apple Touch Icons</h3>

                        <?php
                        $arrAppleImageSizes = array(
                            152 => 'iOS 7 iPad (retina)',
                            144 => 'iOS 6 iPad (retina)',
                            114 => 'iOS 7 iphone (retina)',
                            76 => 'iOS 7 iPad',
                            72 => 'iOS 6 iPad',
                            57 => 'iOS 6 iPhone',
                        );

                        // Loop Through each Size and make our fields
                        foreach ($arrAppleImageSizes as $size => $name) {
                            $strFieldName = 'apple_image_'.$size;
                            $strObjName = 'strAppleImage'.$size;
                            ?>
                            <div class="row">
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="<?php echo $strFieldName; ?>"><?php echo $name; ?>:</label>
                                        <p><small class="text-muted"><?php echo 'The icon must be '.$size.'px by '.$size.'px and in .PNG format.'; ?></small></p>
                                        <input type="file" name="<?php echo $strFieldName; ?>" id="<?php echo $strFieldName; ?>" class="form-control" >
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6">
                                    <?php
                                    if (is_file(ROOT_DIR.$this->objModel->{$strObjName})) {
                                        echo '<label>Current Image:</label>';
                                        echo '<div class="well well-sm">';
                                        Util::displayThumb($this->objModel->{$strObjName});
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                            </div>
                            <?php
                        }
                        ?>

                    </div>

                    <div class="tab-pane" id="seo">

                        <h3>Tracking Codes</h3>

                        <div class="form-group">
                            <label for="google_analytics">Google Analytics:</label>
                            <p><small class="text-muted">Insert your Google Analytics tracking code too track your visitors. <a href="http://www.google.ca/analytics/" target="_blank">Learn more about Google Analytics</a></small></p>
                            <textarea name="google_analytics" id="google_analytics" class="form-control" rows="10"><?php echo $this->objModel->strGoogleAnalytics; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="header_tracking_code">Header Tracking Code:</label>
                            <p><small class="text-muted">This is where you can add in tracking code that requires that it is placed before the body tag.</small></p>
                            <textarea name="header_tracking_code" id="header_tracking_code" class="form-control" rows="10"><?php echo $this->objModel->strHeaderTrackingCode; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="footer_tracking_code">Footer Tracking Code:</label>
                            <p><small class="text-muted">This is where you can add in tracking code that requires that it is placed in the footer.</small></p>
                            <textarea name="footer_tracking_code" id="footer_tracking_code" class="form-control" rows="10"><?php echo $this->objModel->strFooterTrackingCode; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="facebook_insights">Facebook Insights:</label>
                            <p><small class="text-muted">
                                Facebook Insights provides you with metrics (likes, shares, referals) for you content. To view or set up Facebook Insights <a href="https://www.facebook.com/insights/" target="_blank">Click Here.</a>
                                <br>Copy and Paste the full meta tag. eg: &lt;meta property="fb:admins" content="100000157232652" /&gt;
                            </small></p>
                            <input type="text" name="facebook_insights" id="facebook_insights" class="form-control" value="<?php echo Util::cleanForHtml($this->objModel->strFacebookInsights, false) ?>">
                        </div>

                        <hr>

                        <h3>Webmaster Tools</h3>

                        <div class="form-group">
                            <label for="google_webmaster" class="control-label">Google Webmaster Tools:</label>
                            <p><small class="text-muted">
                                Google Webmaster Tools is a free program that will help the average user understand how Google sees the website, if there are any problems, and if the site is penalized. <a href="https://www.google.com/webmasters/tools/home?hl=en">Sign Up For Google Webmaster Tools</a>
                                <br>Copy and Paste the full meta tag. eg: &lt;meta name="google-site-verification" content="d_i5sTMm8lsMi-eQdQCKYQ8o-Af5PWq_F6o7q6Ny7ZU" /&gt;
                            </small></p>
                            <input type="text" name="google_webmaster" id="google_webmaster" class="form-control" value="<?php echo Util::cleanForHtml($this->objModel->strGoogleWebmaster, false); ?>">
                        </div>

                        <div class="form-group">
                            <label for="bing_webmaster" class="control-label">Bing Webmaster Tools:</label>
                            <p><small class="text-muted">
                                Bing Webmaster Tools helps improve your websites performance in search. Get access to free reports, tools and resources. <a href="http://www.bing.com/toolbox/webmaster/" target="_blank">Sign Up For Bing Webmaster Tools</a>
                                <br>Copy and Paste the full meta tag. eg: &lt;meta name="msvalidate.01" content="DC5158385B9821CCA66661E3D3B7130B" /&gt;
                            </small></p>
                            <input type="text" name="bing_webmaster" id="bing_webmaster" class="form-control" value="<?php echo Util::cleanForHtml($this->objModel->strBingWebmaster, false); ?>">
                        </div>

                        <div class="form-group">
                            <label for="alexa_verification_id" class="control-label">Alexa Verification ID:</label>
                            <p><small class="text-muted">
                                Verify ownership AND get more accurate Alexa Rank with Alexa Certified Site Metrics. <a href="http://www.alexa.com/pro/subscription" target="_blank">Get Your Alexa Verification ID</a>
                                <br>Copy and Paste the full meta tag. eg: &lt;meta name="alexaVerifyID" content="ahsgs_kjagsmhgdsjgsdfh" /&gt;
                            </small></p>
                            <input type="text" name="alexa_verification_id" id="alexa_verification_id" class="form-control" value="<?php echo Util::cleanForHtml($this->objModel->strAlexaVerificationId, false); ?>">
                        </div>

                        <div class="form-group">
                            <label for="pinterest_verification" class="control-label">Pinterest Verification:</label>
                            <p><small class="text-muted">
                                Verifying your website tells people on Pinterest that you own, and gives access to your analytics <a href="https://help.pinterest.com/en/articles/verify-your-website" target="_blank">Get Your Pinterest Verification</a>
                                <br>Copy and Paste the full meta tag. eg: &lt;meta name="p:domain_verify" content="ea29c2c8f524b325b30fc7b98c23be8f"/&gt;
                            </small></p>
                            <input type="text" name="pinterest_verification" id="pinterest_verification" class="form-control" value="<?php echo Util::cleanForHtml($this->objModel->strPinterestVerification, false); ?>">
                        </div>

                        <hr>

                        <h3>Robots TXT Options</h3>

                        <div class="checkbox">
                            <label for="robots_noodp"><input type="checkbox" name="robots_noodp" id="robots_noodp" value="1" <?php echo Util::isChecked($this->objModel->strRobotsNoodp, '1'); ?>>Add noodp Meta Robots Tag Sitewide:</label>
                            <p><small class="text-muted">Prevents search engines from using the DMOZ description for pages from this site in the search results.</small></p>
                        </div>

                        <div class="checkbox">
                            <label for="robots_noydir"><input type="checkbox" name="robots_noydir" id="robots_noydir" value="1" <?php echo Util::isChecked($this->objModel->strRobotsNoydir, '1'); ?>>Add noodp Meta Robots Tag Sitewide:</label>
                            <p><small class="text-muted">Prevents search engines from using the DMOZ description for pages from this site in the search results.</small></p>
                        </div>

                        <div class="form-group">
                            <label for="robots" class="control-label">Edit Robots.txt:</label>
                            <textarea name="robots" id="robots" class="form-control" rows="10"><?php echo $this->objModel->strRobots; ?></textarea>
                        </div>

                    </div>


                    <div class="tab-pane" id="social-media">

                        <div class="form-group">
                            <label for="facebook_url" class="control-label">Facebook URL:</label>
                            <p class="text-muted"><small>Link to your facebook account.</small></p>
                            <input type="text" name="facebook_url" id="facebook_url" class="form-control" value="<?php echo($this->objModel->strFacebookURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="twitter_url" class="control-label">Twitter URL:</label>
                            <p class="text-muted"><small>Link to your Twitter account.</small></p>
                            <input type="text" name="twitter_url" id="twitter_url" class="form-control" value="<?php echo($this->objModel->strTwitterURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="twitter_name" class="control-label">Twitter Name:</label>
                            <p class="text-muted"><small>Name of your twitter account.</small></p>
                            <input type="text" name="twitter_name" id="twitter_name" class="form-control" placeholder="@twitterName" value="<?php echo($this->objModel->strTwitterName); ?>">
                        </div>

                        <div class="form-group">
                            <label for="pintrest_url" class="control-label">Pinterest URL:</label>
                            <p class="text-muted"><small>Link to your Pinterest account.</small></p>
                            <input type="text" name="pintrest_url" id="pintrest_url" class="form-control" value="<?php echo($this->objModel->strPintrestURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="linkedin_url" class="control-label">Linkedin URL:</label>
                            <p class="text-muted"><small>Link to your Linkedin account.</small></p>
                            <input type="text" name="linkedin_url" id="linkedin_url" class="form-control" value="<?php echo($this->objModel->strLinkedinURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="google_url" class="control-label">Google Plus URL:</label>
                            <p class="text-muted"><small>Link to your Google Plus account.</small></p>
                            <input type="text" name="google_url" id="google_url" class="form-control" value="<?php echo($this->objModel->strGoogleURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="youtube_url" class="control-label">Youtube URL:</label>
                            <p class="text-muted"><small>Link to your Youtube account.</small></p>
                            <input type="text" name="youtube_url" id="youtube_url" class="form-control" value="<?php echo($this->objModel->strYoutubeURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="instagram_url" class="control-label">Instagram URL:</label>
                            <p class="text-muted"><small>Link to your Instagram account.</small></p>
                            <input type="text" name="instagram_url" id="instagram_url" class="form-control" value="<?php echo($this->objModel->strInstagramURL); ?>">
                        </div>

                        <div class="form-group">
                            <label for="rss_url" class="control-label">RSS URL:</label>
                            <p class="text-muted"><small>Link to your RSS Feed.</small></p>
                            <input type="text" name="rss_url" id="rss_url" class="form-control" value="<?php echo($this->objModel->strRSSURL); ?>">
                        </div>

                    </div>

                </div>

            </div>

            <div class="col-xs-12 col-md-3">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='/admin/dashboard/';"></div>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

            </div>


        </div>

    </form>

</div>