<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">Main Info</a></li>
                    <li class="courses"><a href="#courses" data-toggle="tab">Courses</a></li>
                    <li class="hotels"><a href="#hotels" data-toggle="tab">Hotels</a></li>
                    <li class="photos"><a href="#photos" data-toggle="tab">Slideshow</a></li>
                    <li class="seo-options"><a href="#seo-options" data-toggle="tab">SEO Options</a></li>
                    <li class="seo-analysis"><a href="#seo-analysis" data-toggle="tab">SEO Analysis</a></li>
                    <li class="social-media"><a href="#social-media" data-toggle="tab">Social Media</a></li>
                    <li class="you-tube"><a href="#you-tube" data-toggle="tab">YouTube Embed</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="form-group">
                            <label for="region_name" class="sr-only">Region Name:</label>
                            <input type="text" name="region_name" id="region_name" class="form-control input-lg" placeholder="Enter Title Here" value="<?php echo $this->objModel->strRegionName; ?>">
                        </div>

                        <div class="slug-field form-horizontal">
                            <div class="form-group">

                                <div class="col-sm-10">
                                    <label for="slug" class="sr-only">Slug URL:</label>
                                    <input type="text" name="slug" id="slug" class="form-control input-sm" placeholder="/regions/enter-title-here" value="<?php echo $this->objModel->strSlug; ?>">
                                </div>
                                <div class="col-sm-2">
                                    <div class="btn-group btn-group-justified">
                                        <a href="<?php echo $this->objModel->strSlug; ?>" class="btn btn-secondary btn-sm" target="_blank">View</a>
                                        <!-- <a href="" class="btn btn-secondary btn-sm">Get Shortlink</a> -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="form-group">
                            <label for="region_subtext">Sub Text:</label>
                            <input type="text" name="region_subtext" id="region_subtext" class="form-control" placeholder="Enter Text Here" value="<?php echo $this->objModel->strRegionSubText; ?>">
                        </div>

                        <div class="form-group">
                            <label for="display_order">Navigation Display Order:</label>
                            <p><small class="text-muted">Use "0" to hide from navigation</small></p>
                            <input type="text" name="display_order" id="display_order" class="form-control" placeholder="Enter Display Order Here" value="<?php echo $this->objModel->intDisplayOrder; ?>">
                        </div>

                        <hr>

                        <h3>Address</h3>

                        <div class="form-group">
                            <label for="state_id">Country:</label>
                            <select name="country_id" id="country_id" class="form-control">
                                <option value="">Please Choose</option>
                                <?php
                                foreach($this->arrCountrys AS $country) {
                                    echo '<option value="'.$country['id'].'" '.Util::isSelected($country['id'], $this->objModel->intCountryId) .'>'.$country['country_name'].'</option>';
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="state">State:</label>
                            <select name="state_id" id="state_id" class="form-control">
                            <?php foreach($this->arrStates As $s){

                                echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intStateId).'>'.$s['state_name'].'</option>';
                            }
                            ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="latitude">Latitude:</label>
                            <input type="text" name="latitude" id="latitude" class="form-control" placeholder="Enter Title Here" value="<?php echo $this->objModel->strLatitude; ?>">
                        </div>

                        <div class="form-group">
                            <label for="longitude">Longitude:</label>
                            <input type="text" name="longitude" id="longitude" class="form-control" placeholder="Enter Title Here" value="<?php echo $this->objModel->strLongitude; ?>">
                        </div>

                        <div class="form-group">
                            <label for="zlevel">Zoom (zoom function no longer accurate):</label>
                            <select name="zlevel" id="zlevel" class="form-control">
                                <option value="">Please Choose</option>
                                <?php
                                for($i = 1; $i <= 16; $i++) {
                                    echo '<option value="'.$i.'" '.Util::isSelected($i, $this->objModel->strZlevel) .'>'.$i.'</option>';
                                }
                                ?>
                            </select>
                        </div>

                        <hr />

                        <h3>Page Content</h3>
                        <div class="form-group">
                            <label for="text1">Text 1  - [read_more] will hide the rest of the content by default.</label>
                            <textarea name="text1" id="text1" class="form-control" rows="15"><?php echo $this->objModel->strText1; ?></textarea>
                            <script type="text/javascript">loadRTE('text1','regions');</script>
                        </div>

                        <div class="form-group">
                            <label for="region_subtext2">Sub Title 2:</label>
                            <input type="text" name="region_subtext2" id="region_subtext2" class="form-control" placeholder="Enter Text Here" value="<?php echo $this->objModel->strRegionSubText2; ?>">
                        </div>

                        <div class="form-group">
                            <label for="text2">Text 2</label>
                            <textarea name="text2" id="text2" class="form-control" rows="15"><?php echo $this->objModel->strText2; ?></textarea>
                            <script type="text/javascript">loadRTE('text2','regions');</script>
                        </div>


                        <div class="form-group">
                            <label for="text3">Advertisement Text</label>
                            <textarea name="text3" id="text3" class="form-control" rows="15"><?php echo $this->objModel->strText3; ?></textarea>
                            <script type="text/javascript">loadRTE('text3','regions');</script>
                        </div>
                    </div>


                    <div class="tab-pane grid-view" id="courses">
                        <div class="table-responsive">

                            <?php if($this->strAction =='add') { ?>

                                <div class="alert alert-warning">Please save the region record, then add courses to the region.</div>

                            <?php } else { ?>

                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);"></th>
                                        <th>Course Name</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($this->arrCourses as $key => $c) { ?>
                                    <tr>
                                        <td><input type="checkbox" id="<?php echo 'course_'.$key ?>" class="course_region_checkbox" name="course_id[]"  value="<?php echo $c['id']; ?>" <?php echo Util::isChecked($this->objModel->arrSelectedCourses,$c['id']); ?> /></td>
                                        <td><label for="<?php echo 'course_'.$key ?>"><?php echo $c['course_name']; ?></label></td>
                                    </tr>
                                    <?php  } ?>
                                </tbody>
                            </table>

                            <?php } ?>

                        </div>
                    </div>

                    <div class="tab-pane grid-view" id="hotels">
                        <div class="table-responsive">
                            <?php if($this->strAction =='add') { ?>

                                <div class="alert alert-warning">Please save the region record, then add hotels to the region.</div>

                            <?php } else { ?>

                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);"></th>
                                            <th>Hotel Name</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($this->arrHotels as $key => $h) { ?>
                                        <tr>
                                            <td><input type="checkbox" id="<?php echo 'hotel_'.$key; ?>" class="hotel_region_checkbox" name="hotel_id[]" value="<?php echo $h['id']; ?>" <?php echo Util::isChecked($this->objModel->arrSelectedHotels,$h['id']); ?> /></td>
                                            <td><label for="<?php echo 'hotel_'.$key; ?>"><?php echo $h['hotel_name']; ?></label></td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>

                            <?php } ?>

                        </div>
                    </div>

                    <div class="tab-pane" id="photos">
                        <div class="col-xs-12 col-md-12">
                            <?php include(ROOT_DIR.'/application/views/admin/include/_list_region_imgs.php'); ?>
                        </div>
                    </div>

                    <div class="tab-pane" id="you-tube">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_youtube.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-options">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-analysis">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_analysis.php'); ?>
                    </div>

                    <div class="tab-pane" id="social-media">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_social_media_form.php'); ?>
                    </div>

                </div>

            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">

                        <?php if (!empty($this->objModel->arrScore)) { ?>
                        <div class="form-group">
                            <strong>SEO Score:</strong>
                            <input type="hidden" name="score_seo" value="<?php echo $this->objModel->arrScore['score']; ?>">
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $this->objModel->arrScore['score']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $this->objModel->arrScore['score']; ?>%;">
                                    <?php echo $this->objModel->arrScore['score']; ?>%
                                </div>
                            </div>
                         </div>
                        <?php } ?>

                        <hr>

                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <input type="hidden" name="region_id" id="region_id" value="<?php echo $this->intID; ?>" />
    </form>

</div>
<?php if($this->tab != '') { ?>
<script type="text/javascript">
    $('#myTab li').removeClass('active');
    $('.tab-pane').removeClass('active');
    $('#<?php echo $this->tab;?>').addClass('active');
    //
    $('#myTab li.<?php echo $this->tab;?>').addClass('active');
</script>
<?php }


//var_dump($this);

?>
<?php


//var_dump($this->page);


?>