<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="?sub=true<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
            echo "<script>location.href='" . $this->strAdminSlug . "/?tab=booking';</script>";
        }
        ?>

        <div class="row">

            <div class="col-xs-12">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="col-xs-12 col-md-9">

                            <div class="row">
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="hotel_id">Hotel:</label>
                                        <?php
                                        $hotelID = $this->objModel->intHotelId;
                                        $this->getHotelDDL($hotelID);
                                        ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="default">Default For Quote:</label>
                                        <select name="default" class="form-control">
                                            <option value="1" <?php echo Util::isSelected($this->objModel->blnDefault,"1"); ?>>Yes</option>
                                            <option value="0" <?php echo Util::isSelected($this->objModel->blnDefault,"0"); ?>>No</option>
                                        </select>

                                    </div>

                                    <div class="form-group">
                                        <label for="check_in_date">Check In:</label>
                                        <input type="text" name="check_in_date" id="check_in_date" class="form-control datepicker" value="<?php echo $this->objModel->strCheckInDate; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="check_out_date">Check Out:</label>
                                        <input type="text" name="check_out_date" id="check_out_date" class="form-control datepicker" value="<?php echo $this->objModel->strCheckOutDate; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="nights">Nights:</label>
                                        <input type="text" name="nights" id="nights" class="form-control" placeholder="Enter nights Here" value="<?php echo $this->objModel->strNights; ?>">
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="rooms">Rooms:</label>
                                        <input type="text" name="rooms" id="rooms" class="form-control" placeholder="Enter rooms Here" value="<?php echo $this->objModel->strRooms; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="golfers">People:</label> *note:to add people, increase the number of golfers here
                                        <input type="text" name="golfers" id="golfers" class="form-control" placeholder="Enter golfers Here" value="<?php echo $this->objModel->strGolfers; ?>" >
                                    </div>

                                    <div class="form-group">
                                        <label for="confirm_num">Confirmation Number:</label>
                                        <input type="text" name="confirm_num" id="confirm_num" class="form-control" placeholder="Enter confirm_num Here" value="<?php echo $this->objModel->strConfirmNum; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="guests_name">Room Style:</label>
                                        <textarea name="guests_name" id="guests_name" class="form-control"  rows="5"><?php echo $this->objModel->strGuestsName; ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="room_notes">Private Notes:</label>
                                <textarea rows="5" name="room_notes" id="room_notes" class="form-control" cols="30"><?php echo $this->objModel->strRoomNotes; ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="public_notes">Public Notes:</label>
                                <textarea rows="5" name="public_notes" id="public_notes" class="form-control" cols="30"><?php echo $this->objModel->strPublicNotes; ?></textarea>
                            </div>

                        </div>


                        <div class="col-xs-12 col-md-3">

                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Save Options</h3>
                                </div>
                                <div class="panel-body">
                                    <div class="btn-group btn-group-justified">
                                        <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.'?sub=true'.$this->strOptions; ?>';"></div>
                                        <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                                        <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                                        <?php } ?>
                                        <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                                    </div>
                                </div>
                            </div>


                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Instructions</h3>
                                </div>
                                <div class="panel-body">
                                    <p>When adding a new hotel to the quote, specify the number of golfers along with the other information and click save.
                                        Each quote must have one default hotel, which along with a completed golf course record enables the mini page.</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-xs-12">
                            <?php
                           // if($this->objModel->blnDefault > 0){

                                if($this->objModel->strGolfers > 0){ ?>


                                <hr />

                                <div class="table-responsive grid-view">


                                    <h3>Hotel Rooming List</h3>

                                    <div class="well">Note: to remove a player, erase the first name from the list and click save. Do not adjust the number of golfers, it will do so automatically.</div>


                                    <table class="table-paid table table-bordered table-hover table-condensed">
                                        <thead>
                                            <tr>
                                                <th># People</th>
                                                <th>First Name</th>
                                                <th>Last Name</th>
                                                <th>Email Address</th>
                                                <th>Admin Notes</th>
                                                <th>Room #</th>
                                                <th># Nights</th>
                                                <th>Package price</th>
                                                <th>Paid $</th>
                                                <th>Balance $</th>
                                                <th>Balance Paid</th>
                                                <th>Payment Notes</th>
                                                <th>MemberID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $i = 0;
                                            $package_total = 0;
                                            $deposit_total = 0;
                                            $final_total = 0;
                                            $lpn = 0;
                                            for($x = 1;$x<=$this->objModel->strGolfers;$x++) {
                                                $member_id = isset($this->arrDetails[$i]['member_id']) ? $this->arrDetails[$i]['member_id'] : '';
                                                $people_num = isset($this->arrDetails[$i]['people_num']) ? $this->arrDetails[$i]['people_num'] : $lpn+1;
                                                $lpn = $people_num;
                                                $people_name = isset($this->arrDetails[$i]['people_name']) && $this->arrDetails[$i]['people_name'] != '' ? $this->arrDetails[$i]['people_name'] : 'Player';
                                                $people_lname = isset($this->arrDetails[$i]['people_lname']) ? $this->arrDetails[$i]['people_lname'] : $x;
                                                $people_email = isset($this->arrDetails[$i]['people_email']) ? $this->arrDetails[$i]['people_email'] : '';
                                                $people_phone = isset($this->arrDetails[$i]['people_phone']) ? $this->arrDetails[$i]['people_phone'] : '';
                                                $room_num = isset($this->arrDetails[$i]['room_num']) ? $this->arrDetails[$i]['room_num'] : '';
                                                $nights_num = isset($this->arrDetails[$i]['nights_num']) ? $this->arrDetails[$i]['nights_num'] : '';
                                                $package_price = isset($this->arrDetails[$i]['package_price']) ? $this->arrDetails[$i]['package_price'] : 0;
                                                $deposit_price = isset($this->arrDetails[$i]['deposit_price']) ? $this->arrDetails[$i]['deposit_price'] : 0;
                                                $cc_processed = isset($this->arrDetails[$i]['cc_processed']) ? $this->arrDetails[$i]['cc_processed'] : '';
                                                $notes = isset($this->arrDetails[$i]['notes']) ? $this->arrDetails[$i]['notes'] : '';

                                                $package_total += $package_price;
                                                $deposit_total += $deposit_price;
                                                $balance = intval($package_price) - intval($deposit_price);
                                                $final_total += $balance;

                                                ?>
                                            <tr>
                                                <td><input name="people_num[]" size="2" value="<?php echo $people_num; ?>" readonly="" class="input-sm form-control"></td>
                                                <td><input name="people_name[]" id="people_name_<?php echo $people_num; ?>" size="10" value="<?php echo $people_name; ?>" class="input-sm form-control"></td>
                                                <td><input name="people_lname[]" id="people_lname_<?php echo $people_num; ?>" size="10" value="<?php echo $people_lname; ?>" class="input-sm form-control"></td>
                                                <td><input name="people_email[]" id="people_email_<?php echo $people_num; ?>" size="15" value="<?php echo $people_email; ?>" class="input-sm form-control"></td>
                                                <td><input name="people_phone[]" id="people_phone_<?php echo $people_num; ?>" size="8" value="<?php echo $people_phone; ?>" class="input-sm form-control"></td>
                                                <td><input name="room_num[]" id="room_num_<?php echo $people_num; ?>" size="2" value="<?php echo $room_num; ?>" class="input-sm form-control"></td>
                                                <td><input name="nights_num[]" id="nights_num_<?php echo $people_num; ?>" size="2" value="<?php echo $nights_num; ?>" class="input-sm form-control"></td>
                                                <td><input name="package_price[]" id="package_price_<?php echo $people_num; ?>" size="2" value="<?php echo $package_price; ?>"  class="input-sm form-control"></td>
                                                <td><input name="deposit_price[]" id="deposit_price_<?php echo $people_num; ?>" size="5" value="<?php echo $deposit_price; ?>"  class="input-sm form-control"></td>
                                                <td>$<?php echo $balance; ?></td>
                                                <td><input name="cc_processed[]" id="cc_processed_<?php echo $people_num; ?>" size="2" value="<?php echo $cc_processed; ?>" class="input-sm form-control"></td>
                                                <td><textarea name="notes[]" id="notes_<?php echo $people_num; ?>" cols="10" rows="2" class="input-sm form-control"><?php echo $notes; ?></textarea></td>
                                                <td><input name="member_id[]" id="member_id_<?php echo $people_num; ?>" size="2" value="<?php echo $member_id; ?>" class="input-sm form-control"></td>
                                            </tr>
                                            <?php
                                            $i++;
                                            } ?>
                                            <tr>
                                                <td colspan="7" class="right"><b>Total amount :</b></td>
                                                <td>$<?php echo $package_total; ?></td>
                                                <td>$<?php echo $deposit_total; ?></td>
                                                <td>$<?php echo $final_total; ?></td>
                                                <td colspan="3">&nbsp;</td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </div>
                                <?php
                                }

                                    //echo '<pre>';
                                    //var_dump($this->arrDetails);
                           // } ?>
                        </div>




                    </div>

                </div>

            </div>





        </div>
    </form>
    <input type="hidden" name="relhotelID" id="relhotelID" value="<?php echo $this->objModel->intRelHotelID; ?>" />
</div>


<?php //var_dump($this); ?>