<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="?sub=true<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="booking_people"><a href="#booking_people" data-toggle="tab">Agents</a></li>
                    <li class="hotel"><a href="#hotel" data-toggle="tab">Hotels</a></li>
                    <li class="course"><a href="#course" data-toggle="tab">Courses</a></li>
                    <li class="accounting"><a href="#accounting" data-toggle="tab">Accounting</a></li>
                    <?php if( $this->strAction == 'edit') { ?>
                    <li class="booking"><a href="#booking" data-toggle="tab">Booking Info</a></li>
                    <li class="preview"><a href="#preview" data-toggle="tab">Preview</a></li>
                    <li class="email"><a href="#email" data-toggle="tab">Email</a></li>
                    <!-- <li class="voucher"><a href="#voucher" data-toggle="tab">Voucher</a></li> -->
                    <?php } ?>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">
                        <?php include('quote/_general.php'); ?>
                    </div>

                    <div class="tab-pane" id="booking_people">
                        <?php include('quote/_booking_people.php'); ?>
                    </div>

                    <div class="tab-pane" id="hotel">
                        <?php include('quote/_hotel.php'); ?>
                    </div>

                    <div class="tab-pane" id="course">
                        <?php include('quote/_course.php'); ?>
                    </div>

                    <div class="tab-pane" id="booking">
                        <?php include('quote/_booking.php'); ?>
                    </div>

                    <div class="tab-pane" id="preview">
                        <?php include('quote/_preview.php'); ?>
                    </div>

                    <div class="tab-pane" id="email">
                        <?php include('quote/_email.php'); ?>
                    </div>

                    <div class="tab-pane" id="accounting">
                        <?php include('quote/_accounting.php'); ?>
                    </div>


                    <?php if( $this->strAction == 'edit') { ?>

                    <!-- <div class="tab-pane" id="voucher">
                        <?php // include('quote/_voucher.php'); ?>
                    </div><!-- tab pane -->
                    <?php } ?>

                </div><!-- tab content -->

            </div><!-- col-xs-12 -->

        </div><!-- row -->

        <input type="hidden" id="quoteID" value="<?php echo $this->objModel->intId; ?>" />
        <input type="hidden" name="group_id" value="<?php echo $this->intGroupId; ?>" />

    </form>

</div>

<?php if($this->tab != '') { ?>
<script type="text/javascript">
    $('#myTab li').removeClass('active');
    $('.tab-pane').removeClass('active');
    $('#<?php echo $this->tab;?>').addClass('active');
    $('#myTab li.<?php echo $this->tab;?>').addClass('active');
</script>
<?php } ?>

<script type="text/javascript">
    $(document).ready(function(e) {
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
          var target = $(e.target).attr("href") // activated tab
          target + ' div.jHtmlArea iframe'
          $(target + ' div.jHtmlArea iframe').attr('style', 'width: 100px; height: 850px;');
        });
    });
</script>
