<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="?sub=true<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
            echo "<script>location.href='" . $this->strAdminSlug . "/?tab=booking';</script>";
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <div class="form-group">
                    <label for="status_name">Golf Course:</label>
                    <?php
                    $courseID = $this->objModel->intCourseId;
                    $this->getCourseDDL($courseID);
                    ?>
                </div>

                <div class="form-group">

                    <div class="col-sm-2">
                        <label>Tee Time:</label>
                    </div>

                    <div class="col-sm-2">
                        Date:<input type="text" name="tee_date" id="tee_date" class="form-control datepicker" value="<?php echo $this->objModel->strTeeDate; ?>">
                    </div>

                    <div class="col-sm-2">
                        Time:<input type="text" name="tee_time" id="tee_time" class="form-control" value="<?php echo $this->objModel->strTeeTime; ?>">

                    </div>
                    <div class="col-sm-2">
                        AM/PM:
                        <select name="tee_ap" id="tee_ap" class="form-control">
                            <option value="AM" <?php echo Util::isSelected('AM',$this->objModel->strTeeAMPM); ?>>AM</option>
                            <option value="PM" <?php echo Util::isSelected('PM',$this->objModel->strTeeAMPM); ?>>PM</option>
                        </select>
                    </div>

                </div>


                <br clear="all" />

                <div class="form-group">
                    <label for="carts">Carts Included:</label>
                    <input type="text" name="carts" id="carts" class="form-control" placeholder="Enter carts Here" value="<?php echo $this->objModel->strCarts; ?>">
                </div>

                <div class="form-group">
                    <label for="range_ball">Range Balls Included:</label>
                    <input type="text" name="range_ball" id="range_ball" class="form-control" placeholder="Enter range_ball Here" value="<?php echo $this->objModel->strRangeBall; ?>">
                </div>

                <div class="form-group">
                    <label for="shuttle">Shuttle Included:</label>
                    <input type="text" name="shuttle" id="shuttle" class="form-control" placeholder="Enter golf_on_arrival Here" value="<?php echo $this->objModel->strShuttle; ?>">
                </div>

                <div class="form-group">
                    <label for="golfer_num">Number Of Golfers:</label>
                    <input type="text" name="golfer_num" id="golfer_num" class="form-control" placeholder="Enter golfer_num Here" value="<?php echo $this->objModel->strGolferNum; ?>">
                </div>

                <div class="form-group">
                    <label for="confirm_num">Confirmation Number:</label>
                    <input type="text" name="confirm_num" id="confirm_num" class="form-control" placeholder="Enter confirm_num Here" value="<?php echo $this->objModel->strConfirmNum; ?>">
                </div>

                <div class="form-group">
                    <label for="notes">Private Notes:</label>
                    <textarea name="notes" id="notes" class="form-control" rows="5"><?php echo $this->objModel->strNotes; ?></textarea>
                </div>

                <div class="form-group">
                    <label for="public_notes">Public Notes:</label>
                    <textarea name="public_notes" id="public_notes" class="form-control" rows="5"><?php echo $this->objModel->strPublicNotes; ?></textarea>
                </div>

            </div>

            <div class="col-xs-12 col-md-3">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminQuoteSlug.'?sub=true'.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>


            </div>

        </div>
    </form>

</div>


<?php //var_dump($this); ?>