<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Profile</h1>

    <form method="POST" role="form" id="profile-form">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">
            <div class="col-xs-12 col-md-9">

            	<div class="form-group">
                    <label for="user_name" class="control-label">Your User Name:</label>
                    <p class="text-muted"><small>This is used when logging in</small></p>
                    <input type="text" name="user_name" id="user_name" class="form-control" value="<?php echo $this->objModel->strUserAlias; ?>" disabled>
                </div>

                <div class="form-group">
                    <label for="user_alias" class="control-label">Your Alias:</label>
                    <p class="text-muted"><small>This is used for front end display</small></p>
                    <input type="text" name="user_alias" id="user_alias" class="form-control" value="<?php echo $this->objModel->strUserAlias; ?>">
                </div>

                <div class="form-group">
                    <label for="user_email" class="control-label">Your Email:</label>
                    <input type="text" name="user_email" id="user_email" class="form-control" value="<?php echo $this->objModel->strUserEmail; ?>">
                </div>

                <hr>

                <div class="form-group">
                    <label for="new_password" class="control-label">New Password:</label>
                    <input type="password" name="new_password" id="new_password" class="form-control" value="">
                </div>

                <div class="form-group">
                    <label for="new_password2" class="control-label">Repeat New Password:</label>
                    <input type="password" name="new_password2" id="new_password2" class="form-control" value="">
                </div>

                <input type="hidden" name="user_password" value="<?php echo $this->objModel->strUserPassword; ?>">

            </div>

            <div class="col-xs-12 col-md-3">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="" id="" class="btn btn-secondary" value="Cancel" onclick="location.href='/admin/dashboard/';"></div>
                            <div class="btn-group"><input type="submit" name="submit" id="" class="btn btn-primary" value="Update"></div>
                        </div>
                    </div>
                </div>

            </div>

        </div>

    </form>

</div>