<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
           // echo '<script>setTimeout("location.href=\'/admin/region/edit/' . $this->objModel->intID. '/?tab=photos\'",1);</script>';
            echo '<script>location.href=\'/admin/page/edit/' . $this->objModel->intID. '/?tab=photos\';</script>';
        }
        ?>
        <div class="row">
            <div class="col-xs-12 col-md-9">

                <div class="form-group">
                    <label for="title">Title:</label>
                    <input type="text" name="title" id="title" class="form-control" placeholder="Enter Title Here" value="<?php echo $this->objModel->strImageName; ?>">
                </div>

                <div class="form-group">
                    <label for="alt">Alt Text:</label>
                    <input type="text" name="alt" id="alt" class="form-control" placeholder="Enter Alt Text Here" value="<?php echo $this->objModel->strAltText; ?>">
                </div>

                <div class="form-group">
                    <label for="url">Url:</label>
                    <input type="text" name="url" id="url" class="form-control" placeholder="Enter url Here" value="<?php echo $this->objModel->strUrl; ?>">
                </div>

                <div class="form-group">
                    <label for="display_order">Display Order:</label>
                    <input type="text" name="display_order" id="display_order" class="form-control" placeholder="Enter display order Here" value="<?php echo $this->objModel->strDisplayOrder; ?>">
                </div>

                <hr />

                <div class="row">

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label for="hero_title">Hero Title:</label>
                            <input type="text" name="hero_title" id="hero_title" class="form-control" placeholder="Enter Hero Title Here" value="<?php echo $this->objModel->strHeroTitle; ?>">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label for="hero_text">Hero Text:</label>
                            <input type="text" name="hero_text" id="hero_text" class="form-control" placeholder="Enter Hero Text Here" value="<?php echo $this->objModel->strHeroText; ?>">
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label for="blnPrimary">Primary Image:</label>
                            <select name="blnPrimary" id="blnPrimary" class="form-control">
                                <option value="0" <?php echo Util::isSelected('0', $this->objModel->blnPrimary); ?>>No</option>
                                <option value="1" <?php echo Util::isSelected('1', $this->objModel->blnPrimary); ?>>Yes</option>
                            </select>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ if($this->strAction != 'add') { ?>
                            <div class="btn-group"><input type="button" name="trash" id="trash" class="btn btn-secondary" value="Delete" onclick="confirmDelete('/admin/page/<?php echo $this->intID; ?>/images/delete/<?php echo $this->imgID; ?>/');"></div>
                            <?php } } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Featured Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                        <label for="file_name" class="sr-only">File Name:</label>
                        <input type="file" name="file_name" id="file_name" class="form-control" >
                    </div>

                    <?php if (!empty($this->objModel->strFileName)) { ?>
                    <div class="well well-sm"><?php Util::displayThumb($this->objModel->strFileName, 333, 150); ?></div>
                    <?php } ?>
                    </div>
                </div>
            </div>

        </div>
    </form>
</div>
