<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <!-- ID for the posted record, used to switch the method from add to edit -->
        <input type="hidden" value="<?php echo $this->page['id']; ?>" name="id" />

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="photos"><a href="#photos" data-toggle="tab">Slideshow</a></li>
                    <li class="seo-options"><a href="#seo-options" data-toggle="tab">SEO Options</a></li>
                    <li class="seo-analysis"><a href="#seo-analysis" data-toggle="tab">SEO Analysis</a></li>
                    <li class="social-media"><a href="#social-media" data-toggle="tab">Social Media</a></li>
                    <li class="you-tube"><a href="#you-tube" data-toggle="tab">YouTube Embed</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="form-group">
                            <label for="title" class="sr-only">Title:</label>
                            <input type="text" name="title" id="title" class="form-control input-lg" placeholder="Enter Title Here" value="<?php echo $this->objModel->strTitle; ?>">
                        </div>

                        <div class="slug-field form-horizontal">
                            <div class="form-group">
                                <div class="col-sm-10">
                                    <label for="slug" class="sr-only">Slug URL:</label>
                                    <input type="text" name="slug" id="slug" class="form-control input-sm" placeholder="enter-title-here" value="<?php echo $this->objModel->strSlug; ?>" <?php if($this->objModel->blnLockSlug == 1) { echo 'readonly="readonly"'; }  ?>  >
                                </div>
                                <div class="col-sm-2">
                                    <div class="btn-group btn-group-justified">
                                        <a href="/<?php echo $this->objModel->strSlug; ?>" class="btn btn-secondary btn-sm" target="_blank">View</a>
                                        <!-- <a href="" class="btn btn-secondary btn-sm">Get Shortlink</a> -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="form-group">
                            <label for="category">Section:</label>
                            <select name="category" id="category" class="form-control">
                                <option value="">None</option>
                                <?php foreach($this->objModel->arrCategories As $c){
                                    echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->objModel->intCategory).'>'.$c['cat_name'].'</option>';
                                } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="bln_show_featured">Show Featured Packages:</label>
                            <select name="bln_show_featured" id="bln_show_featured" class="form-control">
                                <option value="0" <?php echo Util::isSelected(0, $this->objModel->blnShowFeatured); ?>>No</option>
                                <option value="1" <?php echo Util::isSelected(1, $this->objModel->blnShowFeatured); ?>>Yes</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="nav_order">Nav Order:</label>
                            <p><small class="text-muted">Use "0" to hide from navigation</small></p>
                            <input type="text" name="nav_order" id="nav_order" class="form-control" placeholder="Enter nav_order Here" value="<?php echo $this->objModel->intNavOrder; ?>">
                        </div>

                        <div class="form-group">
                            <label for="content" class="">Content: [read_more] will hide the rest of the content by default.</label>
                            <textarea name="content" id="content" class="form-control" rows="15"><?php echo $this->objModel->strContent; ?></textarea>
                            <script type="text/javascript">loadRTE('content','pages');</script>
                        </div>

                    </div>

                    <div class="tab-pane" id="photos">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_list_page_imgs.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-options">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-analysis">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_analysis.php'); ?>
                    </div>

                    <div class="tab-pane" id="social-media">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_social_media_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="you-tube">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_youtube.php'); ?>
                    </div>

                </div>
                <!-- Tab panes -->


            </div>

            <div class="col-xs-12 col-md-3">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="status">Status:</label>
                            <select name="status" id="status" class="form-control">
                                <option value="Active" <?php echo Util::isSelected("Active",$this->objModel->strStatus); ?>>Active</option>
                                <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
                                        if($this->objModel->blnLockSlug != 1) { ?>
                                <option value="Trash" <?php echo Util::isSelected("Trash",$this->objModel->strStatus); ?>>Trash</option>
                                <?php } } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <strong>Created On:</strong>
                            <div><span class="fa fa-calendar"></span> <?php echo date("F j, Y @ g:i a",strtotime($this->objModel->strDateCreated)); ?></div>
                        </div>
                        <div class="form-group">
                            <strong>Last Modified:</strong>
                            <div><span class="fa fa-calendar"></span> <?php echo date("F j, Y @ g:i a",strtotime($this->objModel->strDateModified)); ?></div>
                        </div>

                        <?php if (!empty($this->objModel->arrScore)) { ?>
                        <div class="form-group">
                            <strong>SEO Score:</strong>
                            <input type="hidden" name="score_seo" value="<?php echo $this->objModel->arrScore['score']; ?>">
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $this->objModel->arrScore['score']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $this->objModel->arrScore['score']; ?>%;">
                                    <?php echo $this->objModel->arrScore['score']; ?>%
                                </div>
                            </div>
                         </div>
                        <?php } ?>

                        <hr>

                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
                                    if($this->objModel->blnLockSlug != 1) { ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Featured Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="display_image" class="sr-only">Display Image:</label>
                            <input type="file" name="display_image" id="display_image" class="form-control" >
                        </div>

                        <?php if (!empty($this->objModel->strDisplayImage)) { ?>
                        <div class="well well-sm"><?php Util::displayThumb($this->objModel->strDisplayImage, 333, 150); ?></div>
                        <div class="checkbox">
                            <label><input type="checkbox" name="files_to_delete[display_image]" id="files_to_delete" value="<?php echo $this->objModel->strDisplayImage; ?>"> Remove Image</label>
                        </div>
                        <?php } ?>
                    </div>
                </div>

            </div>

        </div>


    </form>

</div>
<?php if($this->tab != '') { ?>
<script type="text/javascript">
    $('#myTab li').removeClass('active');
    $('.tab-pane').removeClass('active');
    $('#<?php echo $this->tab;?>').addClass('active');
    //
    $('#myTab li.<?php echo $this->tab;?>').addClass('active');
</script>

<?php } ?>
