<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

//var_dump($this->objModel->arrRates);

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="?sub=true<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <div style="display:none;"><input id="default_action" name="submit" type="submit" value="Save" /></div>

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
            echo '<script>location.href=\'/admin/package/edit/'. $this->objModel->intID. '/?tab=booking\';</script>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="email"><a href="#email" data-toggle="tab">Email</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="col-xs-12 col-md-9">

                            <div class="row">
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="hotel_id">Hotel:</label>
                                        <?php
                                        $hotelID = $this->objModel->intHotelId;
                                        $this->getHotelDDL($hotelID);
                                        ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="default">Default For Package:</label>
                                        <select name="default" class="form-control">
                                            <option value="1" <?php echo Util::isSelected($this->objModel->blnDefault,"1"); ?>>Yes</option>
                                            <option value="0" <?php echo Util::isSelected($this->objModel->blnDefault,"0"); ?>>No</option>
                                        </select>

                                    </div>

                                    <div class="form-group">
                                        <label for="check_in_date">Check In:</label>
                                        <input type="text" name="check_in_date" id="check_in_date" class="form-control datepicker" value="<?php echo $this->objModel->strCheckInDate; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="check_out_date">Check Out:</label>
                                        <input type="text" name="check_out_date" id="check_out_date" class="form-control datepicker" value="<?php echo $this->objModel->strCheckOutDate; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="nights">Nights:</label>
                                        <input type="number" data-restrict-number="true" name="nights" id="nights" class="form-control" placeholder="Enter nights Here" value="<?php echo $this->objModel->strNights; ?>">
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="rooms">Rooms:</label>
                                        <input type="number" data-restrict-number="true" name="rooms" id="rooms" class="form-control" placeholder="Enter rooms Here" value="<?php echo $this->objModel->strRooms; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="golfers">People:</label> *note:to add people, increase the number of golfers here
                                        <input type="number" data-restrict-number="true" name="golfers" id="golfers" class="form-control" placeholder="Enter golfers Here" value="<?php echo $this->objModel->strGolfers; ?>" >
                                    </div>

                                    <div class="form-group">
                                        <label for="confirm_num">Confirmation Number:</label>
                                        <input type="text" name="confirm_num" id="confirm_num" class="form-control" placeholder="Enter confirm_num Here" value="<?php echo $this->objModel->strConfirmNum; ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="guests_name">Room Style:</label>
                                        <textarea name="guests_name" id="guests_name" class="form-control"  rows="5"><?php echo $this->objModel->strGuestsName; ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="room_notes">Private Notes:</label>
                                <textarea rows="5" name="room_notes" id="room_notes" class="form-control" cols="30"><?php echo $this->objModel->strRoomNotes; ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="public_notes">Public Notes:</label>
                                <textarea rows="5" name="public_notes" id="public_notes" class="form-control" cols="30"><?php echo $this->objModel->strPublicNotes; ?></textarea>
                            </div>

                        </div>


                        <div class="col-xs-12 col-md-3">

                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Save Options</h3>
                                </div>
                                <div class="panel-body">
                                    <div class="btn-group btn-group-justified">
                                        <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.'?sub=true'.$this->strOptions; ?>';"></div>
                                        <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                                        <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                                        <?php } ?>
                                        <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                                    </div>
                                </div>
                            </div>


                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Instructions</h3>
                                </div>
                                <div class="panel-body">
                                    <p>When adding a new hotel to the package, specify the number of golfers along with the other information and click save.
                                        Each package must have one default hotel, which along with a completed golf course record enables the mini page.</p>
                                </div>
                            </div>
                        </div>

                    <?php if (isset($this->objModel->intHotelId))  { ?>

                        <div class="col-xs-12">

                            <h3>Hotel Rates</h3>

                                <div class="well well-sm calculator-control-list js-rates-hotels">

                                    <?php
                                        //var_dump($this->objModel);
                                        global $arrRatesHotels, $arrRatesSelectedHotels;
                                        $arrRatesHotels = array();
                                        $args = array(
                                            'hotel_id' => $this->objModel->intHotelId,
                                            'package_id' => $this->objModel->intID,
                                            'check_in' => date('Y-01-01'),
                                            //'max_start_date' => $this->objModel->strCheckInDate,
                                            //'min_end_date' => $this->objModel->strCheckOutDate,
                                            'check_out' => date('Y-12-31'));



                                        if (isset($this->objModel->strCheckInDate) && ($this->objModel->strCheckInDate != '')) {
                                            $args['check_in'] = date($this->objModel->strCheckInDate);
                                        }

                                        if (isset($this->objModel->strCheckOutDate) && ($this->objModel->strCheckOutDate != '')) {
                                            $args['check_out'] = date($this->objModel->strCheckOutDate);
                                        }

                                        $arrRates = Rate::getHotelPackageRates($args);

                                        if (!empty($arrRates)) {
                                            // Add the rates
                                            $arrRatesHotels[$this->objModel->intHotelId] = $arrRates;
                                        }

                                        $arrSelectedRates = $this->objModel->getSelectedRates();
                                        $arrRatesSelectedHotels = array();

                                        foreach ($arrSelectedRates as $arrSelectedRate) {
                                            $arrRatesSelectedHotels[$arrSelectedRate['rate_id']]['rooms'] = $arrSelectedRate['rooms'];
                                            $arrRatesSelectedHotels[$arrSelectedRate['rate_id']]['nights'] = $arrSelectedRate['nights'];
                                        }

                                        include(ROOT_DIR . '/application/views/admin/rates/_hotel_rates.php');

                                    ?>

                                </div>

                        </div>

                    <?php } ?>

                        <div class="col-xs-12">
                            <?php
                           // if($this->objModel->blnDefault > 0){

                                if($this->objModel->strGolfers > 0){ ?>

                                <hr />

                                <div class="table-responsive grid-view">


                                    <h3>Hotel Rooming List</h3>

                                    <div class="well">Note: to remove a player, erase the first name from the list and click save. Do not adjust the number of golfers, it will do so automatically.</div>


                                    <table class="table-paid table table-bordered table-hover table-condensed">
                                        <thead>
                                            <tr>
                                                <th># People</th>
                                                <th>First Name</th>
                                                <th>Last Name</th>
                                                <th>Email Address</th>
                                                <th>Admin Notes</th>
                                                <th>Room #</th>
                                                <th>Room Res #</th>
                                                <th># Nights</th>
                                                <th>Package price</th>
                                                <th>Paid $</th>
                                                <th>Balance $</th>
                                                <th>Balance Paid</th>
                                                <th>Payment Notes</th>
                                                <th>MemberID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $i = 0;
                                            $package_total = 0;
                                            $deposit_total = 0;
                                            $final_total = 0;
                                            $lpn = 0;
                                            for($x = 1;$x<=$this->objModel->strGolfers;$x++) {
                                                $member_id = isset($this->arrDetails[$i]['member_id']) ? $this->arrDetails[$i]['member_id'] : '';
                                                $people_num = isset($this->arrDetails[$i]['people_num']) ? $this->arrDetails[$i]['people_num'] : $lpn+1;
                                                $lpn = $people_num;
                                                $people_name = isset($this->arrDetails[$i]['people_name']) && $this->arrDetails[$i]['people_name'] != '' ? $this->arrDetails[$i]['people_name'] : 'Player';
                                                $people_lname = isset($this->arrDetails[$i]['people_lname']) ? $this->arrDetails[$i]['people_lname'] : $x;
                                                $people_email = isset($this->arrDetails[$i]['people_email']) ? $this->arrDetails[$i]['people_email'] : '';
                                                $people_phone = isset($this->arrDetails[$i]['people_phone']) ? $this->arrDetails[$i]['people_phone'] : '';
                                                $room_num = isset($this->arrDetails[$i]['room_num']) ? $this->arrDetails[$i]['room_num'] : '';
                                                $room_reservation_num = isset($this->arrDetails[$i]['room_reservation_num']) ? $this->arrDetails[$i]['room_reservation_num'] : '';
                                                $nights_num = isset($this->arrDetails[$i]['nights_num']) ? $this->arrDetails[$i]['nights_num'] : '';
                                                $package_price = isset($this->arrDetails[$i]['package_price']) ? $this->arrDetails[$i]['package_price'] : 0;
                                                $deposit_price = isset($this->arrDetails[$i]['deposit_price']) ? $this->arrDetails[$i]['deposit_price'] : 0;
                                                $cc_processed = isset($this->arrDetails[$i]['cc_processed']) ? $this->arrDetails[$i]['cc_processed'] : '';
                                                $notes = isset($this->arrDetails[$i]['notes']) ? $this->arrDetails[$i]['notes'] : '';

                                                $package_total += $package_price;
                                                $deposit_total += $deposit_price;
                                                $balance = intval($package_price) - intval($deposit_price);
                                                $final_total += $balance;

                                                ?>
                                            <tr>
                                                <td><input name="people_num[]" size="2" value="<?php echo $people_num; ?>" readonly="" class="input-sm form-control"></td>
                                                <td><input name="people_name[]" id="people_name_<?php echo $people_num; ?>" size="10" value="<?php echo $people_name; ?>" class="input-sm form-control"></td>
                                                <td><input name="people_lname[]" id="people_lname_<?php echo $people_num; ?>" size="10" value="<?php echo $people_lname; ?>" class="input-sm form-control"></td>
                                                <td><input name="people_email[]" id="people_email_<?php echo $people_num; ?>" size="15" value="<?php echo $people_email; ?>" class="input-sm form-control"></td>
                                                <td><input name="people_phone[]" id="people_phone_<?php echo $people_num; ?>" size="8" value="<?php echo $people_phone; ?>" class="input-sm form-control"></td>
                                                <td><input name="room_num[]" id="room_num_<?php echo $people_num; ?>" size="2" value="<?php echo $room_num; ?>" class="input-sm form-control"></td>
                                                <td><input name="room_reservation_num[]" id="room_reservation_num_<?php echo $people_num; ?>" size="10" value="<?php echo $room_reservation_num; ?>" class="input-sm form-control"></td>
                                                <td><input name="nights_num[]" type="number" data-restrict-number="true" id="nights_num_<?php echo $people_num; ?>" size="2" value="<?php echo $nights_num; ?>" class="input-sm form-control"></td>
                                                <td><input name="package_price[]" type="number" data-restrict-number="true" data-allow-period="true" id="package_price_<?php echo $people_num; ?>" size="2" value="<?php echo $package_price; ?>"  class="input-sm form-control"></td>
                                                <td><input name="deposit_price[]" type="number" data-restrict-number="true" data-allow-period="true" id="deposit_price_<?php echo $people_num; ?>" size="5" value="<?php echo $deposit_price; ?>"  class="input-sm form-control"></td>
                                                <td>$<?php echo $balance; ?></td>
                                                <td><input name="cc_processed[]" type="number" data-restrict-number="true" data-allow-period="true" id="cc_processed_<?php echo $people_num; ?>" size="2" value="<?php echo $cc_processed; ?>" class="input-sm form-control"></td>
                                                <td><textarea name="notes[]" id="notes_<?php echo $people_num; ?>" cols="10" rows="2" class="input-sm form-control"><?php echo $notes; ?></textarea></td>
                                                <td><input name="member_id[]" id="member_id_<?php echo $people_num; ?>" size="2" value="<?php echo $member_id; ?>" class="input-sm form-control"></td>
                                            </tr>
                                            <?php
                                            $i++;
                                            } ?>
                                            <tr>
                                                <td colspan="7" class="right"><b>Total amount :</b></td>
                                                <td>$<?php echo $package_total; ?></td>
                                                <td>$<?php echo $deposit_total; ?></td>
                                                <td>$<?php echo $final_total; ?></td>
                                                <td colspan="3">&nbsp;</td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </div>
                                <?php
                                }

                                    //echo '<pre>';
                                    //var_dump($this->arrDetails);
                           // } ?>
                        </div>




                    </div>

                    <div class="tab-pane" id="email">

                        <div class="form-group">
                            <label for="mini_content">Hotel email content:</label>
                            <!--<p><small><a href="javascript:return void();" id="copy_mini_hotel">copy from brand template</a></small></p>-->
                            <textarea name="email_content" id="email_content" class="form-control" rows="15"><?php echo $this->objModel->strMiniContent; ?></textarea>
                        </div>
                        <input type="hidden" name="package_id" id="package_id" value="<?php echo $this->objModel->intID; ?>">
                        <input type="button" name="send_hotel_email" id="send_hotel_email" class="btn btn-secondary" value="Send Email To Hotel">&nbsp;
                        <input type="button" name="refresh_hotel_email" id="refresh_hotel_email" class="btn btn-secondary" value="Refresh">&nbsp;
                        <input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save">
                        <p><small><span id="result_hotel"></span></small></p>

                    </div>

                </div>

            </div>

        </div>
    </form>
    <input type="hidden" name="relhotelID" id="relhotelID" value="<?php echo $this->objModel->intRelHotelID; ?>" />
</div>

<script type='text/javascript'>

$(document).ready(function($) {

    // Toggle the disabled state on the rate controls
    $('body').on('click', '.js-control-hotel-rate', function() {
        fnToggleControls();
    });

    $('body').on('click', '.js-control-course-rate', function() {
        fnToggleControls();
    });

    fnToggleControls();

    /**
     * Enables or disables the nights and room controls when a hotel is selected
     *
     */
    function fnToggleControls() {
        // The control types
        var objControls = [
            $('.js-control-hotel-rate'),
            $('.js-control-course-rate')
        ];

        for (var i=0; i<objControls.length; i++) {
            // Loop through each of the hotel controls
            objControls[i].each(function() {
                // Get the control objects
                var jobjItem = $(this);
                var jobjControls = jobjItem.closest('tr').find('.form-control');

                if (jobjItem.is(':checked') && typeof(jobjControls) !== 'undefined') {
                   // Enable the control
                   jobjControls.removeAttr('disabled');
                } else {
                    // Disable the control
                    jobjControls.attr('disabled', 'disabled');
                }
            });
        }
    }

});

</script>


<?php //var_dump($this); ?>