<div class="modal fade duplicate-modal js-duplicate-package-hotel-modal" data-post-url="<?php echo $this->strAdminSlug; ?>duplicate/">
    <form method="post" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Duplicate Package Hotel</h4>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-12 js-message-alert hide">
                            <div class="alert alert-danger js-alert" role="alert"></div>
                        </div>

                        <div class="col-md-12" style="margin-bottom: 12px;">
                            <h4>Select hotel for duplicate</h4>
                            <small class="text-muted">This duplicates the hotel and person records. Only the person name, room number, and room nights will be duplicated for a person record.</small>
                        </div>
                        <div class="col-md-12">
                            <div class="input-group">
                                <select name="duplicate_hotel_id" class="form-control">
                                    <?php 
                                    if(!empty($this->arrHotelsNotUses)){
                                        foreach($this->arrHotelsNotUses as $arrHotel){
                                            $strSelected = '';

                                            if($arrHotel['slug'] == 'golf-group-room-pairing-list'){
                                                $strSelected = 'selected="selected"';
                                            }

                                            echo '<option value="' . $arrHotel['id'] . '" ' . $strSelected . '>' . $arrHotel['hotel_name'] . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                                <span class="input-group-btn">
                                    <button class="btn btn-primary js-submit-button" type="submit" name="duplicate" value="1" data-loading-text="Duplicating...">Use Selected Hotel</button>
                                    <div class="js-loading-icon hide"><i class="fa fa-refresh fa-spin"></i></div>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="hide">
                        <input type="hidden" class="js-package-hotel-id" name="package_hotel_id" value="" />
                        <input type="hidden" class="js-package-id" name="package_id" value="" />
                    </div>
                </div>
                <div class="modal-footer" style="margin-top: 3px;">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </form>
</div><!-- /.modal -->

<script type="text/javascript">

$(document).ready(function(){
    $('.js-duplicate-package-hotel').click(function(event){
        event.preventDefault();

        var jobjModal = $('.js-duplicate-package-hotel-modal');

        jobjModal.find('.js-package-hotel-id').val($(this).data('package-hotel-id'));
        jobjModal.find('.js-package-id').val($(this).data('package-id'));
        jobjModal.modal('show');
    });

    $('.js-duplicate-package-hotel-modal .js-submit-button').click(function(event){
        event.preventDefault();

        var jobjModal = $(this).closest('.js-duplicate-package-hotel-modal');
        var jobjForm = jobjModal.find('form');

        var objData = jobjForm.serializeObject();     

        objData.action = 'duplicate_package_hotel';


        // show loading icon
        jobjModal.find('.js-submit-button').button('loading');
        jobjModal.find('.js-message-alert').addClass('hide');

        // make ajax call to duplicate
        $.getJSON('/application/ajax.php', objData, function(objResponse){
            console.log(objResponse);

            if(objResponse.error){
                // error occured
                jobjModal.find('.js-message-alert .alert').html(objResponse.message);
                jobjModal.find('.js-message-alert').removeClass('hide');

                jobjModal.find('.js-submit-button').button('reset');        
                return;
            }

            // success
            // redirect to new package hotel page.
            window.location.href = '/admin/package/' + objData.package_id + '/hotel/edit/' + objResponse.newPackageId;
            return true;
        });
    });
});

</script>