<?php if($this->objModel->intId != '') { ?>
<h3>
    Golf Courses
    <a href="<?php echo $this->strAdminSlug . $this->objModel->intId;?>/golf/add/" class="btn btn-sm btn-success">Add New</a>
</h3>
<?php } ?>

<?php
$this->arrPackageCourses = $this->objModel->getCoursesForPackage($this->objModel->intId);
if(count($this->arrPackageCourses) > 0) { ?>

<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Golf Course</th>
            <th>Tee Time</th>
            <th>Confirmation Number</th>
            <th>Course Details</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach($this->arrPackageCourses As $course) {
            echo '<tr>';
            echo '<td>'.$course['course_name'].'</td>';
            echo '<td>'.$course['tee_day'].' '. $course['tee_date'].' '. $course['tee_time'].' '. $course['tee_ap'] .'</td>';
            echo '<td>'.$course['confirm_num'].'</td>';
            echo '<td>' 
                    . 'Tee Times Phone #: ' . $course['teetimes_phone'] . '<br />'
                    . 'Tee Times Email: <a href="mailto:' . $course['teetimes_email'] . '">'.$course['teetimes_email'].'</a><br />'
                    . 'Booking URL: <a target="_blank" href="' . $course['booking_url'] . '">'.$course['booking_url'].'</a><br />'
                    . 'Booking Username: ' . $course['booking_username'] . '<br />'
                    . 'Booking Password: ' . $course['booking_password'] . '<br />';
            echo '</td>';
            echo '<td>'.$this->getPageGridGolfControls($course['id'],'/admin/package/'.$this->objModel->intId.'/golf/').'</td>';
            echo '</tr>';
        } ?>
    </tbody>
</table>

<?php } else { ?>
    <p>No courses booked yet.</p>
<?php } ?>

<hr>

<?php if($this->objModel->intId != '') { ?>
<h3>
    Hotels
    <a href="<?php echo $this->strAdminSlug . $this->objModel->intId;?>/hotel/add/" class="btn btn-sm btn-success">Add New</a>
</h3>
<?php } ?>

<?php
$this->arrPackageHotels = $this->objModel->getHotelsForPackage($this->objModel->intId);
if(count($this->arrPackageHotels) > 0) { ?>

<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Default</th>
            <th>Paypal</th>
            <th>Hotel</th>
            <th>Check In</th>
            <th>Check Out</th>
            <th># Nights</th>
            <th># Rooms</th>
            <th># People</th>
            <th>Confirmation Number</th>
            <th>Hotel Details</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach($this->arrPackageHotels As $hotel) {
            echo '<tr>';
            echo '<td>'.($hotel['default']==1?"Yes":"No").'</td>';
            echo '<td><a href="/admin/report/paypal/?searchWord='.$this->objModel->intId.'">View</a></td>';
            echo '<td>'.$hotel['hotel_name'].'</td>';
            echo '<td>'.$hotel['check_in_date'].'</td>';
            echo '<td>'.$hotel['check_out_date'].'</td>';
            echo '<td>'.$hotel['nights'].'</td>';
            echo '<td>'.$hotel['rooms'].'</td>';
            echo '<td>'.$hotel['golfers'].'</td>';
            echo '<td>'.$hotel['confirm_num'].'</td>';
            //echo '<td>'.$hotel['default'].'</td>';
            echo '<td>'
                    . 'Phone #: ' . $hotel['contact_phone'] . '<br />'
                    . 'Front Desk Email: <a href="mailto:' . $hotel['frontdesk_email'] . '">'.$hotel['frontdesk_email'].'</a><br />'
                    . 'Booking URL: <a target="_blank" href="' . $hotel['booking_url'] . '">'.$hotel['booking_url'].'</a><br />'
                    . 'Booking Username: ' . $hotel['booking_username'] . '<br />'
                    . 'Booking Password: ' . $hotel['booking_password'] . '<br />';
            echo '</td>'; 
            echo '<td>'.$this->getPageGridHotelControls($hotel['id'],'/admin/package/'.$this->objModel->intId.'/hotel/') . ($hotel['default'] == '1' ? ' | <i title="Group Payment Hotel" class="fa fa-dollar fa-lg"></i>' :'') .'</td>';
            echo '</tr>';
        } ?>
    </tbody>
</table>

<?php 
    // include('_duplicate_hotel.php');
} else { 

?>

<p>No Hotels booked yet.</p>

<?php } ?>


<?php 

        // include('_duplicate_hotel.php');

 ?>