<?php

    $objReportModel = new Report();

    $dblHotelCost = $objReportModel->getPackageHotelTotalCost($this->objModel->intId);
    $dblCourseCost = $objReportModel->getPackageCourseTotalCost($this->objModel->intId);
    $dblTotalCost = $dblHotelCost + $dblCourseCost;
    $dblSellValue = $objReportModel->getSellValueByPackage($this->objModel->intId);
    $dblProfit = $dblSellValue - $dblTotalCost;

    if ($dblTotalCost != 0) {
        $dblProfitMargin = $dblSellValue / $dblTotalCost;
    } else {
        $dblProfitMargin = 0;
    }

?>

<div class="row">

    <div class="col-xs-12 col-md-9">

        <div class="col-xs-12 col-md-6">

            <label>Currency:</label>
            <select name="currency" class="form-control">
                <option value="CAD" <?php echo Util::isSelected($this->objModel->strCurrency,"CAD");?>>CAD</option>
                <option value="USD" <?php echo Util::isSelected($this->objModel->strCurrency,"USD");?>>USD</option>
            </select>
        </div>

        <div class="col-xs-12 col-md-12">
            <table>
                <tr>
                    <td><label>Hotel Private Cost:</label>
                    <td style='text-align: right;'><?php echo Util::formatPrice($dblHotelCost); ?></td>
                </tr>
                <tr>
                    <td><label>Course Private Cost:</label>
                    <td style='text-align: right;'><?php echo Util::formatPrice($dblCourseCost); ?></td>
                </tr>
                <tr>
                    <td><label>Package Total Cost:</label>
                    <td style='text-align: right;'><?php echo Util::formatPrice($dblTotalCost); ?></td>
                </tr>
                <tr>
                    <td><label>Sell Value:</label>
                    <td style='text-align: right;'><?php echo Util::formatPrice($dblSellValue); ?></td>
                </tr>
                <tr>
                    <td><label>Profit:</label></td>
                    <td style='text-align: right;'><?php echo Util::formatPrice($dblProfit); ?></td>
                </tr>
                <tr>
                    <td><label>Profit Margin:</label></td>
                    <td style='text-align: right;'>%<?php echo Util::formatPrice($dblProfitMargin, ''); ?></td>
                </tr>
            </table>
        </div>

        <div class="col-xs-12 col-md-6" style="display:none;">
            <label>Package Price:</label>
            <input type="text" name="price" id="price" class="form-control" placeholder="Enter price Here" value="<?php echo $this->objModel->intPrice; ?>">

            <br />
            <label>Total People:</label>
            <input type="text" name="total_people" id="total_people" class="form-control" placeholder="Enter total people Here" value="<?php echo $this->objModel->intTotalPeople; ?>">

        </div>
        <div class="col-xs-12 col-md-6" style="display:none;">

            <br />


            <label>Total Rooms:</label>
            <input type="text" name="total_rooms" id="total_rooms" class="form-control" placeholder="Enter total rooms Here" value="<?php echo $this->objModel->intTotalRooms; ?>">

            <br />

            <label>Total Rounds:</label>
            <input type="text" name="total_rounds" id="total_rounds" class="form-control" placeholder="Enter total rounds Here" value="<?php echo $this->objModel->intTotalRounds; ?>">
        </div>

    </div>

    <div class="col-xs-12 col-md-3">
        <br />
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Save Options</h3>
            </div>
            <div class="panel-body">
                <div class="btn-group btn-group-justified">
                    <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.'?sub=true'.$this->strOptions; ?>';"></div>
                    <div class="btn-group"><input type="submit" name="trash" onClick="return confirm('are you sure you want to trash this package?')"  id="trash" class="btn btn-secondary" value="Trash"></div>
                    <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                </div>

                <hr />

                <div class="btn-group btn-group-justified">
                    <?php if(!empty($this->objModel->intQuoteId)){ ?>
                        <div class="btn-group">
                            <a href="<?php
                                $arrQuoteGroup = Quote::getGroupById($this->objModel->intQuoteId);
                                echo ROOT_URL . '/admin/quote/' . $arrQuoteGroup['id'] . '/edit/' . $this->objModel->intQuoteId . '/';
                                ?>" class="btn btn-secondary">View Original Quote</a>
                        </div>
                    <?php } ?>

                    <div class="btn-group">
                        <a href="<?php
                            echo ROOT_URL . '/admin/package/convert-quote/' . $this->objModel->intId;
                            ?>" class="btn btn-info">Convert to Quote</a>
                    </div>
                </div>
            </div>

        </div>

    </div>

</div>