<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="?sub=true<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>
        <div class="row">
            <div class="col-xs-12 col-md-9">

                <h3>Contact Information</h3>

                <div class="form-group">
                    <label for="first_name">First Name:</label>
                    <input type="text" name="first_name" id="first_name" class="form-control" placeholder="Enter First Name Here" value="<?php echo $this->objModel->strFirstName; ?>">
                </div>

                <div class="form-group">
                    <label for="last_name">Last Name:</label>
                    <input type="text" name="last_name" id="last_name" class="form-control" placeholder="Enter Last Name Here" value="<?php echo $this->objModel->strLastName; ?>">
                </div>

                <div class="form-group">
                    <label for="email">Email:</label>
                    <input type="text" name="email" id="email" class="form-control" placeholder="Enter Email Here" value="<?php echo $this->objModel->strEmail; ?>">
                </div>

                <div class="form-group">
                    <label for="phone">Phone:</label>
                    <input type="text" name="phone" id="phone" class="form-control" placeholder="Enter Phone Here" value="<?php echo $this->objModel->strPhone; ?>">
                </div>

                <div class="form-group">
                    <label for="cell">Cell:</label>
                    <input type="text" name="cell" id="cell" class="form-control" placeholder="Enter Cell Here" value="<?php echo $this->objModel->strCell; ?>">
                </div>

                <div class="form-group">
                    <label for="cell">Cell Provider:</label><br />
                    <select id="provider" name="provider" class="form-control">
                        <option value="">Select Provider</option>
                        <?php foreach($this->arrProviders As $p) {
                            echo '<option value="'.$p['id'].'" '.Util::isSelected($this->objModel->strProvider,$p['id']).'>'.$p['name'].'</option>';
                        } ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="cell">Fax:</label>
                    <input type="text" name="fax" id="fax" class="form-control" placeholder="Enter Fax Here" value="<?php echo $this->objModel->strFax; ?>">
                </div>

                <hr>

                <h3>Address</h3>

                <div class="form-group">
                    <label for="country">Country:</label>
                    <select name="country" id="country" class="form-control">
                    <?php foreach($this->arrCountries As $c){
                        echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->objModel->intCountryId).'>'.$c['country_name'].'</option>';
                    } ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="state">State:</label>
                    <select name="state" id="state" class="form-control">
                    <?php foreach($this->arrStates As $s){
                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intStateId).'>'.$s['state_name'].'</option>';
                    } ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="city">City:</label>
                    <select name="city" id="city" class="form-control">
                    <?php foreach($this->arrCities As $s){
                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intCityId).'>'.$s['title'].'</option>';
                    } ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="address">Address:</label>
                    <input type="text" name="address" id="address" class="form-control" placeholder="Enter Address Here" value="<?php echo $this->objModel->strAddress; ?>">
                </div>

                <div class="form-group">
                    <label for="postal_code">Postal Code:</label>
                    <input type="text" name="postal_code" id="postal_code" class="form-control" placeholder="Enter Postal Here" value="<?php echo $this->objModel->strPostalCode; ?>">
                </div>

                <hr />
            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.'?sub=true'.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">

    jQuery(document).ready(function($) {

        $("#country").change(function () {
            $("#state, #city").find("option:gt(0)").remove();
            $("#state").find("option:first").text("Loading...");
            $.getJSON("/application/ajax.php", {
                country: $(this).val(),
                action: 'getProvs'
            }, function (json) {
                $("#state").find("option:first").text("Please Choose");
                $("#state").find("option:first").attr("value", 0);

                for (var i = 0; i < json.length; i++) {
                    //console.log(json[i].id);
                    $("<option/>").attr("value", json[i].id).text(json[i].state_name).appendTo($("#state"));
                }
            });
        });

        $("#state").change(function () {
            $("#city").find("option:gt(0)").remove();
            $("#city").find("option:first").text("Loading...");
            $.getJSON("/application/ajax.php", {
                prov: $(this).val(),
                action: 'getCities'
            }, function (json) {

                $("#city").find("option:first").text("Please Choose");
                $("#city").find("option:first").attr("value", 0);

                for (var i = 0; i < json.length; i++) {
                    $("<option/>").attr("value", json[i].id).text(json[i].title).appendTo($("#city"));
                }
            });
        });

    });

</script>

