<?php
/**
* Mass Mailer page template
*
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Mass Mailer</h1>

    <form role="form" id="mass-mailer-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs">
                    <li class="active"><a href="#packages" data-toggle="tab">Packages Mailer</a></li>
                    <li><a href="#quotes" data-toggle="tab">Quotes Mailer</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="packages">
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Group Name:</label>
                                    <input type="text" name="group_name" id="group_name" class="form-control" value="">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Min Golfers:</label>
                                    <input type="number" name="min_golfers" id="min_golfers" class="form-control" value="">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Max Golfers:</label>
                                    <input type="number" name="max_golfers" id="max_golfers" class="form-control" value="">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">WL Brand:</label>
                                    <?php echo $this->getBrandDDL($this->objModel->intBrandId);?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Primary Contact:</label>
                                    <?php echo $this->getBookingPeopleDDL($this->objModel->intBookingPersonID);?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Date From:</label>
                                    <input class="form-control datepicker" placeholder="YYYY-MM-DD" type="text" name="min_date" id="min_date" value="" >
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Date To:</label>
                                    <input class="form-control datepicker" placeholder="YYYY-MM-DD" type="text" name="max_date" id="max_date" value="" >
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Package Status:</label>
                                    <?php echo $this->getPackageStatus($this->objModel->intPackageStatus);?>
                                </div>
                            </div>
                        </div>

                        <div class="row calculator-form">
                            <div class="col-xs-12 col-sm-6">

                            <p><strong>Hotels</strong></p>
                            <?php if (!empty($this->arrHotels)) { ?>

                                <div class="well well-sm well-overflow">
                                    <table class="calculator-control-list table table-condensed">
                                        <thead>
                                            <tr>
                                                <th colspan="2">Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($this->arrHotels)) {
                                                foreach ($this->arrHotels as $arrHotel) {
                                                    $intId = $arrHotel['id'];
                                                    //$strChecked = array_key_exists($intId, $arrHotels) ? 'checked' : '';
                                                    $strChecked = '';
                                                    ?>
                                                    <tr data-row-hotel-id="<?php echo $intId; ?>">
                                                        <td colspan="2">
                                                            <div class="checkbox">
                                                                <label><input type="checkbox" name="hotels[<?php echo $intId; ?>]" class="js-control-hotel" value="<?php echo $intId; ?>" <?php echo $strChecked; ?>> <?php echo $arrHotel['hotel_name']; ?></label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <?php } ?>
                            <div class="col-xs-12 col-sm-6">

                            <p><strong>Courses</strong></p>

                            <?php if (!empty($this->arrCourses)) { ?>

                                <div class="well well-sm well-overflow">
                                    <table class="calculator-control-list table table-condensed">
                                        <thead>
                                            <tr>
                                                <th colspan="2">Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($this->arrCourses)) {
                                                foreach ($this->arrCourses as $arrCourse) {
                                                    $intId = $arrCourse['id'];
                                                    $strChecked = '';
                                                    //$strChecked = array_key_exists($intId, $arrCourses) ? 'checked' : '';
                                                    ?>
                                                    <tr data-row-hotel-id="<?php echo $intId; ?>">
                                                        <td colspan="2">
                                                            <div class="checkbox">
                                                                <label><input type="checkbox" name="courses[<?php echo $intId; ?>]" class="js-control-hotel" value="<?php echo $intId; ?>" <?php echo $strChecked; ?>> <?php echo $arrCourse['course_name']; ?></label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="email_subject" class="control-label">Email Subject:</label>
                                    <p><small>Placeholders: [user_name]</small></p>
                                    <input type="text" name="email_subject" id="email_subject" class="form-control" value="A message from BCGolfGuide.com">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <label for="mini_content">Email Content:</label>
                                <p><small>Placeholders: [group_name], [user_name], [link]</small></p>
                                <div class="js-late-resize-editor">
                                    <textarea name="package_content" id="package_content" class="form-control" rows="15"><?php echo $this->strContent; ?></textarea>
                                </div>
                                <script type="text/javascript">loadRTE('package_content','brands'); </script>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="quotes">
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Group Name:</label>
                                    <input type="text" name="quote_group_name" id="quote_group_name" class="form-control" value="<?php echo $_REQUEST['quote_group_name']; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="quote_name" class="control-label">Quote Name:</label>
                                    <input type="text" name="quote_name" id="quote_name" class="form-control" value="">
                                </div>
                            </div>
                        </div>
                        <!--
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Min Golfers:</label>
                                    <input type="number" name="quote_min_golfers" id="quote_min_golfers" class="form-control" value="<?php echo $_REQUEST['quote_min_golfers']; ?>">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Max Golfers:</label>
                                    <input type="number" name="quote_max_golfers" id="quote_max_golfers" class="form-control" value="<?php echo $_REQUEST['quote_max_golfers']; ?>">
                                </div>
                            </div>
                        </div>
                        -->
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">WL Brand:</label>
                                    <?php echo $this->getBrandDDL($this->objModel->intBrandId, 'quoteBrandID');?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Emails Read:</label>
                                    <?php echo $this->getEmailsReadDDL($this->objModel->strEmailsRead);?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Primary Contact:</label>
                                    <?php echo $this->getBookingPeopleDDL($this->objModel->intBookingPersonID, 'quoteAgentID');?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Date From:</label>
                                    <input class="form-control datepicker" placeholder="YYYY-MM-DD" type="text" name="quote_min_date" id="quote_min_date" value="" >
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="site_name" class="control-label">Date To:</label>
                                    <input class="form-control datepicker" placeholder="YYYY-MM-DD" type="text" name="quote_max_date" id="quote_max_date" value="" >
                                </div>
                            </div>
                        </div>

                        <div class="row calculator-form">
                            <div class="col-xs-12 col-sm-6">

                            <p><strong>Hotels</strong></p>
                            <?php if (!empty($this->arrHotels)) { ?>

                                <div class="well well-sm well-overflow">
                                    <table class="calculator-control-list table table-condensed">
                                        <thead>
                                            <tr>
                                                <th colspan="2">Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($this->arrHotels)) {
                                                foreach ($this->arrHotels as $arrHotel) {
                                                    $intId = $arrHotel['id'];
                                                    //$strChecked = array_key_exists($intId, $arrHotels) ? 'checked' : '';
                                                    $strChecked = '';
                                                    ?>
                                                    <tr data-row-hotel-id="<?php echo $intId; ?>">
                                                        <td colspan="2">
                                                            <div class="checkbox">
                                                                <label><input type="checkbox" name="quote_hotels[<?php echo $intId; ?>]" class="js-control-hotel" value="<?php echo $intId; ?>" <?php echo $strChecked; ?>> <?php echo $arrHotel['hotel_name']; ?></label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <?php } ?>
                            <div class="col-xs-12 col-sm-6">

                            <p><strong>Courses</strong></p>

                            <?php if (!empty($this->arrCourses)) { ?>

                                <div class="well well-sm well-overflow">
                                    <table class="calculator-control-list table table-condensed">
                                        <thead>
                                            <tr>
                                                <th colspan="2">Name</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (!empty($this->arrCourses)) {
                                                foreach ($this->arrCourses as $arrCourse) {
                                                    $intId = $arrCourse['id'];
                                                    $strChecked = '';
                                                    //$strChecked = array_key_exists($intId, $arrCourses) ? 'checked' : '';
                                                    ?>
                                                    <tr data-row-hotel-id="<?php echo $intId; ?>">
                                                        <td colspan="2">
                                                            <div class="checkbox">
                                                                <label><input type="checkbox" name="quote_courses[<?php echo $intId; ?>]" class="js-control-hotel" value="<?php echo $intId; ?>" <?php echo $strChecked; ?>> <?php echo $arrCourse['course_name']; ?></label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <div class="form-group">
                                    <label for="quote_email_subject" class="control-label">Email Subject:</label>
                                    <p><small>Placeholders: [user_name]</small></p>
                                    <input type="text" name="quote_email_subject" id="quote_email_subject" class="form-control" value="A message from BCGolfGuide.com">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <label for="quote_email_content">Email Content:</label>
                                <p><small>Placeholders: [group_name], [user_name], [link]</small></p>
                                <div class="js-late-resize-editor">
                                    <textarea name="quote_email_content" id="quote_email_content" class="form-control" rows="15"><?php echo $this->strContent; ?></textarea>
                                </div>
                                <script type="text/javascript">loadRTE('quote_email_content','brands'); </script>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group">
                                <input type="button" name="mm_view_update_list" id="mm_view_update_list" class="btn btn-secondary" value="View / Update List">
                            </div>
                            <!--
                            <div class="btn-group">
                                <input type="submit" name="see_list" id="see_list" class="btn btn-secondary" value="View List">
                            </div>
                            -->
                        </div>
                        <br />
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group email-list-preview">
                            </div>
                        </div>

                        <br />
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group">
                                <label for="test_email" class="control-label">Send Test Email To:</label>
                                <input type="text" name="test_email" id="test_email" class="form-control" value="">
                                <br />
                                <input disabled type="button" name="send_test_email" id="send_test_email" class="btn btn-secondary" value="Send Test Email">
                            </div>
                        </div>

                        <br />
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group">
                                <input disabled type="button" name="send_emails_go" id="send_emails_go" class="btn btn-primary" value="Send Emails">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    jQuery(document).ready(function($) {
        $('#mass-mailer-form').submit(function(e) {
            e.preventDefault();
        });
    });
</script>