<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="docs"><a href="#docs" data-toggle="tab">Documents</a></li>
                    <li class="photos"><a href="#photos" data-toggle="tab">Photos</a></li>
                    <li class="videos"><a href="#videos" data-toggle="tab">Videos</a></li>
                    <li class="seo-options"><a href="#seo-options" data-toggle="tab">SEO Options</a></li>
                    <li class="seo-analysis"><a href="#seo-analysis" data-toggle="tab">SEO Analysis</a></li>
                    <li class="social-media"><a href="#social-media" data-toggle="tab">Social Media</a></li>
                    <li class="reminder-emails"><a href="#reminder-emails" data-toggle="tab">Booking Reminder Emails</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="form-group">
                            <label for="hotel_name" class="sr-only">Name:</label>
                            <input type="text" name="hotel_name" id="hotel_name" class="form-control input-sm" placeholder="Enter Name Here" value="<?php echo $this->objModel->strHotelName; ?>">
                        </div>

                        <div class="slug-field form-horizontal">
                            <div class="form-group">
                                <div class="col-sm-10">
                                    <label for="slug" class="sr-only">Slug URL:</label>
                                    <input type="text" name="slug" id="slug" class="form-control input-sm" placeholder="/golf-accommodations/enter-title-here" value="<?php echo $this->objModel->strSlug; ?>">
                                </div>
                                <div class="col-sm-2">
                                    <div class="btn-group btn-group-justified">
                                        <a href="<?php echo $this->objModel->strSlug; ?>" class="btn btn-secondary btn-sm" target="_blank">View</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="type_id">Category:</label>
                                    <select name="type_id" id="type_id" class="form-control">
                                        <option value="">Please choose</option>
                                        <?php foreach($this->arrCategories As $c){
                                            echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->objModel->intTypeId).'>'.$c['type_name'].'</option>';
                                        } ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="hit_counter">Hits:</label>
                                    <input type="text" name="hit_counter" id="hit_counter" class="form-control" placeholder="Enter Hits Here" value="<?php echo $this->objModel->intHits; ?>">
                                </div>
                            </div>

                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="level">Level:</label>
                                    <select name="level" id="level" class="form-control">
                                        <option value="">Please choose</option>
                                        <?php for($i = 1;$i <=20;$i++){

                                            echo '<option value="'.$i.'" '.Util::isSelected($i, $this->objModel->intLevel).'>'.$i.'</option>';
                                        } ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h3>Check In &amp; Check Out</h3>

                        <div class="row">

                            <div class="col-xs-12 col-sm-6">
                                <label for="check_in_time">Check in time:</label>
                                <div class="form-inline">
                                    <div class="form-group">
                                        
                                        <input type="text" name="check_in_time" id="check_in_time" class="form-control" value="<?php echo $this->objModel->strCheckInTime; ?>" />
                                    </div>
                                    <div class="form-group">
                                        <select name="check_in_ap" id="check_in_ap" class="form-control">
                                            <option value="AM" <?php echo Util::isSelected('AM', $this->objModel->strCheckInAp);?>>AM</option>
                                            <option value="PM" <?php echo Util::isSelected('PM', $this->objModel->strCheckInAp);?>>PM</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <label for="check_out_time">Check out time:</label>
                                <div class="form-inline">
                                    <div class="form-group">
                                        
                                        <input type="text" name="check_out_time" id="check_out_time" class="form-control"  value="<?php echo $this->objModel->strCheckOutTime; ?>" />
                                    </div>
                                    <div class="form-group">
                                        <select name="check_out_ap" id="check_out_ap" class="form-control">
                                            <option value="AM" <?php echo Util::isSelected('AM', $this->objModel->strCheckOutAp);?>>AM</option>
                                            <option value="PM" <?php echo Util::isSelected('PM', $this->objModel->strCheckOutAp);?>>PM</option>
                                        </select>
                                    </div>
                                </div>

                            </div>


                        </div>

                        <hr>


                        <h3>Address Information</h3>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="country">Country:</label>
                                    <select name="country" id="country" class="form-control">
                                    <?php foreach($this->arrCountries As $c){

                                        echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->objModel->intCountryId).'>'.$c['country_name'].'</option>';
                                    }
                                    ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="state">State:</label>
                                    <select name="state" id="state" class="form-control">
                                    <?php foreach($this->arrStates As $s){

                                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intStateId).'>'.$s['state_name'].'</option>';
                                    }
                                    ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="city_id">City:</label>
                                    <select name="city" id="city" class="form-control">
                                    <?php foreach($this->arrCities As $s){

                                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intCityId).'>'.$s['title'].'</option>';
                                    }
                                    ?>
                                    </select>

                                </div>

                                <div class="form-group">
                                    <label for="address">Address:</label>
                                    <input type="text" name="address" id="address" class="form-control" placeholder="Enter address Here" value="<?php echo $this->objModel->strAddress; ?>">
                                </div>

                            </div>
                            <div class="col-xs-12 col-sm-6">
                                

                                <div class="form-group">
                                    <label for="zip">Postal Code:</label>
                                    <input type="text" name="zip" id="zip" class="form-control" placeholder="Enter postal code Here" value="<?php echo $this->objModel->strZip; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="latitude">Latitude:</label>
                                    <input type="text" name="latitude" id="latitude" class="form-control" placeholder="Enter latitude Here" value="<?php echo $this->objModel->strLatitude; ?>">
                                </div>


                                <div class="form-group">
                                    <label for="longitude">Longitude:</label>
                                    <input type="text" name="longitude" id="longitude" class="form-control" placeholder="Enter longitude Here" value="<?php echo $this->objModel->strLongitude; ?>">
                                </div>
                            </div>

                        </div>
                        
                        <hr>

                        <div class="form-group">
                            <div class="cuztom-gmap-wrap" >
                                <p>
                                    <input type="button" class="syncField button-primary" value="Get Location From Address" />
                                    <input type="button" class="clearMarker button-secondary" value="Clear Map" />
                                </p>
                                <div class="gmap-holder" id="map-canvas" data-lat="" data-lng="" data-zoom="12" data-show-marker="false"></div>
                                <input type="hidden" name="coordinates" id="coordinates" value="" />
                            </div>
                        </div>


                        <script>
                            jQuery(document).ready(function(){

                                //these need to come from the database record.
                                jQuery('.gmap-holder').each(function(){
                                    var mapHolder = jQuery(this);
                                    var bounds = new google.maps.LatLngBounds();
                                    var marker = null;
                                    //var title = jQuery('#mls').val();
                                    var lat = jQuery('#latitude').val();
                                    var long = jQuery('#longitude').val();

                                    // center the map near Kimberly BC
                                    if (lat == 0 && long == 0) {
                                        lat         = 49.6437304;
                                        long        = -115.940024;
                                        add_marker  = false;
                                    } else {
                                        add_marker  = true;
                                    }

                                    init_latlng = new google.maps.LatLng(lat, long);

                                    var mapOptions = {
                                        center: init_latlng,
                                        zoom: 12
                                    };

                                    map = new google.maps.Map(document.getElementById(mapHolder.attr('id')),
                                        mapOptions);


                                    if(marker === null && add_marker){
                                        var pos = init_latlng;
                                        marker = new google.maps.Marker({
                                            position: pos,
                                            draggable:true
                                        });

                                        // Add marker to map
                                        marker.setMap(map);
                                        bounds.extend(pos);
                                        nav_listing_setupMarker(marker, map, mapHolder);
                                    }

                                    // Clear Button
                                    jQuery('.clearMarker').click(function(event){
                                        event.preventDefault();
                                        marker.setMap(null);
                                        marker = null;

                                        // save no location
                                        mapHolder.closest('.cuztom-gmap-wrap').find('input[type=hidden]').val('');
                                        mapHolder.attr('data-lat', '').attr('data-lng', '');
                                    });

                                    mapHolder.closest('.cuztom-gmap-wrap').find('.syncField').click(function(event){
                                        event.preventDefault();
                                        adr = jQuery('#address').val();
                                        city = jQuery('#city option:selected').text();
                                        country = jQuery('#country option:selected').text();
                                        province = jQuery('#state option:selected').text();

                                        if(adr != '' && city != '' && country != '' && province != '') {
                                            var address = adr + ' ' + city + ' ' + province + ' ' + country;

                                            if(marker === null){
                                                marker = new google.maps.Marker({
                                                    position: init_latlng,
                                                    draggable:true,
                                                    animation: google.maps.Animation.DROP
                                                });

                                                marker.setMap(map);
                                                //bounds.extend(marker.position);
                                                nav_listing_setupMarker(marker, map, mapHolder);
                                            }

                                            nav_listing_codeAddress(map, address, marker, mapHolder);
                                        } else {
                                            alert('Address incomplete, Please fill in the address, city province and country then try again');
                                        }
                                    });


                                });
                            });
                        
                        </script>





                        <hr>

                        <h3>Contact Information</h3>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="contact_person">Contact Person:</label>
                                    <input type="text" name="contact_person" id="contact_person" class="form-control" placeholder="Enter contact person Here" value="<?php echo $this->objModel->strContactPerson; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="contact_phone">Phone:</label>
                                    <input type="text" name="contact_phone" id="contact_phone" class="form-control" placeholder="Enter contact phone Here" value="<?php echo $this->objModel->strContactPhone; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="contact_fax">Fax:</label>
                                    <input type="text" name="contact_fax" id="contact_fax" class="form-control" placeholder="Enter contact fax Here" value="<?php echo $this->objModel->strContactFax; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="account_name">Account Name:</label>
                                    <input type="text" name="account_name" id="account_name" class="form-control" placeholder="Enter account name Here" value="<?php echo $this->objModel->strAccountName; ?>">
                                </div>

                            </div>    
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="contact_email">Contact Email:</label>
                                    <input type="text" name="contact_email" id="contact_email" class="form-control" placeholder="Enter contact email Here" value="<?php echo $this->objModel->strContactEmail; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="frontdesk_email">Front Desk Email:</label>
                                    <input type="text" name="frontdesk_email" id="frontdesk_email" class="form-control" placeholder="Enter frontdesk email Here" value="<?php echo $this->objModel->strFrontdeskEmail; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="frontdesk_email_alt">Front Desk Email Alt:</label>
                                    <input type="text" name="frontdesk_email_alt" id="frontdesk_email_alt" class="form-control" placeholder="Enter frontdesk alternate email Here" value="<?php echo $this->objModel->strFrontdeskEmailAlt; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="account_email">Account Email:</label>
                                    <input type="text" name="account_email" id="account_email" class="form-control" placeholder="Enter account email Here" value="<?php echo $this->objModel->strAccountEmail; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="booking_url">Booking URL:</label>
                                    <input type="text" name="booking_url" id="booking_url" class="form-control" placeholder="Enter booking url Here" value="<?php echo $this->objModel->strBookingUrl; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="booking_username">Booking Username:</label>
                                    <input type="text" name="booking_username" id="booking_username" class="form-control" placeholder="Enter booking username Here" value="<?php echo $this->objModel->strBookingUsername; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="booking_password">Booking Passsword:</label>
                                    <input type="text" name="booking_password" id="booking_password" class="form-control" placeholder="Enter booking password Here" value="<?php echo $this->objModel->strBookingPassword; ?>">
                                </div>

                            </div>
                        </div>
                        <hr>

                        <h3>Aditional Information</h3>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="web_url">Website URL:</label>
                                    <input type="text" name="web_url" id="web_url" class="form-control" placeholder="Enter website url Here" value="<?php echo $this->objModel->strWebUrl; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="facebook_url">Facebook:</label>
                                    <input type="text" name="facebook_url" id="facebook_url" class="form-control" placeholder="Enter Facebook Here" value="<?php echo $this->objModel->strFacebookUrl; ?>">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="twitter_url">Twitter:</label>
                                    <input type="text" name="twitter_url" id="twitter_url" class="form-control" placeholder="Enter Twitter Here" value="<?php echo $this->objModel->strTwitterUrl; ?>">
                                </div>
                            </div>
                        </div>
                        <hr>

                        <h3>Description &amp; Amenities &amp; Notes</h3>

                        <div class="form-group">
                            <label for="description">Description:</label>
                            <textarea name="description" id="description" class="form-control" rows="15"><?php echo $this->objModel->strDescription; ?></textarea>
                            <script type="text/javascript">loadRTE('description','hotels');</script>
                        </div>

                        <div class="form-group">
                            <label for="amenities">Amenities:</label>
                            <textarea name="amenities" id="amenities" class="form-control" rows="15"><?php echo $this->objModel->strAmenities; ?></textarea>
                            <script type="text/javascript">loadRTE('amenities','hotels');</script>
                        </div>

                        <div class="form-group">
                            <label for="special_instructions">Special Guest Instructions:</label>
                            <textarea name="special_instructions" id="special_instructions" class="form-control" rows="15"><?php echo $this->objModel->strSpecialGuestInstructions; ?></textarea>
                            <script type="text/javascript">loadRTE('special_instructions','hotels');</script>
                        </div>

                        <div class="form-group">
                            <label for="notes">Notes:</label>
                            <textarea name="notes" id="notes" class="form-control" rows="5"><?php echo $this->objModel->strNotes; ?></textarea>
                        </div>

                        <hr>

                        


                    </div>

                    <div class="tab-pane" id="docs">
                        <div class="col-xs-12 col-md-12">
                            <?php include(ROOT_DIR.'/application/views/admin/include/_list_hotel_docs.php'); ?>
                        </div>
                    </div>

                    <div class="tab-pane" id="photos">
                        <div class="col-xs-12 col-md-12">
                            <?php include(ROOT_DIR.'/application/views/admin/include/_list_hotel_imgs.php'); ?>
                        </div>
                    </div>

                    <div class="tab-pane" id="videos">
                        <div class="col-xs-12 col-md-12">
                            <?php include(ROOT_DIR.'/application/views/admin/include/_list_hotel_videos.php'); ?>
                        </div>
                    </div>

                    <div class="tab-pane" id="seo-options">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-analysis">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_analysis.php'); ?>
                    </div>

                    <div class="tab-pane" id="social-media">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_social_media_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="reminder-emails">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_reminder_emails_form.php'); ?>
                    </div>

                </div>

            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">

                        <?php if (!empty($this->objModel->arrScore)) { ?>
                        <div class="form-group">
                            <strong>SEO Score:</strong>
                            <input type="hidden" name="score_seo" value="<?php echo $this->objModel->arrScore['score']; ?>">
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $this->objModel->arrScore['score']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $this->objModel->arrScore['score']; ?>%;">
                                    <?php echo $this->objModel->arrScore['score']; ?>%
                                </div>
                            </div>
                         </div>
                        <?php } ?>

                        <hr>

                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Logo Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="display_image" class="sr-only">Display Image:</label>
                            <input type="file" name="display_image" id="display_image" class="form-control" >
                        </div>

                        <?php if (!empty($this->objModel->strDisplayImage)) { ?>
                        <div class="well well-sm"><?php Util::displayThumb($this->objModel->strDisplayImage, 333, 150, 3); ?></div>
                        <div class="checkbox">
                            <label><input type="checkbox" name="files_to_delete[display_image]" id="files_to_delete" value="<?php echo $this->objModel->strDisplayImage; ?>"> Remove Image</label>
                        </div>
                        <?php } ?>
                    </div>

                </div>


            </div>

        </div>
    </form>
</div>
<?php if($this->tab != '') { ?>
<script type="text/javascript">
    $('#myTab li').removeClass('active');
    $('.tab-pane').removeClass('active');
    $('#<?php echo $this->tab;?>').addClass('active');
    //
    $('#myTab li.<?php echo $this->tab;?>').addClass('active');
</script>
<?php } ?>


<script type="text/javascript">

    jQuery(document).ready(function($) {

        $("#country").change(function () {
            $("#state, #city").find("option:gt(0)").remove();
            $("#state").find("option:first").text("Loading...");
            $.getJSON("/application/ajax.php", {
                country: $(this).val(),
                action: 'getProvs'
            }, function (json) {
                $("#state").find("option:first").text("Please Choose");
                $("#state").find("option:first").attr("value", 0);
                $("#city").find("option:first").text("Please Choose");
                $("#city").find("option:first").attr("value", 0);
                for (var i = 0; i < json.length; i++) {
                    //console.log(json[i].id);
                    $("<option/>").attr("value", json[i].id).text(json[i].state_name).appendTo($("#state"));
                }
            });
        });

        $("#state").change(function () {
            $("#city").find("option:gt(0)").remove();
            $("#city").find("option:first").text("Loading...");
            $.getJSON("/application/ajax.php", {
                prov: $(this).val(),
                action: 'getCities'
            }, function (json) {

                $("#city").find("option:first").text("Please Choose");
                $("#city").find("option:first").attr("value", 0);

                for (var i = 0; i < json.length; i++) {
                    $("<option/>").attr("value", json[i].id).text(json[i].title).appendTo($("#city"));
                }
            });
        });

    });

</script>



<?php //var_dump($this->page); ?>