<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>
        <div class="row">
            <div class="col-xs-12 col-md-9">

                <div class="form-group">
                    <label for="description">Description:</label>
                    <input type="text" name="description" id="description" class="form-control" placeholder="Enter description Here" value="<?php echo $this->objModel->strDescription; ?>">
                </div>

                <div class="form-group">
                    <label for="file_name" class="sr-only">File:</label>
                    <input type="file" name="file_name" id="file_name" class="form-control" >
                </div>


                <?php if (!empty($this->objModel->strFileName)) { ?>
                <div class="well well-sm"><?php Util::displayThumb($this->objModel->strFileName, 333, 150); ?></div>
                <?php } ?>

            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ if($this->strAction != 'add') { ?>
                            <div class="btn-group"><input type="button" name="trash" id="trash" class="btn btn-secondary" value="Delete" onclick="confirmDelete('/admin/hotel/<?php echo $this->intID; ?>/docs/delete/<?php echo $this->imgID; ?>/');"></div>
                            <?php } } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </form>
</div>
