<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="?sub=true<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <div style="display:none;"><input id="default_action" name="submit" type="submit" value="Save" /></div>


        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <!-- Nav tabs -->
            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="locations"><a href="#locations" data-toggle="tab">Locations</a></li>
                    <li class="seo-options"><a href="#seo-options" data-toggle="tab">SEO Options</a></li>
                    <li class="seo-analysis"><a href="#seo-analysis" data-toggle="tab">SEO Analysis</a></li>
                    <li class="social-media"><a href="#social-media" data-toggle="tab">Social Media</a></li>
                    <li class="you-tube"><a href="#you-tube" data-toggle="tab">YouTube Embed</a></li>
                </ul>

                <div class="tab-content">

                    <div class="tab-pane" id="seo-options">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="you-tube">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_youtube.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-analysis">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_analysis.php'); ?>
                    </div>

                    <div class="tab-pane" id="social-media">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_social_media_form.php'); ?>
                    </div>

                    <div class="tab-pane active" id="general">

                        <div class="form-group">
                            <label for="title" class="sr-only">Title:</label>
                            <input type="text" name="title" id="title" class="form-control input-sm" placeholder="Enter Title Here" value="<?php echo $this->objModel->strPackageName; ?>">
                        </div>

                        <div class="slug-field form-horizontal">
                            <div class="form-group">
                                <div class="col-sm-10">
                                    <label for="slug" class="sr-only">Slug URL:</label>
                                    <input type="text" name="slug" id="slug" class="form-control input-sm" placeholder="/featured-golf-packages/" value="<?php echo $this->objModel->strSlug; ?>">
                                </div>
                                <div class="col-sm-2">
                                    <div class="btn-group btn-group-justified">
                                        <a href="<?php echo $this->objModel->strSlug; ?>/" class="btn btn-secondary btn-sm" target="_blank">View</a>
                                        <!--<a href="" class="btn btn-secondary btn-sm">Get Shortlink</a>-->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="form-group">
                            <label for="region_id">Region:</label> <small class="text-muted">This is to center any maps primarily. Does not affect what shows on brand pages.</small>
                            <select name="region_id" id="region_id" class="form-control">
                                <option value="">All Regions</option>
                                <?php foreach($this->arrRegions AS $region) {
                                    echo '<option value="'.$region['id'].'" '.Util::isSelected($region['id'], $this->objModel->intRegionId) .'>'.$region['region_name'].'</option>';
                                } ?>
                            </select>
                        </div>



                        <hr />


                        <div class="form-group">
                            <label for="region_id">Brand(s):</label> <small class="text-muted">Which brand pages should use this package?</small><br />
                            <?php foreach($this->arrBrands AS $brand) {
                                echo '<input type="checkbox" name="brandID[]" value="'.$brand['id'].'" '.Util::isChecked($this->objModel->arrSelectedBrands,$brand['id']).'/> '.$brand['business_name'].'<br />';
                            }
                            ?>
                        </div>


                        <hr />



                        <div class="row">
                            <div class="col-xs-12 col-sm-6">

                                <div class="form-group">
                                    <label for="price">Price:</label>
                                    <input type="text" name="price" id="price" class="form-control" placeholder="Enter Title Here" value="<?php echo $this->objModel->strPrice; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="start_date"><span class="required">*</span> Start Date:</label>
                                    <input type="text" class="form-control datepicker" placeholder="YYYY-MM-DD" name="start_date" id="start_date" value="<?php echo $this->objModel->strStartDate; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="end_date"><span class="required">*</span> End Date:</label>
                                    <input type="text" class="form-control datepicker" placeholder="YYYY-MM-DD" name="end_date" id="end_date" value="<?php echo $this->objModel->strEndDate; ?>">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="priority">Priority:</label>
                                    <select name="priority" id="priority" class="form-control">
                                        <option value="0" <?php echo Util::isSelected(0,$this->objModel->intPriority); ?>>Low</option>
                                        <option value="1" <?php echo Util::isSelected(1,$this->objModel->intPriority); ?>>Med</option>
                                        <option value="2" <?php echo Util::isSelected(2,$this->objModel->intPriority); ?>>High</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="hits">Hits:</label>
                                    <input type="text" name="hits" id="hits" class="form-control" placeholder="Enter Hits Here" value="<?php echo $this->objModel->intHits; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="margin">Margin Factor (0.5 = 50%):</label>
                                    <input type="number" min='0' max='1' step='0.01' name="margin" id="margin" class="form-control" placeholder="Enter Margin Here" value="<?php echo $this->objModel->strMargin; ?>">
                                </div>

                            </div>
                            <div class="col-xs-12 col-sm-12">

                                <h3>Content</h3>
                                <div class="form-group">
                                    <label for="description">Description:</label>
                                    <textarea name="description" id="description" class="form-control" rows="15"><?php echo $this->objModel->strDescription; ?></textarea>
                                    <script type="text/javascript">loadRTE('description','packages');</script>
                                </div>

                                <div class="form-group">
                                    <label for="short_description">Excerpt:</label>
                                    <textarea name="short_description" id="short_description" class="form-control" rows="5"><?php echo $this->objModel->strShortDescription; ?></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="mini_description">Mini Description: <small>(shown on widget)</small></label>
                                    <textarea name="mini_description" id="mini_description" class="form-control" rows="5"><?php echo $this->objModel->strMiniDescription; ?></textarea>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="tab-pane" id="locations">

                        <input type='hidden' id='update_locations' name='update_locations' value=''>
                        <input type='hidden' id='recalc_price' name='recalc_price' value=''>

                        <div class="row">

                            <div class="col-xs-12 col-sm-12">

                                <h3>Locations</h3>
                                <div class="form-group">
                                    <label for="filter_year">Filter Year</label>
                                    <?php

                                    $strFilterYear = '';
                                    if (isset($_POST['filter_year'])) {
                                        $strFilterYear = $_POST['filter_year'];
                                    }

                                    echo $this->getFeaturePackageRateYearDDL($strFilterYear);

                                    ?>

                                    <input type="submit" name="submit" id="filter_submit" class="btn btn-primary" value="Filter Year">
                                </div>
                                <div class="form-group">
                                    <label for="hotels">Hotels:</label>
                                    <?php //$this->getHotelDDL($this->objModel->arrHotels);
                                        $this->getFeaturePackageHotelDDL($this->objModel->intID, $this->objModel->intRegionId, $strFilterYear);
                                    ?>
                                </div>

                                <div class="form-group">
                                    <label for="courses">Golf Courses:</label>
                                    <?php //$this->getCourseDDL($this->objModel->arrCourse);
                                        $this->getFeatureCourseDDL($this->objModel->intID, $this->objModel->intRegionId, $strFilterYear);
                                    ?>
                                </div>
                            </div>

                        </div>


                    </div>


                </div>

            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">

                        <?php if (!empty($this->objModel->arrScore)) { ?>
                        <div class="form-group">
                            <strong>SEO Score:</strong>
                            <input type="hidden" name="score_seo" value="<?php echo $this->objModel->arrScore['score']; ?>">
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $this->objModel->arrScore['score']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $this->objModel->arrScore['score']; ?>%;">
                                    <?php echo $this->objModel->arrScore['score']; ?>%
                                </div>
                            </div>
                         </div>
                        <?php } ?>

                        <hr>

                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.'?sub=true'.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Featured Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="file_name" class="sr-only">Display Image:</label>
                            <input type="file" name="file_name" id="file_name" class="form-control" >
                        </div>

                        <?php if (!empty($this->objModel->strFileName)) { ?>
                        <div class="well well-sm"><?php Util::displayThumb($this->objModel->strFileName, 333, 150); ?></div>
                        <div class="checkbox">
                            <label><input type="checkbox" name="files_to_delete[file_name]" id="files_to_delete" value="<?php echo $this->objModel->strFileName ?>"> Remove Image</label>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

        </div>
    </form>

</div>

<script type="text/javascript">

$(document).ready(function(e){

    $('.js-hotels,.js-courses input,select').change(function(e) {

        if ($(this).prop('name') != 'filter_year') {
            $("#update_locations").val('true');
        }
    });

    $('input#margin').change(function(e) {
        $("#update_locations").val('true');
    });

    $(document).submit(function(e) {
        if ($("#update_locations").val() == 'true') {
            if (confirm('Courses, Hotels or margin has been changed, do you wish to recalculate price?')) {
                $("#recalc_price").val('true');
            }
        }
    });

    $('.js-hotels tr').each(function(e) {
        if (($(this)).find('input:checkbox').prop('checked')) {
            $(this).find('input').prop('disabled', false);
            $(this).find('select').prop('disabled', false);
        }
    });

    $('.js-hotel-selected').click(function(e) {
        //alert($(this).prop('checked'));
        if ($(this).prop('checked')) {
            $(this).parents('tr').find('.js-hotel-select').prop('disabled', false);
            $(this).parents('tr').find('.js-hotel-roomnights').prop('disabled', false);
        } else {
            $(this).parents('tr').find('.js-hotel-select').prop('disabled', true);
            $(this).parents('tr').find('.js-hotel-roomnights').prop('disabled', true);
        }
    });

     $('.js-courses tr').each(function(e) {
        if (($(this)).find('input:checkbox').prop('checked')) {
            $(this).find('input').prop('disabled', false);
            $(this).find('select').prop('disabled', false);
        }
    });

    $('.js-course-selected').click(function(e) {
        //alert($(this).prop('checked'));
        if ($(this).prop('checked')) {
            $(this).parents('tr').find('.js-course-select').prop('disabled', false);
            $(this).parents('tr').find('.js-course-rounds').prop('disabled', false);
        } else {
            $(this).parents('tr').find('.js-course-select').prop('disabled', true);
            $(this).parents('tr').find('.js-course-rounds').prop('disabled', true);
        }
    });
});

</script>