<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>
        <div class="row">
            <div class="col-xs-12 col-md-9">

                <div class="form-group">
                    <label for="url">Video URL:</label>
                    <input type="text" name="url" id="url" class="form-control" placeholder="Enter url Here" value="<?php echo $this->objModel->strUrl; ?>">
                </div>

                <div class="form-group">
                    <label for="title">Title:</label>
                    <input type="text" name="title" id="title" class="form-control" placeholder="Leave empty to get from youtube" value="<?php echo $this->objModel->strVideoTitle; ?>">
                </div>

                <div class="form-group">
                    <label for="description">Description (leave empty to get from Youtube):</label>
                    <textarea name="description" id="description" class="form-control" rows="5"><?php echo $this->objModel->strDescription; ?></textarea>
                </div>

                <hr />

                <?php if($this->strAction != 'add') { ?>
                    <h3>Video</h3>
                    <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo $this->objModel->strKey; ?>" frameborder="0" allowfullscreen></iframe>
                <?php } ?>

            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ if($this->strAction != 'add') { ?>
                            <div class="btn-group"><input type="button" name="trash" id="trash" class="btn btn-secondary" value="Delete" onclick="confirmDelete('/admin/course/<?php echo $this->intID; ?>/videos/delete/<?php echo $this->intVideoID; ?>/');" ></div>
                            <?php } } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>
                <?php if($this->strAction != 'add') { ?>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Thumbnails</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div id="fade" class="pics" style="position: relative;">
                                <?php echo '<img src="'.$this->objModel->strThumbnailURL.'" style="width:100%;" />'; ?>
                                <?php echo '<img src="'.$this->objModel->strThumbnailURL1.'" style="width:100%;" />'; ?>
                                <?php echo '<img src="'.$this->objModel->strThumbnailURL2.'" style="width:100%;" />'; ?>
                                <?php echo '<img src="'.$this->objModel->strThumbnailURL3.'" style="width:100%;" />'; ?>
                            </div>
                        </div>
                        <script>
                            $('#fade').cycle({
                                fx:    'fade',
                                speed:  500,
                                timeout:  500
                            });

                            $('#fade').cycle('pause'); // pause it right away.

                            $('#fade').hover(
                                function() {
                                    $(this).cycle('resume'); // start playing.
                                },
                                function(){
                                    $(this).cycle('pause'); // pause the slideshow.
                                }
                            ).trigger('hover');

                        </script>
                    </div>
                </div>
                <?php } ?>
            </div>

        </div>
    </form>
</div>
