<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';

            echo '<script>location.href=\'/admin/course/edit/' . $this->objModel->intID. '/?tab=testimonials\';</script>';
        }
        ?>
        <div class="row">
            <div class="col-xs-12 col-md-9">

                <div class="form-group">
                    <label for="first_name">First Name:</label>
                    <input type="text" name="first_name" id="first_name" class="form-control" placeholder="Enter First Name Here" value="<?php echo $this->objModel->strFirstName; ?>">
                </div>

                <div class="form-group">
                    <label for="last_name">Last Name:</label>
                    <input type="text" name="last_name" id="last_name" class="form-control" placeholder="Enter Last Name Here" value="<?php echo $this->objModel->strLastName; ?>">
                </div>

                <div class="form-group">
                    <label for="user_email">Email:</label>
                    <input type="text" name="user_email" id="user_email" class="form-control" placeholder="Enter Email Here" value="<?php echo $this->objModel->strEmail; ?>">
                </div>

                <hr>

                <div class="form-group">
                    <label for="timestamp_post">Posted Date:</label>
                    <input type="text" name="timestamp_post" id="timestamp_post" class="form-control datepicker" placeholder="Enter Posted Date Here" value="<?php echo Date('Y-m-d',strtotime($this->objModel->strTimestampPost)); ?>">
                </div>

                <div class="form-group">
                    <label for="detail">Comment:</label>
                    <textarea name="detail" id="detail" class="form-control" rows="10" ><?php echo $this->objModel->strDetail; ?></textarea>
                </div>

            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ if($this->strAction != 'add') { ?>
                            <div class="btn-group"><input type="button" name="trash" id="trash" class="btn btn-secondary" value="Delete" onclick="confirmDelete('/admin/course/<?php echo $this->intID; ?>/testimonials/delete/<?php echo $this->intTestimonialID; ?>/');"></div>
                            <?php } } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>




            </div>



        </div>
    </form>
</div>
<?php //var_dump($this); ?>