<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>
        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="details"><a href="#details" data-toggle="tab">Course Detail</a></li>
                    <li class="photos"><a href="#photos" data-toggle="tab">Photos</a></li>
                    <li class="videos"><a href="#videos" data-toggle="tab">Videos</a></li>
                    <li class="docs"><a href="#docs" data-toggle="tab">Files</a></li>
                    <li class="reviews"><a href="#reviews" data-toggle="tab">Reviews</a></li>
                    <li class="testimonials"><a href="#testimonials" data-toggle="tab">Testimonials</a></li>
                    <li class="seo-options"><a href="#seo-options" data-toggle="tab">SEO Options</a></li>
                    <li class="seo-analysis"><a href="#seo-analysis" data-toggle="tab">SEO Analysis</a></li>
                    <li class="socail-media"><a href="#social-media" data-toggle="tab">Social Media</a></li>
                    <li class="reminder-emails"><a href="#reminder-emails" data-toggle="tab">Booking Reminder Emails</a></li>
                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">

                        <div class="form-group">
                            <label for="hotel_name" class="sr-only">Name:</label>
                            <input type="text" name="course_name" id="course_name" class="form-control input-lg" placeholder="Enter Name Here" value="<?php echo $this->objModel->strCourseName; ?>">
                        </div>

                        <div class="slug-field form-horizontal">
                            <div class="form-group">
                                <div class="col-sm-10">
                                    <label for="slug" class="sr-only">Slug URL:</label>
                                    <input type="text" name="slug" id="slug" class="form-control input-sm" placeholder="/detail/course/enter-title-here" value="<?php echo $this->objModel->strSlug; ?>">
                                </div>
                                <div class="col-sm-2">
                                    <div class="btn-group btn-group-justified">
                                        <a href="<?php echo $this->objModel->strSlug; ?>" class="btn btn-secondary btn-sm" target="_blank">View</a>
                                        <!--<a href="" class="btn btn-secondary btn-sm">Get Shortlink</a>-->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">

                            <div class="col-xs-12 col-sm-4">
                                <div class="form-group">
                                    <label for="type_id">Category:</label>
                                    <select name="type_id" id="type_id" class="form-control">
                                        <option value="">Please choose</option>
                                        <?php foreach($this->arrCategories As $c){
                                            echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->objModel->intTypeId).'>'.$c['type_name'].'</option>';
                                        } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-4">
                                <div class="form-group">
                                    <label for="hit_counter">Hits:</label>
                                    <input type="text" name="hit_counter" id="hit_counter" class="form-control" placeholder="Enter Hits Here" value="<?php echo $this->objModel->intHits; ?>">
                                </div>
                            </div>   
                            <div class="col-xs-12 col-sm-4">
                                <div class="form-group">
                                    <label for="level">Level:</label>
                                    <select name="level" id="level" class="form-control">
                                        <option value="">Please choose</option>
                                    <?php for($i = 1;$i <=20;$i++){
                                        echo '<option value="'.$i.'" '.Util::isSelected($i, $this->objModel->intLevel).'>'.$i.'</option>';
                                    } ?>
                                    </select>
                                </div>
                            </div>

                        </div>

                        <hr>

                        <h3>Address Information</h3>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="country_id">Country:</label>
                                    <select name="country_id" id="country_id" class="form-control">
                                    <?php foreach($this->arrCountries As $c){
                                        echo '<option value="'.$c['id'].'" '.Util::isSelected($c['id'], $this->objModel->intCountryId).'>'.$c['country_name'].'</option>';
                                    } ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="state_id">State:</label>
                                    <select name="state_id" id="state_id" class="form-control">
                                    <?php foreach($this->arrStates As $s){
                                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intStateId).'>'.$s['state_name'].'</option>';
                                    } ?>
                                    </select>
                                </div> 
                                <div class="form-group">
                                    <label for="zip">Postal Code:</label>
                                    <input type="text" name="zip" id="zip" class="form-control" placeholder="Enter postal code Here" value="<?php echo $this->objModel->strZip; ?>">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="city_id">City:</label>
                                    <select name="city_id" id="city_id" class="form-control">
                                    <?php foreach($this->arrCities As $s){
                                        echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $this->objModel->intCityId).'>'.$s['title'].'</option>';
                                    } ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="address">Address:</label>
                                    <input type="text" name="address" id="address" class="form-control" placeholder="Enter address Here" value="<?php echo $this->objModel->strAddress; ?>">
                                </div>
                            </div>    
                        </div> 
                          
                        <div class="row">
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="latitude">Latitude:</label>
                                    <input type="text" name="latitude" id="latitude" class="form-control" placeholder="Enter latitude Here" value="<?php echo $this->objModel->strLatitude; ?>">
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6">
                                <div class="form-group">
                                    <label for="longitude">Longitude:</label>
                                    <input type="text" name="longitude" id="longitude" class="form-control" placeholder="Enter longitude Here" value="<?php echo $this->objModel->strLongitude; ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="cuztom-gmap-wrap" >
                                <p>
                                    <input type="button" class="syncField button-primary" value="Get Location From Address" />
                                    <input type="button" class="clearMarker button-secondary" value="Clear Map" />
                                </p>
                                <div class="gmap-holder" id="map-canvas" data-lat="" data-lng="" data-zoom="12" data-show-marker="false"></div>
                                <input type="hidden" name="coordinates" id="coordinates" value="" />
                            </div>
                        </div>


                        <script>
                            jQuery(document).ready(function(){

                                //these need to come from the database record.
                                jQuery('.gmap-holder').each(function(){
                                    var mapHolder = jQuery(this);
                                    var bounds = new google.maps.LatLngBounds();
                                    var marker = null;
                                    //var title = jQuery('#mls').val();
                                    var lat = jQuery('#latitude').val();
                                    var long = jQuery('#longitude').val();

                                    // center the map near Kimberly BC
                                    if (lat == 0 && long == 0) {
                                        lat         = 49.6437304;
                                        long        = -115.940024;
                                        add_marker  = false;
                                    } else {
                                        add_marker  = true;
                                    }

                                    init_latlng = new google.maps.LatLng(lat, long);

                                    var mapOptions = {
                                        center: init_latlng,
                                        zoom: 12
                                    };

                                    map = new google.maps.Map(document.getElementById(mapHolder.attr('id')),
                                        mapOptions);


                                    if(marker === null && add_marker){
                                        var pos = init_latlng;
                                        marker = new google.maps.Marker({
                                            position: pos,
                                            draggable:true
                                        });

                                        // Add marker to map
                                        marker.setMap(map);
                                        bounds.extend(pos);
                                        nav_listing_setupMarker(marker, map, mapHolder);
                                    }

                                    // Clear Button
                                    jQuery('.clearMarker').click(function(event){
                                        event.preventDefault();
                                        marker.setMap(null);
                                        marker = null;

                                        // save no location
                                        mapHolder.closest('.cuztom-gmap-wrap').find('input[type=hidden]').val('');
                                        mapHolder.attr('data-lat', '').attr('data-lng', '');
                                    });

                                    mapHolder.closest('.cuztom-gmap-wrap').find('.syncField').click(function(event){
                                        event.preventDefault();
                                        adr = jQuery('#address').val();
                                        city = jQuery('#city_id option:selected').text();
                                        country = jQuery('#country_id option:selected').text();
                                        province = jQuery('#state_id option:selected').text();

                                        if(adr != '' && city != '' && country != '' && province != '') {
                                            var address = adr + ' ' + city + ' ' + province + ' ' + country;

                                            if(marker === null){
                                                marker = new google.maps.Marker({
                                                    position: init_latlng,
                                                    draggable:true,
                                                    animation: google.maps.Animation.DROP
                                                });

                                                marker.setMap(map);
                                                //bounds.extend(marker.position);
                                                nav_listing_setupMarker(marker, map, mapHolder);
                                            }

                                            nav_listing_codeAddress(map, address, marker, mapHolder);
                                        } else {
                                            alert('Address incomplete, Please fill in the address, city province and country then try again');
                                        }
                                    });


                                });
                            });
                        
                        </script>

                        <hr>

                        <h3>Contact Information</h3>
         

                        <div class="row">

                            <div class="col-xs-12 col-md-6">

                                <div class="form-group">
                                    <label for="contact_person">Contact Person:</label>
                                    <input type="text" name="contact_person" id="contact_person" class="form-control" placeholder="Enter contact person Here" value="<?php echo $this->objModel->strContactPerson; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="account_name">Account Name:</label>
                                    <input type="text" name="account_name" id="account_name" class="form-control" placeholder="Enter account name Here" value="<?php echo $this->objModel->strAccountName; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="contact_phone">Phone:</label>
                                    <input type="text" name="contact_phone" id="contact_phone" class="form-control" placeholder="Enter contact phone Here" value="<?php echo $this->objModel->strContactPhone; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="teetimes_phone">Tee Times Phone:</label>
                                    <input type="text" name="teetimes_phone" id="teetimes_phone" class="form-control" placeholder="Enter teetimes phone Here" value="<?php echo $this->objModel->strTeetimesPhone; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="teetimes_email">Tee Times Email:</label>
                                    <input type="text" name="teetimes_email" id="teetimes_email" class="form-control" placeholder="Enter teetimes Email Here" value="<?php echo $this->objModel->strTeetimesEmail; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="contact_fax">Fax:</label>
                                    <input type="text" name="contact_fax" id="contact_fax" class="form-control" placeholder="Enter contact fax Here" value="<?php echo $this->objModel->strContactFax; ?>">
                                </div>
                            </div>

                            <div class="col-xs-12 col-md-6">
                                <div class="form-group">
                                    <label for="contact_email">Contact Email:</label>
                                    <input type="text" name="contact_email" id="contact_email" class="form-control" placeholder="Enter contact email Here" value="<?php echo $this->objModel->strContactEmail; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="account_email">Account Email:</label>
                                    <input type="text" name="account_email" id="account_email" class="form-control" placeholder="Enter account email Here" value="<?php echo $this->objModel->strAccountEmail; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="clubhouse_phone">Clubhouse Phone:</label>
                                    <input type="text" name="clubhouse_phone" id="clubhouse_phone" class="form-control" placeholder="Enter clubhouse phone Here" value="<?php echo $this->objModel->strClubhousePhone; ?>">
                                </div>

                                <div class="form-group">
                                    <label for="proshop_phone">Proshop Phone:</label>
                                    <input type="text" name="proshop_phone" id="proshop_phone" class="form-control" placeholder="Enter proshop phone Here" value="<?php echo $this->objModel->strProshopPhone; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="booking_url">Booking URL:</label>
                                    <input type="text" name="booking_url" id="booking_url" class="form-control" placeholder="Enter Booking URL Here" value="<?php echo $this->objModel->strBookingUrl; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="booking_username">Booking Username:</label>
                                    <input type="text" name="booking_username" id="booking_username" class="form-control" placeholder="Enter Booking Username Here" value="<?php echo $this->objModel->strBookingUsername; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="booking_password">Booking Password:</label>
                                    <input type="text" name="booking_password" id="booking_password" class="form-control" placeholder="Enter Booking Password Here" value="<?php echo $this->objModel->strBookingPassword; ?>">
                                </div>

                            </div>

                        </div>

     
                        <hr>

                        <h3>Aditional Information</h3>

                        <div class="form-group">
                            <label for="web_url">Website URL:</label>
                            <input type="text" name="web_url" id="web_url" class="form-control" placeholder="Enter website url Here" value="<?php echo $this->objModel->strWebUrl; ?>">
                        </div>

                        <div class="form-group">
                            <label for="facebook_url">Facebook:</label>
                            <input type="text" name="facebook_url" id="facebook_url" class="form-control" placeholder="Enter Facebook Here" value="<?php echo $this->objModel->strFacebookUrl; ?>">
                        </div>

                        <div class="form-group">
                            <label for="twitter_url">Twitter:</label>
                            <input type="text" name="twitter_url" id="twitter_url" class="form-control" placeholder="Enter Twitter Here" value="<?php echo $this->objModel->strTwitterUrl; ?>">
                        </div>

                        <div class="form-group">
                            <label for="comments">Coments:</label>
                            <textarea name="comments" id="comments" class="form-control" rows="15"><?php echo $this->objModel->strComments; ?></textarea>
                            <script type="text/javascript">loadRTE('comments','comments');</script>
                        </div>

                    </div>

                    <div class="tab-pane" id="details">

                        <div class="form-group">
                            <label for="promotions">Current Golf Course Promotions (Golf, Dining, Proshop, Other)</label>
                            <textarea name="promotions" id="promotions" class="form-control" rows="5"><?php echo $this->objModel->strPromotions; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="directions">Directions</label>
                            <textarea name="directions" id="directions" class="form-control" rows="5"><?php echo $this->objModel->strDirections; ?></textarea>
                        </div>

                        <hr>

                        <h3>Tee Boxes</h3>
                        <div class="table-responsive">
                            <table class="table table-bordered" >
                                <thead>
                                    <tr class="active">
                                        <th>Tee Box</th>
                                        <th>Yardage</th>
                                        <th>Par</th>
                                        <th>Rating</th>
                                        <th>Slope</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $tb = json_decode($this->objModel->strTeeBoxes);
                                    foreach($tb As $teeBox)  {
                                        echo '<tr>';
                                        echo '  <td><input class="form-control" name="Tee_Boxes[]" value="'.$teeBox->Tee_Box.'"></td>
                                                <td><input class="form-control" name="Yardage[]" value="'.$teeBox->Yardage.'"></td>
                                                <td><input class="form-control" name="Par[]" value="'.$teeBox->Par.'"></td>
                                                <td><input class="form-control" name="Rating[]" value="'.$teeBox->Rating.'"></td>
                                                <td><input class="form-control" name="Slope[]" value="'.$teeBox->Slope.'"></td>';
                                        echo '</tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>

                        <h3>9 Holes</h3>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr class="active">
                                        <th>9 Holes</th>
                                        <th>Mon</th>
                                        <th>Tue</th>
                                        <th>Wed</th>
                                        <th>Thr</th>
                                        <th>Fri</th>
                                        <th>Sat</th>
                                        <th>Sun</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $h = json_decode($this->objModel->str9Holes);
                                    foreach($h As $hole)  {
                                        echo '<tr>';
                                        echo '  <td><input class="form-control" name="9_Holes[]" value="'.$hole->hole9.'"></td>
                                                <td><input class="form-control" name="mon[]" value="'.$hole->mon.'"></td>
                                                <td><input class="form-control" name="tue[]" value="'.$hole->tue.'"></td>
                                                <td><input class="form-control" name="wed[]" value="'.$hole->wed.'"></td>
                                                <td><input class="form-control" name="thu[]" value="'.$hole->thu.'"></td>
                                                <td><input class="form-control" name="fri[]" value="'.$hole->fri.'"></td>
                                                <td><input class="form-control" name="sat[]" value="'.$hole->sat.'"></td>
                                                <td><input class="form-control" name="sun[]" value="'.$hole->sun.'"></td>';
                                        echo '</tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>

                        <h3>18 Holes</h3>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr class="active">
                                        <td>18 Holes</td>
                                        <td>Mon</td>
                                        <td>Tue</td>
                                        <td>Wed</td>
                                        <td>Thr</td>
                                        <td>Fri</td>
                                        <td>Sat</td>
                                        <td>Sun</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $h = json_decode($this->objModel->str18Holes);
                                    foreach($h As $hole)  {
                                        echo '<tr>';
                                        echo '  <td><input class="form-control" name="18_Holes[]" value="'.$hole->hole18.'" size="5"></td>
                                                <td><input class="form-control" name="mon2[]" value="'.$hole->mon2.'" size="5"></td>
                                                <td><input class="form-control" name="tue2[]" value="'.$hole->tue2.'" size="5"></td>
                                                <td><input class="form-control" name="wed2[]" value="'.$hole->wed2.'" size="5"></td>
                                                <td><input class="form-control" name="thu2[]" value="'.$hole->thu2.'" size="5"></td>
                                                <td><input class="form-control" name="fri2[]" value="'.$hole->fri2.'" size="5"></td>
                                                <td><input class="form-control" name="sat2[]" value="'.$hole->sat2.'" size="5"></td>
                                                <td><input class="form-control" name="sun2[]" value="'.$hole->sun2.'" size="5"></td>';
                                        echo '</tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>

                        <hr>

                        <div class="form-group">
                            <label for="fee_note">Special Notes on Green Fees</label>
                            <input type="text" name="fee_note" id="fee_note" class="form-control" placeholder="Enter Tax Inc Here" value="<?php echo $this->objModel->strFeeNote; ?>">
                        </div>

                        <div class="form-group">
                            <label for="tax_inc">Tax Inc</label>
                            <input type="text" name="tax_inc" id="tax_inc" class="form-control" placeholder="Enter Tax Inc Here" value="<?php echo $this->objModel->strTaxInc; ?>">
                        </div>

                        <div class="form-group">
                            <label for="booking_policies">Booking Policies</label>
                            <textarea name="booking_policies" id="booking_policies" class="form-control" rows="5"><?php echo $this->objModel->strBookingPolicies; ?></textarea>
                        </div>

                        <div class="row">

                            <div class="col-xs-6 col-md-6">
                                <div class="form-group">
                                    <label for="gm">G.M.:</label>
                                    <input type="text" name="gm" id="gm" class="form-control" placeholder="Enter gm Here" value="<?php echo $this->objModel->strGm; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="head_pro">Head Pro:</label>
                                    <input type="text" name="head_pro" id="head_pro" class="form-control" placeholder="Enter head pro Here" value="<?php echo $this->objModel->strHeadPro; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="membership_type">Type (Private/Public/Semi-private):</label>
                                    <input type="text" name="membership_type" id="membership_type" class="form-control" placeholder="Enter membership type Here" value="<?php echo $this->objModel->strMembershipType; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="course_par">Par:</label>
                                    <input type="text" name="course_par" id="course_par" class="form-control" placeholder="Enter course par Here" value="<?php echo $this->objModel->strCoursePar; ?>">
                                </div>
                            </div>

                            <div class="col-xs-6 col-md-6">
                                <div class="form-group">
                                    <label for="dir_golf">Dir. Golf:</label>
                                    <input type="text" name="dir_golf" id="dir_golf" class="form-control" placeholder="Enter clubhouse phone Here" value="<?php echo $this->objModel->strDirGolf; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="seasonal">Golf is(seasonal/year-round):</label>
                                    <input type="text" name="seasonal" id="seasonal" class="form-control" placeholder="Enter seasonal Here" value="<?php echo $this->objModel->strSeasonal; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="holes">Holes:</label>
                                    <input type="text" name="holes" id="holes" class="form-control" placeholder="Enter clubhouse phone Here" value="<?php echo $this->objModel->strHoles; ?>">
                                </div>
                            </div>

                        </div>

                        <hr>

                        <div class="form-group">
                            <label for="teaching_professionals">Teaching Professionals</label>
                            <input type="text" name="teaching_professionals" id="teaching_professionals" class="form-control" placeholder="Enter teaching professionals Here" value="<?php echo $this->objModel->strTeachingProfessionals; ?>">
                        </div>

                        <div class="form-group">
                            <label for="course_superintendent">Course Superintendent</label>
                            <input type="text" name="course_superintendent" id="course_superintendent" class="form-control" placeholder="Enter Course Superintendent Here" value="<?php echo $this->objModel->strCourseSuperintendent; ?>">
                        </div>

                        <div class="row">

                            <div class="col-xs-6 col-md-6">
                                <div class="form-group">
                                    <label for="banq_fac">Banq. Fac.:</label>
                                    <input type="text" name="banq_fac" id="banq_fac" class="form-control" placeholder="Enter banq fac Here" value="<?php echo $this->objModel->strBanqFac; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="coordinator">Coordinator:</label>
                                    <input type="text" name="coordinator" id="coordinator" class="form-control" placeholder="Enter head pro Here" value="<?php echo $this->objModel->strCoordinator; ?>">
                                </div>
                            </div>

                            <div class="col-xs-6 col-md-6">
                                <div class="form-group">
                                    <label for="max_cap">Max. Cap.:</label>
                                    <input type="text" name="max_cap" id="max_cap" class="form-control" placeholder="Enter max cap Here" value="<?php echo $this->objModel->strMaxCap; ?>">
                                </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="course_amenities">Course Amenities</label>
                            <input type="text" name="course_amenities" id="course_amenities" class="form-control" placeholder="Enter Course Amenities Here" value="<?php echo $this->objModel->strCourseAmenities; ?>">
                        </div>

                        <div class="form-group">
                            <label for="course_architects">Course Architects</label>
                            <input type="text" name="course_architects" id="course_architects" class="form-control" placeholder="Enter Course Architects Here" value="<?php echo $this->objModel->strCourseArchitects; ?>">
                        </div>

                        <div class="form-group">
                            <label for="course_comments">Comments</label>
                            <textarea name="course_comments" id="course_comments" class="form-control" rows="5"><?php echo $this->objModel->strCourseComments; ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="course_a_comments">Additional Comments</label>
                            <textarea name="course_a_comments" id="course_a_comments" class="form-control" rows="5"><?php echo $this->objModel->strCourseAComments; ?></textarea>
                        </div>

                    </div>

                    <div class="tab-pane" id="docs">
                        <div class="col-xs-12 col-md-12">
                            <?php include(ROOT_DIR.'/application/views/admin/include/_list_course_docs.php'); ?>
                        </div>
                    </div>

                    <div class="tab-pane" id="photos">
                        <div class="col-xs-12 col-md-12"><?php include(ROOT_DIR.'/application/views/admin/include/_list_course_imgs.php'); ?></div>
                    </div>

                    <div class="tab-pane" id="videos">
                        <div class="col-xs-12 col-md-12"><?php include(ROOT_DIR.'/application/views/admin/include/_list_course_videos.php'); ?></div>
                    </div>

                    <div class="tab-pane" id="reviews">
                        <div class="col-xs-12 col-md-12"><?php include(ROOT_DIR.'/application/views/admin/include/_list_course_reviews.php'); ?></div>
                    </div>

                    <div class="tab-pane" id="testimonials">
                        <div class="col-xs-12 col-md-12"><?php include(ROOT_DIR.'/application/views/admin/include/_list_course_testimonials.php'); ?></div>
                    </div>

                    <div class="tab-pane" id="seo-options">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="seo-analysis">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_seo_analysis.php'); ?>
                    </div>

                    <div class="tab-pane" id="social-media">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_social_media_form.php'); ?>
                    </div>

                    <div class="tab-pane" id="reminder-emails">
                        <?php include(ROOT_DIR.'/application/views/admin/include/_reminder_emails_form.php'); ?>
                    </div>

                </div>

            </div>

            <div class="col-xs-12 col-md-3">

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">

                        <div class="form-group">
                            <label for="status">Status:</label>
                            <select name="status" id="status" class="form-control">
                                <option value="Active" <?php echo Util::isSelected('Active',$this->objModel->strStatus); ?>>Active</option>
                                <?php if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                                <option value="Trash" <?php echo Util::isSelected('Trash',$this->objModel->strStatus); ?>>Trash</option>
                                <?php } ?>
                            </select>
                        </div>

                        <?php if (!empty($this->objModel->arrScore)) { ?>
                        <div class="form-group">
                            <strong>SEO Score:</strong>
                            <input type="hidden" name="score_seo" value="<?php echo $this->objModel->arrScore['score']; ?>">
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $this->objModel->arrScore['score']; ?>" aria-valuemin="0" aria-valuemax="100" style="min-width: 20%; width: <?php echo $this->objModel->arrScore['score']; ?>%;">
                                    <?php echo $this->objModel->arrScore['score']; ?>%
                                </div>
                            </div>
                         </div>
                        <?php } ?>

                        <hr>

                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?><div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div><?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Logo Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="display_image" class="sr-only">Display Image:</label>
                            <input type="file" name="display_image" id="display_image" class="form-control" >
                        </div>

                        <?php if (!empty($this->objModel->strDisplayImage)) { ?>
                        <div class="well well-sm"><?php Util::displayThumb($this->objModel->strDisplayImage, 333, 150, 3); ?></div>
                        <div class="checkbox">
                            <label><input type="checkbox" name="files_to_delete[display_image]" id="files_to_delete" value="<?php echo $this->objModel->strDisplayImage; ?>"> Remove Image</label>
                        </div>
                        <?php } ?>
                    </div>

                </div>

            </div>

        </div>

    </form>
</div>


<script type="text/javascript">

    jQuery(document).ready(function($) {


        $("#country_id").change(function () {
            $("#state_id, #city_id").find("option:gt(0)").remove();
            $("#state_id").find("option:first").text("Loading...");
            $.getJSON("/application/ajax.php", {
                country: $(this).val(),
                action: 'getProvs'
            }, function (json) {
                $("#state_id").find("option:first").text("Please Choose");
                $("#state_id").find("option:first").attr("value", 0);
                $("#city_id").find("option:first").text("Please Choose");
                $("#city_id").find("option:first").attr("value", 0);
                for (var i = 0; i < json.length; i++) {
                    //console.log(json[i].id);
                    $("<option/>").attr("value", json[i].id).text(json[i].state_name).appendTo($("#state_id"));
                }
            });
        });

        $("#state_id").change(function () {
            $("#city_id").find("option:gt(0)").remove();
            $("#city_id").find("option:first").text("Loading...");
            $.getJSON("/application/ajax.php", {
                prov: $(this).val(),
                action: 'getCities'
            }, function (json) {

                $("#city_id").find("option:first").text("Please Choose");
                $("#city_id").find("option:first").attr("value", 0);

                for (var i = 0; i < json.length; i++) {
                    $("<option/>").attr("value", json[i].id).text(json[i].title).appendTo($("#city_id"));
                }
            });
        });

    });

</script>
<?php if($this->tab != '') { ?>
<script type="text/javascript">
    $('#myTab li').removeClass('active');
    $('.tab-pane').removeClass('active');
    $('#<?php echo $this->tab;?>').addClass('active');
    //
    $('#myTab li.<?php echo $this->tab;?>').addClass('active');
</script>
<?php }


//var_dump($this);

?>