<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">

    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>

    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">

        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>

        <div class="row">

            <div class="col-xs-12 col-md-9">

                <ul class="nav nav-tabs" id="myTab">
                    <li class="general active"><a href="#general" data-toggle="tab">General</a></li>
                    <li class="booking_people"><a href="#booking_people" data-toggle="tab">Agents</a></li>
                    <li class="details"><a href="#details" data-toggle="tab">Package Texts</a></li>
                    <li class="quotes"><a href="#quotes" data-toggle="tab">Quote Texts</a></li>
                    <li class="other"><a href="#other" data-toggle="tab">Other Texts</a></li>
                    <li class="voucher"><a href="#voucher" data-toggle="tab">Voucher Texts</a></li>
                    <li class="cron"><a href="#cron" data-toggle="tab">Cron Emails</a></li>
                    <li class="styles"><a href="#styles" data-toggle="tab">Styles</a></li>
                    <li class="courses"><a href="#courses" data-toggle="tab">Courses</a></li>
                    <li class="hotels"><a href="#hotels" data-toggle="tab">Hotels</a></li>

                </ul>
                <!-- Nav tabs -->

                <div class="tab-content">

                    <div class="tab-pane active" id="general">
                        <?php include('brand/_general.php'); ?>
                    </div>

                    <div class="tab-pane" id="details">
                        <?php include('brand/_details.php'); ?>
                    </div>

                    <div class="tab-pane" id="quotes">
                        <?php include('brand/_quotes.php'); ?>
                    </div>

                    <div class="tab-pane" id="other">
                        <?php include('brand/_other.php'); ?>
                    </div>

                    <div class="tab-pane" id="voucher">
                        <?php include('brand/_voucher.php'); ?>
                    </div>

                    <div class="tab-pane" id="cron">
                        <?php include('brand/_cron.php'); ?>
                    </div>

                    <div class="tab-pane grid-view" id="courses">
                        <?php include('brand/_courses.php'); ?>
                    </div>

                    <div class="tab-pane grid-view" id="hotels">
                        <?php include('brand/_hotels.php'); ?>
                    </div>

                    <div class="tab-pane grid-view" id="booking_people">
                        <?php include('brand/_booking_people.php'); ?>
                    </div>

                    <div class="tab-pane" id="styles">
                        <?php include('brand/_styles.php'); ?>
                    </div>

                </div> <!-- tab content -->


            </div>

            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>


                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Logo Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="display_image" class="sr-only">Display Image:</label>
                            <input type="file" name="display_image" id="display_image" class="form-control">
                        </div>

                        <?php if (!empty($this->objModel->strDisplayImage)) { ?>
                        <div class="well well-sm"><?php Util::displayThumb($this->objModel->strDisplayImage, 333, 150, 3); ?></div>
                        <div class="checkbox">
                            <label><input type="checkbox" name="files_to_delete[display_image]" id="files_to_delete" value="<?php echo $this->objModel->strDisplayImage; ?>"> Remove Image</label>
                        </div>
                        <?php } ?>
                    </div>
                </div>

            </div>


        </div>
    </form>
</div>

<script type="text/javascript">
    $(document).ready(function(e) {
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
          var target = $(e.target).attr("href") // activated tab
          target + ' div.jHtmlArea iframe'
          $(target + ' div.jHtmlArea iframe').attr('style', 'width: 100px; height: 850px;');
        });
    });
</script>

<?php if($this->tab != '') { ?>
<script type="text/javascript">
    $('#myTab li').removeClass('active');
    $('.tab-pane').removeClass('active');
    $('#<?php echo $this->tab;?>').addClass('active');
    //
    $('#myTab li.<?php echo $this->tab;?>').addClass('active');

    $(document).ready(function(e) {
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
          var target = $(e.target).attr("href") // activated tab
          alert(target);
        });
    });
</script>
<?php }


//var_dump($this);

?>
<?php //var_dump($this->page); ?>